/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.jdt.JavaElementDeleteOperation;
import org.eclipse.scout.sdk.ui.dialog.MemberSelectionDialog;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class DeleteExecutor
extends AbstractExecutor {
    private Set<IType> m_selection;

    @Override
    public boolean canRun(IStructuredSelection selection) {
        this.m_selection = UiUtility.getTypesFromSelection(selection, null);
        return this.isEditable(this.m_selection);
    }

    @Override
    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        JavaElementDeleteOperation deleteOperation = null;
        if (this.m_selection.size() == 1) {
            IType typeToDelete = (IType)CollectionUtility.firstElement(this.m_selection);
            if (TypeUtility.exists((IJavaElement)typeToDelete)) {
                MessageBox box = new MessageBox(shell, 292);
                box.setText(Texts.get((String)"Question"));
                box.setMessage(Texts.get((String)"DeleteAction_ensureRequest", (String[])new String[]{typeToDelete.getElementName()}));
                if (box.open() == 32) {
                    deleteOperation = new JavaElementDeleteOperation();
                    deleteOperation.addMember((IJavaElement)typeToDelete);
                }
            }
        } else {
            MemberSelectionDialog confirmDialog = new MemberSelectionDialog(shell, Texts.get((String)"DeleteAction_ensureRequestPlural"));
            confirmDialog.setMembers(this.m_selection);
            confirmDialog.setSelectedMembers(this.m_selection);
            if (confirmDialog.open() == 0) {
                deleteOperation = new JavaElementDeleteOperation();
                deleteOperation.setMembers(confirmDialog.getSelectedMembers());
            }
        }
        if (deleteOperation != null) {
            new OperationJob(new IOperation[]{deleteOperation}).schedule();
        }
        return null;
    }
}

