/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal.signature;

import java.util.Collection;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.signature.SignatureLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.signature.SignatureProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.styled.ISearchRangeConsumer;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;

public class SignatureSubTypeProposalProvider
extends SignatureProposalProvider {
    private IType m_baseType;
    private final IJavaProject m_classpath;

    public SignatureSubTypeProposalProvider(IType baseType, IJavaProject classpath) {
        super(SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{classpath}), new SignatureLabelProvider(), null, false);
        this.setBaseType(baseType);
        this.m_classpath = classpath;
    }

    public SignatureSubTypeProposalProvider(String baseTypeSig, IJavaProject classpath) {
        this(TypeUtility.getTypeBySignature((String)baseTypeSig), classpath);
    }

    @Override
    protected Collection<Object> collectTypes(String searchPattern, int maxResultSize, IProgressMonitor monitor) {
        if (!this.isBaseTypeDefined()) {
            return super.collectTypes(searchPattern, maxResultSize, monitor);
        }
        TreeSet<Object> signatures = new TreeSet<Object>();
        if (TypeUtility.exists((IJavaElement)this.getBaseType())) {
            boolean isFormatConcatString = false;
            if (this.getLabelProvider() instanceof ISearchRangeConsumer) {
                isFormatConcatString = ((ISearchRangeConsumer)this.getLabelProvider()).isFormatConcatString();
            }
            ContentProposalProvider.NormalizedPattern normalizedPattern = SignatureSubTypeProposalProvider.createNormalizedSearchPattern(searchPattern);
            String parentTypeSig = SignatureCache.createTypeSignature((String)this.getBaseType().getFullyQualifiedName());
            int[] matchRegions = SignatureSubTypeProposalProvider.getMatchingRegions(parentTypeSig, this.getLabelProvider().getText((Object)parentTypeSig), normalizedPattern, isFormatConcatString);
            if (matchRegions != null) {
                signatures.add(parentTypeSig);
            }
            ICachedTypeHierarchy hier = TypeUtility.getPrimaryTypeHierarchy((IType)this.getBaseType());
            for (IType t : hier.getAllSubtypes(this.getBaseType(), null, TypeComparators.getTypeNameComparator())) {
                String curSig = SignatureCache.createTypeSignature((String)t.getFullyQualifiedName());
                matchRegions = SignatureSubTypeProposalProvider.getMatchingRegions(curSig, this.getLabelProvider().getText((Object)curSig), normalizedPattern, isFormatConcatString);
                if (matchRegions == null || !TypeUtility.isOnClasspath((IJavaElement)t, (IJavaProject)this.m_classpath)) continue;
                signatures.add(curSig);
                if (signatures.size() == maxResultSize) break;
            }
        }
        return signatures;
    }

    public IType getBaseType() {
        return this.m_baseType;
    }

    private boolean isBaseTypeDefined() {
        return TypeUtility.exists((IJavaElement)this.getBaseType()) && !Object.class.getName().equals(this.getBaseType().getFullyQualifiedName());
    }

    public void setBaseType(IType baseType) {
        this.m_baseType = baseType;
        if (this.isBaseTypeDefined()) {
            this.setMostUsedSignatures(null);
        } else {
            this.setMostUsedSignatures(DEFAULT_MOST_USED);
        }
    }
}

