/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.table;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.fields.table.AutoResizeColumnTable;
import org.eclipse.scout.sdk.ui.fields.table.ISeparator;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class FilteredTable
extends Composite {
    private Text m_filterField;
    private Button m_clearFilter;
    private TableViewer m_tableViewer;
    private Table m_table;
    private P_TableFilter m_tableFilter;
    private final int m_style;

    public FilteredTable(Composite parent, int style) {
        super(parent, 0);
        this.m_style = style;
        this.m_tableFilter = new P_TableFilter();
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.createContent(this);
    }

    protected void createContent(Composite parent) {
        Control filterControl = this.createFilterControl(parent);
        this.m_table = new AutoResizeColumnTable(parent, this.m_style);
        this.m_tableViewer = new P_TableViewer(this.m_table);
        this.m_tableViewer.setFilters(new ViewerFilter[]{this.m_tableFilter});
        this.m_tableViewer.setSorter((ViewerSorter)new P_TableSorter());
        filterControl.setLayoutData((Object)new GridData(768));
        this.m_table.setLayoutData((Object)new GridData(1808));
    }

    private Control createFilterControl(Composite parent) {
        Composite filterComposite = new Composite(parent, 0);
        this.m_filterField = new Text(filterComposite, 2048);
        this.m_filterField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilteredTable.this.m_tableFilter.setFilterText(FilteredTable.this.m_filterField.getText());
                FilteredTable.this.refresh(true);
                GridData buttonData = (GridData)FilteredTable.this.m_clearFilter.getLayoutData();
                if (StringUtility.isNullOrEmpty((CharSequence)FilteredTable.this.m_filterField.getText())) {
                    buttonData.exclude = true;
                    FilteredTable.this.m_clearFilter.setEnabled(false);
                } else {
                    buttonData.exclude = false;
                    FilteredTable.this.m_clearFilter.setEnabled(true);
                }
                FilteredTable.this.m_filterField.getParent().layout(true);
            }
        });
        this.m_filterField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    FilteredTable.this.m_table.setFocus();
                }
            }
        });
        this.m_clearFilter = new Button(filterComposite, 0x880008);
        this.m_clearFilter.setImage(ScoutSdkUi.getImage("delete.gif"));
        this.m_clearFilter.setEnabled(false);
        this.m_clearFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteredTable.this.m_filterField.setText("");
                FilteredTable.this.m_filterField.setFocus();
            }
        });
        filterComposite.setTabList(new Control[]{this.m_filterField});
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        filterComposite.setLayout((Layout)layout);
        this.m_filterField.setLayoutData((Object)new GridData(768));
        GridData clearFieldData = new GridData(20, 20);
        clearFieldData.horizontalIndent = 3;
        clearFieldData.exclude = true;
        this.m_clearFilter.setLayoutData((Object)clearFieldData);
        return filterComposite;
    }

    public void refresh(boolean selectFirst) {
        this.m_tableViewer.refresh();
        if (selectFirst) {
            StructuredSelection selection = new StructuredSelection();
            if (this.m_tableViewer.getTable().getItemCount() > 0) {
                Object data = this.m_table.getItem(0).getData();
                selection = new StructuredSelection(data);
            }
            this.m_tableViewer.setSelection((ISelection)selection);
        }
    }

    public Table getTable() {
        return this.m_table;
    }

    public TableViewer getViewer() {
        return this.m_tableViewer;
    }

    public void setEnabled(boolean enabled) {
        this.m_table.setEnabled(enabled);
        this.m_filterField.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public boolean isEnabled() {
        if (this.m_table.getEnabled() && this.m_filterField.getEnabled()) {
            return super.isEnabled();
        }
        return false;
    }

    public boolean getEnabled() {
        return this.m_table.getEnabled() && this.m_filterField.getEnabled();
    }

    private final class P_FilterResult {
        private final String m_text;
        private final int[] m_matchingRegions;
        private final String m_pattern;

        private P_FilterResult(String pattern, String text, int[] matchingRegions) {
            this.m_pattern = pattern;
            this.m_text = text;
            this.m_matchingRegions = matchingRegions;
        }

        public String getPattern() {
            return this.m_pattern;
        }

        public String getText() {
            return this.m_text;
        }

        public int[] getMatchingRegions() {
            return this.m_matchingRegions;
        }
    }

    private final class P_StyledLabelProvider
    extends StyledCellLabelProvider {
        private final IBaseLabelProvider m_wrappedLabelProvider;
        private Font m_boldFont;
        private StyledString.Styler m_boldStyler;

        private P_StyledLabelProvider(IBaseLabelProvider labelProvider) {
            this.m_wrappedLabelProvider = labelProvider;
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.m_wrappedLabelProvider.isLabelProperty(element, property);
        }

        public void initialize(ColumnViewer viewer, ViewerColumn column) {
            super.initialize(viewer, column);
            Font defaultFont = viewer.getControl().getFont();
            FontData[] defaultFontData = defaultFont.getFontData();
            FontData[] boldFontData = new FontData[defaultFontData.length];
            int i = 0;
            while (i < defaultFontData.length) {
                boldFontData[i] = new FontData(defaultFontData[i].getName(), defaultFontData[i].getHeight(), defaultFontData[i].getStyle() | 1);
                ++i;
            }
            this.m_boldFont = new Font((Device)viewer.getControl().getDisplay(), boldFontData);
            this.m_boldStyler = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.font = P_StyledLabelProvider.this.m_boldFont;
                }
            };
        }

        public void dispose() {
            super.dispose();
            this.m_wrappedLabelProvider.dispose();
            this.m_boldFont.dispose();
            this.m_boldFont = null;
        }

        public void update(ViewerCell cell) {
            P_FilterResult filterResult;
            Object element = cell.getElement();
            StyledString text = new StyledString(this.getText(element, cell.getColumnIndex()));
            if (cell.getColumnIndex() == 0 && (filterResult = FilteredTable.this.m_tableFilter.getFilterResult((Viewer)this.getViewer(), element)) != null && !"*".equals(filterResult.getPattern())) {
                int index;
                int[] matchingRegions = filterResult.getMatchingRegions();
                if (matchingRegions != null && matchingRegions.length > 0) {
                    int i = 0;
                    while (i < matchingRegions.length - 1) {
                        text.setStyle(matchingRegions[i], matchingRegions[i + 1], this.m_boldStyler);
                        i += 2;
                    }
                }
                if (!StringUtility.isNullOrEmpty((CharSequence)filterResult.getText()) && (index = filterResult.getText().indexOf(JavaElementLabels.CONCAT_STRING)) > 0) {
                    text.setStyle(index, text.length() - index, StyledString.QUALIFIER_STYLER);
                }
            }
            cell.setText(text.getString());
            cell.setStyleRanges(text.getStyleRanges());
            cell.setImage(this.getImage(element, cell.getColumnIndex()));
            super.update(cell);
        }

        private String getText(Object element, int columnIndex) {
            if (this.m_wrappedLabelProvider instanceof ITableLabelProvider) {
                return ((ITableLabelProvider)this.m_wrappedLabelProvider).getColumnText(element, columnIndex);
            }
            if (this.m_wrappedLabelProvider instanceof ILabelProvider) {
                return ((ILabelProvider)this.m_wrappedLabelProvider).getText(element);
            }
            return null;
        }

        private Image getImage(Object element, int columnIndex) {
            if (this.m_wrappedLabelProvider instanceof ITableLabelProvider) {
                return ((ITableLabelProvider)this.m_wrappedLabelProvider).getColumnImage(element, columnIndex);
            }
            if (this.m_wrappedLabelProvider instanceof ILabelProvider) {
                return ((ILabelProvider)this.m_wrappedLabelProvider).getImage(element);
            }
            return null;
        }
    }

    private final class P_TableFilter
    extends ViewerFilter {
        private static final char END_SYMBOL = '<';
        private static final char ANY_STRING = '*';
        private static final char BLANK = ' ';
        private static final String DATA_FILTER_RESULT_PREFIX = "filterResult";
        private int m_matchKind;
        private String m_pattern;

        private P_TableFilter() {
            this.setFilterText("*");
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            int index;
            if (element instanceof ISeparator) {
                return true;
            }
            String text = ((P_StyledLabelProvider)FilteredTable.this.getViewer().getLabelProvider()).getText(element, 0);
            String filterText = text;
            if (!StringUtility.isNullOrEmpty((CharSequence)filterText) && (index = text.indexOf(JavaElementLabels.CONCAT_STRING)) > -1) {
                filterText = filterText.substring(0, index);
            }
            int[] matchingRegions = SearchPattern.getMatchingRegions((String)this.m_pattern, (String)filterText, (int)this.m_matchKind);
            viewer.setData(DATA_FILTER_RESULT_PREFIX + Integer.toString(element.hashCode()), (Object)new P_FilterResult(this.m_pattern, text, matchingRegions));
            return matchingRegions != null;
        }

        public void setFilterText(String filterText) {
            if (StringUtility.isNullOrEmpty((CharSequence)filterText)) {
                filterText = "*";
            }
            this.initializePatternAndMatchKind(filterText);
        }

        private void initializePatternAndMatchKind(String pattern) {
            int length = pattern.length();
            if (length == 0) {
                this.m_matchKind = 0;
                this.m_pattern = pattern;
                return;
            }
            char last = pattern.charAt(length - 1);
            if (pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1) {
                this.m_matchKind = 2;
                switch (last) {
                    case ' ': 
                    case '<': {
                        this.m_pattern = pattern.substring(0, length - 1);
                        break;
                    }
                    case '*': {
                        this.m_pattern = pattern;
                        break;
                    }
                    default: {
                        this.m_pattern = String.valueOf(pattern) + '*';
                    }
                }
                return;
            }
            if (last == '<' || last == ' ') {
                this.m_pattern = pattern.substring(0, length - 1);
                this.m_matchKind = SearchPattern.validateMatchRule((String)this.m_pattern, (int)256) == 256 ? 256 : 0;
                return;
            }
            if (SearchPattern.validateMatchRule((String)pattern, (int)128) == 128) {
                this.m_matchKind = 128;
                this.m_pattern = pattern;
                return;
            }
            this.m_matchKind = 1;
            this.m_pattern = pattern;
        }

        public P_FilterResult getFilterResult(Viewer viewer, Object element) {
            if (viewer == null) {
                return null;
            }
            String key = DATA_FILTER_RESULT_PREFIX + Integer.toString(element.hashCode());
            return (P_FilterResult)viewer.getData(key);
        }
    }

    private final class P_TableSorter
    extends ViewerSorter {
        private P_TableSorter() {
        }

        public void sort(Viewer viewer, Object[] elements) {
            super.sort(viewer, elements);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IBaseLabelProvider provider = FilteredTable.this.getViewer().getLabelProvider();
            if (provider instanceof ITableLabelProvider) {
                ITableLabelProvider labelProvider = (ITableLabelProvider)provider;
                return labelProvider.getColumnText(e1, 0).compareTo(labelProvider.getColumnText(e2, 0));
            }
            return -1;
        }
    }

    private final class P_TableViewer
    extends TableViewer {
        public P_TableViewer(Table table) {
            super(table);
        }

        public void setLabelProvider(IBaseLabelProvider labelProvider) {
            if (!(labelProvider instanceof ITableLabelProvider) && !(labelProvider instanceof ILabelProvider)) {
                throw new IllegalArgumentException("only allows ITableLabelProvider and ILabelProvider subtypes.");
            }
            super.setLabelProvider((IBaseLabelProvider)new P_StyledLabelProvider(labelProvider));
        }

        protected Object[] getSortedChildren(Object parentNode) {
            ArrayList cleanedElements = CollectionUtility.arrayList((Object[])super.getSortedChildren(parentNode));
            boolean removeNextSeperator = true;
            Iterator it = cleanedElements.iterator();
            while (it.hasNext()) {
                Object cur = it.next();
                if (cur instanceof ISeparator) {
                    if (removeNextSeperator || !it.hasNext()) {
                        it.remove();
                    }
                    removeNextSeperator = true;
                    continue;
                }
                removeNextSeperator = false;
            }
            return cleanedElements.toArray(new Object[cleanedElements.size()]);
        }
    }
}

