/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.view.property;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.extensions.view.property.IMultiPropertyViewPart;
import org.eclipse.scout.sdk.ui.extensions.view.property.ISinglePropertyViewPart;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.view.property.PropertyViewExtension;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.osgi.framework.Bundle;

public final class PropertyViewExtensionPoint {
    private static final String PROPERTY_VIEW_EXTENSION_ID = "propertyViewPart";
    private static final Object LOCK = new Object();
    private static volatile List<PropertyViewExtension> viewExtensions = null;

    private PropertyViewExtensionPoint() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<PropertyViewExtension> getExtensions() {
        if (viewExtensions == null) {
            Object object = LOCK;
            synchronized (object) {
                if (viewExtensions == null) {
                    try {
                        IExtension[] extensions;
                        HashMap<Class<IPage>, PropertyViewExtension> tmp = new HashMap<Class<IPage>, PropertyViewExtension>();
                        IExtensionRegistry reg = Platform.getExtensionRegistry();
                        IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", PROPERTY_VIEW_EXTENSION_ID);
                        IExtension[] iExtensionArray = extensions = xp.getExtensions();
                        int n = extensions.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IExtension extension = iExtensionArray[n2];
                            Bundle contributerBundle = Platform.getBundle((String)extension.getNamespaceIdentifier());
                            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                            int n3 = iConfigurationElementArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IConfigurationElement partExtension = iConfigurationElementArray[n4];
                                if ("part".equals(partExtension.getName())) {
                                    Class<IPage> pageClass;
                                    PropertyViewExtension pageExt;
                                    long ranking = -1L;
                                    String rankingAttribute = partExtension.getAttribute("ranking");
                                    if (!StringUtility.isNullOrEmpty((CharSequence)rankingAttribute)) {
                                        ranking = Long.parseLong(rankingAttribute);
                                    }
                                    if ((pageExt = (PropertyViewExtension)tmp.get(pageClass = PropertyViewExtensionPoint.getClassOfElement(contributerBundle, partExtension.getAttribute("page"), IPage.class))) == null) {
                                        pageExt = new PropertyViewExtension();
                                        pageExt.setPageClass(pageClass);
                                        tmp.put(pageClass, pageExt);
                                    }
                                    IConfigurationElement[] iConfigurationElementArray2 = partExtension.getChildren();
                                    int n5 = iConfigurationElementArray2.length;
                                    int n6 = 0;
                                    while (n6 < n5) {
                                        IConfigurationElement part = iConfigurationElementArray2[n6];
                                        if ("singlePart".equals(part.getName())) {
                                            pageExt.setSingleViewPartClazz(PropertyViewExtensionPoint.getClassOfElement(contributerBundle, part.getAttribute("viewPart"), ISinglePropertyViewPart.class), ranking);
                                        } else if ("multiPart".equals(part.getName())) {
                                            pageExt.setMultiViewPartClazz(PropertyViewExtensionPoint.getClassOfElement(contributerBundle, part.getAttribute("viewPart"), IMultiPropertyViewPart.class), ranking);
                                        }
                                        ++n6;
                                    }
                                }
                                ++n4;
                            }
                            ++n2;
                        }
                        TreeMap<CompositeObject, PropertyViewExtension> orderedExtensions = new TreeMap<CompositeObject, PropertyViewExtension>();
                        for (PropertyViewExtension ext : tmp.values()) {
                            try {
                                int distanceToIPage = PropertyViewExtensionPoint.distanceToIPage(ext.getPageClass(), 0);
                                orderedExtensions.put(new CompositeObject(new Object[]{-distanceToIPage, ext}), ext);
                            }
                            catch (Exception t) {
                                ScoutSdkUi.logError("Could not determ load extension '" + ext.toString() + "'!", t);
                            }
                        }
                        viewExtensions = CollectionUtility.arrayList(orderedExtensions.values());
                    }
                    catch (Exception e) {
                        ScoutSdkUi.logError("Error during reading property view extensions.", e);
                    }
                }
            }
        }
        return viewExtensions;
    }

    private static <T> Class<? extends T> getClassOfElement(Bundle bundle, String clazzName, Class<T> t) {
        Class clazz = null;
        if (bundle != null && !StringUtility.isNullOrEmpty((CharSequence)clazzName)) {
            try {
                clazz = bundle.loadClass(clazzName);
            }
            catch (Exception tt) {
                ScoutSdkUi.logWarning("could not load class '" + clazzName + "' of bunlde '" + bundle.getSymbolicName() + "'.", tt);
            }
        }
        return clazz;
    }

    private static int distanceToIPage(Class<?> visitee, int dist) {
        Class<?>[] interfaces;
        if (visitee == null) {
            throw new IllegalArgumentException("try to determ the distance to IPage of a instance not in subhierarchy of IPage.");
        }
        if (IPage.class.equals(visitee)) {
            return dist;
        }
        int locDist = 100000;
        Class<?> superclass = visitee.getSuperclass();
        if (superclass != null) {
            locDist = PropertyViewExtensionPoint.distanceToIPage(superclass, dist + 1);
        }
        if ((interfaces = visitee.getInterfaces()) != null) {
            Class<?>[] classArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> i = classArray[n2];
                locDist = Math.min(locDist, PropertyViewExtensionPoint.distanceToIPage(i, dist + 1));
                ++n2;
            }
        }
        dist = locDist;
        return dist;
    }

    public static ISinglePropertyViewPart createSinglePageViewPart(IPage page) {
        return PropertyViewExtensionPoint.createSinglePageViewPartImpl(page);
    }

    private static ISinglePropertyViewPart createSinglePageViewPartImpl(IPage page) {
        for (PropertyViewExtension ext : PropertyViewExtensionPoint.getExtensions()) {
            if (!ext.getPageClass().isAssignableFrom(page.getClass()) || ext.getSingleViewPartClazz() == null) continue;
            return ext.createSingleViewPart();
        }
        return null;
    }

    public static IMultiPropertyViewPart createMultiPageViewPart(IPage[] pages) {
        return PropertyViewExtensionPoint.createMultiPageViewPartImpl(pages);
    }

    private static IMultiPropertyViewPart createMultiPageViewPartImpl(IPage[] pages) {
        Class<? extends IPage> commonClazz = PropertyViewExtensionPoint.findCommonPage(pages);
        for (PropertyViewExtension ext : PropertyViewExtensionPoint.getExtensions()) {
            if (!ext.getPageClass().isAssignableFrom(commonClazz) || ext.getMultiViewPartClazz() == null) continue;
            return ext.createMultiViewPart();
        }
        return null;
    }

    private static Class<? extends IPage> findCommonPage(IPage[] pages) {
        if (pages == null || pages.length == 0) {
            return null;
        }
        if (pages.length == 1) {
            return pages[0].getClass();
        }
        ArrayList pageClasses = new ArrayList();
        Class<?> visClazz = pages[0].getClass();
        while (visClazz != null && !visClazz.equals(Object.class)) {
            pageClasses.add(visClazz);
            visClazz = visClazz.getSuperclass();
            if (visClazz.equals(IPage.class)) break;
        }
        int i = 1;
        while (i < pages.length) {
            ArrayList visClasses = new ArrayList();
            visClazz = pages[i].getClass();
            while (visClazz != null && !visClazz.equals(Object.class)) {
                if (pageClasses.contains(visClazz)) {
                    visClasses.add(visClazz);
                }
                if ((visClazz = visClazz.getSuperclass()).equals(IPage.class)) break;
            }
            pageClasses = visClasses;
            ++i;
        }
        if (pageClasses.size() > 0) {
            return (Class)pageClasses.get(0);
        }
        return null;
    }
}

