/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form.fields.composerfield.attribute;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.operation.form.field.composer.ComposerAttributeNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementAbstractTypeContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class AttributeNewWizardPage
extends AbstractWorkspaceWizardPage {
    private final IType iDataModelAttribute = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.data.model.IDataModelAttribute");
    public static final String PROP_NLS_NAME = "nlsName";
    public static final String PROP_TYPE_NAME = "typeName";
    public static final String PROP_SUPER_TYPE = "superType";
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private final IType m_declaringType;
    private final IType m_defaultComposerAttribute;
    private IType m_createdAttribtue;

    public AttributeNewWizardPage(IType declaringType) {
        super(AttributeNewWizardPage.class.getName());
        this.setTitle(Texts.get((String)"NewAttribute"));
        this.setDescription(Texts.get((String)"CreateANewComposerFieldAttribute"));
        this.m_declaringType = declaringType;
        this.m_defaultComposerAttribute = RuntimeClasses.getSuperType((String)"org.eclipse.scout.rt.shared.data.model.IDataModelAttribute", (IJavaProject)this.m_declaringType.getJavaProject());
        this.setSuperTypeInternal(this.m_defaultComposerAttribute);
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, ScoutTypeUtility.findNlsProject((IJavaElement)this.m_declaringType), Texts.get((String)"PropText"));
        this.m_nlsNameField.acceptProposal(this.getNlsName());
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    AttributeNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = AttributeNewWizardPage.this.getNlsName();
                    INlsEntry newEntry = (INlsEntry)event.proposal;
                    AttributeNewWizardPage.this.setNlsNameInternal(newEntry);
                    if (newEntry != null && (oldEntry == null || oldEntry.getKey().equals(AttributeNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((CharSequence)AttributeNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        AttributeNewWizardPage.this.m_typeNameField.setText(NamingUtility.toJavaCamelCase((String)newEntry.getKey(), (boolean)false));
                    }
                }
                finally {
                    AttributeNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"));
        this.m_typeNameField.setReadOnlySuffix("Attribute");
        this.m_typeNameField.setText(this.getTypeName());
        this.setTypeNameInternal(this.m_typeNameField.getText());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AttributeNewWizardPage.this.setTypeNameInternal(AttributeNewWizardPage.this.m_typeNameField.getText());
                AttributeNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"SuperType"), new JavaElementAbstractTypeContentProvider(this.iDataModelAttribute, this.m_declaringType.getJavaProject(), this.m_defaultComposerAttribute));
        this.m_superTypeField.acceptProposal(this.getSuperType());
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                AttributeNewWizardPage.this.setSuperTypeInternal((IType)event.proposal);
                AttributeNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        IType superTypeProp;
        ComposerAttributeNewOperation operation = new ComposerAttributeNewOperation(this.getTypeName(), this.m_declaringType);
        if (this.getNlsName() != null) {
            operation.setNlsEntry(this.getNlsName());
        }
        if ((superTypeProp = this.getSuperType()) != null) {
            operation.setSuperTypeSignature(SignatureCache.createTypeSignature((String)superTypeProp.getFullyQualifiedName()));
        }
        IStructuredType structuredType = ScoutTypeUtility.createStructuredComposer((IType)this.m_declaringType);
        operation.setSibling(structuredType.getSiblingComposerAttribute(this.getTypeName()));
        operation.run(monitor, workingCopyManager);
        this.m_createdAttribtue = operation.getCreatedType();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        IStatus javaFieldNameStatus = ScoutUtility.validateJavaName((String)this.getTypeName(), (String)"Attribute");
        if (javaFieldNameStatus.getSeverity() > 2) {
            return javaFieldNameStatus;
        }
        if (TypeUtility.exists((IJavaElement)this.m_declaringType.getType(this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        return javaFieldNameStatus;
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public IType getCreatedAttribute() {
        return this.m_createdAttribtue;
    }

    public INlsEntry getNlsName() {
        return (INlsEntry)this.getProperty(PROP_NLS_NAME);
    }

    public void setNlsName(INlsEntry nlsName) {
        try {
            this.setStateChanging(true);
            this.setNlsNameInternal(nlsName);
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setNlsNameInternal(INlsEntry nlsName) {
        this.setProperty(PROP_NLS_NAME, nlsName);
    }

    public String getTypeName() {
        return this.getPropertyString(PROP_TYPE_NAME);
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTypeNameInternal(String typeName) {
        this.setPropertyString(PROP_TYPE_NAME, typeName);
    }

    public IType getSuperType() {
        return (IType)this.getProperty(PROP_SUPER_TYPE);
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.setSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setSuperTypeInternal(IType superType) {
        this.setProperty(PROP_SUPER_TYPE, superType);
    }
}

