/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form.fields.smartfield;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.form.field.SmartFieldNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.signature.SignatureProposalProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class SmartFieldNewWizardPage
extends AbstractWorkspaceWizardPage {
    private INlsEntry m_nlsName;
    private String m_typeName;
    private IType m_superType;
    private String m_genericSignature;
    private IType m_codeType;
    private IType m_lookupCall;
    private SiblingProposal m_sibling;
    private boolean m_codeTypeDefinesGenericType;
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_genericTypeField;
    private ProposalTextField m_codeTypeField;
    private ProposalTextField m_lookupCallField;
    private ProposalTextField m_siblingField;
    private final IType m_declaringType;
    private final String m_title;
    private final String m_desc;
    private IType m_createdField;

    public SmartFieldNewWizardPage(IType declaringType, String title, String desc, IType superType) {
        super(SmartFieldNewWizardPage.class.getName());
        this.m_declaringType = declaringType;
        this.setSuperType(superType);
        this.m_genericSignature = SignatureCache.createTypeSignature((String)Long.class.getName());
        this.m_codeTypeDefinesGenericType = false;
        this.m_title = title;
        this.m_desc = desc;
    }

    @Override
    protected void createContent(Composite parent) {
        this.setTitle(this.m_title);
        this.setDescription(this.m_desc);
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, ScoutTypeUtility.findNlsProject((IJavaElement)this.m_declaringType), Texts.get((String)"PropLabel"));
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    SmartFieldNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = SmartFieldNewWizardPage.this.getNlsName();
                    SmartFieldNewWizardPage.this.m_nlsName = (INlsEntry)event.proposal;
                    if (SmartFieldNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(SmartFieldNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((CharSequence)SmartFieldNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        SmartFieldNewWizardPage.this.m_typeNameField.setText(NamingUtility.toJavaCamelCase((String)SmartFieldNewWizardPage.this.m_nlsName.getKey(), (boolean)false));
                    }
                }
                finally {
                    SmartFieldNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"));
        this.m_typeNameField.setReadOnlySuffix("Field");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeName = this.m_typeNameField.getText();
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SmartFieldNewWizardPage.this.m_typeName = SmartFieldNewWizardPage.this.m_typeNameField.getText();
                SmartFieldNewWizardPage.this.pingStateChanging();
            }
        });
        final AbstractJavaElementContentProvider codeTypeContentProvider = new AbstractJavaElementContentProvider(){

            @Override
            protected Object[][] computeProposals() {
                IType iCodeType = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.code.ICodeType");
                Set codeTypes = TypeUtility.getClassesOnClasspath((IType)iCodeType, (IJavaProject)SmartFieldNewWizardPage.this.m_declaringType.getJavaProject(), (ITypeFilter)TypeFilters.getTypeParamSubTypeFilter((String)SmartFieldNewWizardPage.this.getGenericSignature(), (String)"org.eclipse.scout.rt.shared.services.common.code.ICodeType", (int)1));
                return new Object[][]{codeTypes.toArray(new IType[codeTypes.size()])};
            }
        };
        final AbstractJavaElementContentProvider lookupCallContentProvider = new AbstractJavaElementContentProvider(){

            @Override
            protected Object[][] computeProposals() {
                IType iLookupCall = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.lookup.ILookupCall");
                ITypeFilter filter = TypeFilters.getMultiTypeFilterAnd((ITypeFilter[])new ITypeFilter[]{TypeFilters.getNoGenericTypesFilter(), TypeFilters.getTypeParamSubTypeFilter((String)SmartFieldNewWizardPage.this.getGenericSignature(), (String)"org.eclipse.scout.rt.shared.services.lookup.ILookupCall", (int)0)});
                Set codeTypes = TypeUtility.getClassesOnClasspath((IType)iLookupCall, (IJavaProject)SmartFieldNewWizardPage.this.m_declaringType.getJavaProject(), (ITypeFilter)filter);
                return new Object[][]{codeTypes.toArray(new IType[codeTypes.size()])};
            }
        };
        this.m_genericTypeField = this.getFieldToolkit().createSignatureProposalField(parent, Texts.get((String)"GenericType"), ScoutTypeUtility.getScoutBundle((IJavaElement)this.m_declaringType), SignatureProposalProvider.DEFAULT_MOST_USED);
        this.m_genericTypeField.acceptProposal(this.getGenericSignature());
        this.m_genericTypeField.setEnabled(TypeUtility.isGenericType((IType)this.getSuperType()));
        this.m_genericTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                SmartFieldNewWizardPage.this.m_genericSignature = (String)event.proposal;
                codeTypeContentProvider.invalidateCache();
                lookupCallContentProvider.invalidateCache();
                SmartFieldNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_codeTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"CodeType"), codeTypeContentProvider);
        this.m_codeTypeField.acceptProposal(this.getCodeType());
        this.m_codeTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    SmartFieldNewWizardPage.this.m_codeType = (IType)event.proposal;
                    SmartFieldNewWizardPage.this.m_lookupCallField.acceptProposal(null);
                    SmartFieldNewWizardPage.this.m_lookupCallField.setEnabled(SmartFieldNewWizardPage.this.m_codeType == null);
                    SmartFieldNewWizardPage.this.readGenericType(SmartFieldNewWizardPage.this.m_codeType, SmartFieldNewWizardPage.this.getCodeTypeGenericTypeSignature());
                }
                finally {
                    SmartFieldNewWizardPage.this.setStateChanging(false);
                }
                SmartFieldNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_lookupCallField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"LookupCall"), lookupCallContentProvider);
        this.m_lookupCallField.acceptProposal(this.getLookupCall());
        this.m_lookupCallField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    SmartFieldNewWizardPage.this.setStateChanging(true);
                    SmartFieldNewWizardPage.this.m_lookupCall = (IType)event.proposal;
                    SmartFieldNewWizardPage.this.m_codeTypeField.acceptProposal(null);
                    SmartFieldNewWizardPage.this.m_codeTypeField.setEnabled(SmartFieldNewWizardPage.this.m_lookupCall == null);
                    SmartFieldNewWizardPage.this.readGenericType(SmartFieldNewWizardPage.this.m_lookupCall, SmartFieldNewWizardPage.this.getLookupCallGenericTypeSignature());
                }
                finally {
                    SmartFieldNewWizardPage.this.setStateChanging(false);
                }
                SmartFieldNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_siblingField = this.getFieldToolkit().createFormFieldSiblingProposalField(parent, this.m_declaringType);
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                SmartFieldNewWizardPage.this.m_sibling = (SiblingProposal)event.proposal;
                SmartFieldNewWizardPage.this.pingStateChanging();
            }
        });
        if (this.m_sibling == null) {
            this.m_sibling = (SiblingProposal)this.m_siblingField.getSelectedProposal();
        } else {
            this.m_siblingField.acceptProposal(this.m_sibling);
        }
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_genericTypeField.setLayoutData(new GridData(768));
        this.m_codeTypeField.setLayoutData(new GridData(768));
        this.m_lookupCallField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
    }

    private String getCodeTypeGenericTypeSignature() {
        try {
            return ScoutTypeUtility.getCodeIdGenericTypeSignature((IType)this.m_codeType);
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("Could not compute generic type of code type '" + this.m_codeType.getFullyQualifiedName() + "'.", e);
            return null;
        }
    }

    private String getLookupCallGenericTypeSignature() {
        if (this.m_lookupCall == null) {
            return null;
        }
        try {
            return SignatureUtility.resolveTypeParameter((IType)this.m_lookupCall, (String)"org.eclipse.scout.rt.shared.services.lookup.ILookupCall", (int)0);
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("Could not compute generic type of lookup call '" + this.m_lookupCall.getFullyQualifiedName() + "'.", e);
            return null;
        }
    }

    private void readGenericType(IType genericDefiningType, String signature) {
        this.m_codeTypeDefinesGenericType = false;
        if (TypeUtility.exists((IJavaElement)genericDefiningType) && signature != null) {
            this.m_codeTypeDefinesGenericType = true;
            this.m_genericSignature = signature;
            this.m_genericTypeField.acceptProposal(this.getGenericSignature());
        }
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        SmartFieldNewOperation operation = new SmartFieldNewOperation(this.getTypeName(), this.m_declaringType, true);
        operation.setFormatSource(true);
        if (this.getNlsName() != null) {
            operation.setNlsEntry(this.getNlsName());
        }
        if (this.getSuperType() != null) {
            String sig = null;
            sig = this.getGenericSignature() != null ? SignatureCache.createTypeSignature((String)(String.valueOf(this.getSuperType().getFullyQualifiedName()) + '<' + Signature.toString((String)this.getGenericSignature()) + '>')) : SignatureCache.createTypeSignature((String)this.getSuperType().getFullyQualifiedName());
            operation.setSuperTypeSignature(sig);
        }
        operation.setCodeType(this.getCodeType());
        operation.setLookupCall(this.getLookupCall());
        if (this.getSibling() == SiblingProposal.SIBLING_END || this.getSibling() == null) {
            IStructuredType structuredType = ScoutTypeUtility.createStructuredCompositeField((IType)this.m_declaringType);
            operation.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_FORM_FIELD));
        } else {
            operation.setSibling(this.getSibling().getElement());
        }
        operation.run(monitor, workingCopyManager);
        this.m_createdField = operation.getCreatedField();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusNameField());
        multiStatus.add(this.getStatusGenericType());
        multiStatus.add(this.getStatusGenericTypeToLookupCall());
        multiStatus.add(this.getStatusGenericTypeToCodeType());
        if (this.isControlCreated()) {
            this.m_genericTypeField.setEnabled(TypeUtility.isGenericType((IType)this.getSuperType()) && !this.m_codeTypeDefinesGenericType);
        }
    }

    protected IType getGenericType(IType t, String genericDefiningType, int paramIndex) {
        if (TypeUtility.exists((IJavaElement)t)) {
            try {
                String typeParamSig = SignatureUtility.resolveTypeParameter((IType)t, (String)genericDefiningType, (int)paramIndex);
                if (typeParamSig != null) {
                    return TypeUtility.getTypeBySignature((String)typeParamSig);
                }
            }
            catch (CoreException e) {
                ScoutSdkUi.logError(e);
            }
        }
        return null;
    }

    protected IStatus getStatusGenericTypeToLookupCall() {
        IType generic;
        IType lookupCallKeyType;
        if (this.getLookupCall() != null && TypeUtility.exists((IJavaElement)(lookupCallKeyType = this.getGenericType(this.getLookupCall(), "org.eclipse.scout.rt.shared.services.lookup.ILookupCall", 0))) && TypeUtility.exists((IJavaElement)(generic = TypeUtility.getTypeBySignature((String)this.getGenericSignature()))) && !TypeUtility.getSupertypeHierarchy((IType)generic).contains(lookupCallKeyType)) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"LookupCallDoesNotMatchGeneric"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusGenericTypeToCodeType() {
        IType generic;
        IType codeTypeKeyType;
        if (this.getCodeType() != null && TypeUtility.exists((IJavaElement)(codeTypeKeyType = this.getGenericType(this.getCodeType(), "org.eclipse.scout.rt.shared.services.common.code.ICodeType", 1))) && TypeUtility.exists((IJavaElement)(generic = TypeUtility.getTypeBySignature((String)this.getGenericSignature()))) && !TypeUtility.getSupertypeHierarchy((IType)generic).contains(codeTypeKeyType)) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"CodeTypeDoesNotMatchGeneric"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusNameField() {
        return ScoutUtility.validateFormFieldName((String)this.getTypeName(), (String)"Field", (IType)this.m_declaringType);
    }

    protected IStatus getStatusGenericType() {
        if (TypeUtility.isGenericType((IType)this.getSuperType()) && this.getGenericSignature() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"GenericTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public IType getCreatedField() {
        return this.m_createdField;
    }

    public INlsEntry getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(INlsEntry nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        this.m_superType = superType;
    }

    public void setGenericSignature(String genericSignature) {
        try {
            this.setStateChanging(true);
            this.m_genericSignature = genericSignature;
            if (this.isControlCreated()) {
                this.m_genericTypeField.acceptProposal(genericSignature);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getGenericSignature() {
        return this.m_genericSignature;
    }

    public void setCodeType(IType codeType) {
        try {
            this.setStateChanging(true);
            this.m_codeType = codeType;
            if (this.isControlCreated()) {
                this.m_codeTypeField.acceptProposal(codeType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getCodeType() {
        return this.m_codeType;
    }

    public void setLookupCall(IType lookupCall) {
        try {
            this.setStateChanging(true);
            this.m_lookupCall = lookupCall;
            if (this.isControlCreated()) {
                this.m_codeTypeField.acceptProposal(lookupCall);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getLookupCall() {
        return this.m_lookupCall;
    }

    public SiblingProposal getSibling() {
        return this.m_sibling;
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.m_sibling = sibling;
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

