/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.page;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.page.LinkPageOperation;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class PageLinkWizardPage
extends AbstractWorkspaceWizardPage {
    private final IType iPage = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage");
    private final IType iOutline = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.IOutline");
    private IType m_holderType;
    private IType m_pageType;
    private ProposalTextField m_holderTypeField;
    private ProposalTextField m_pageTypeField;
    private LinkPageOperation m_operation;
    private IScoutBundle m_clientBundle;

    public PageLinkWizardPage(IScoutBundle clientBundle) {
        super(PageLinkWizardPage.class.getName());
        this.m_clientBundle = clientBundle;
        this.setTitle(Texts.get((String)"LinkPage"));
        this.setDescription(Texts.get((String)"LinkPageToAPageHolder"));
        this.setOperation(new LinkPageOperation());
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_pageTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"Page"), new AbstractJavaElementContentProvider(){

            @Override
            protected Object[][] computeProposals() {
                Set pages = TypeUtility.getClassesOnClasspath((IType)PageLinkWizardPage.this.iPage, (IJavaProject)PageLinkWizardPage.this.getClientBundle().getJavaProject(), null);
                return new Object[][]{pages.toArray(new IType[pages.size()])};
            }
        });
        this.m_pageTypeField.acceptProposal(this.getPageType());
        this.m_pageTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                PageLinkWizardPage.this.setPageType((IType)event.proposal);
                PageLinkWizardPage.this.pingStateChanging();
            }
        });
        this.m_holderTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"HolderPageOutline"), new AbstractJavaElementContentProvider(){

            @Override
            protected Object[][] computeProposals() {
                Set types = TypeUtility.getClassesOnClasspath((IType)PageLinkWizardPage.this.iPage, (IJavaProject)PageLinkWizardPage.this.getClientBundle().getJavaProject(), null);
                types.addAll(TypeUtility.getClassesOnClasspath((IType)PageLinkWizardPage.this.iOutline, (IJavaProject)PageLinkWizardPage.this.getClientBundle().getJavaProject(), null));
                return new Object[][]{types.toArray(new IType[types.size()])};
            }
        });
        this.m_holderTypeField.acceptProposal(this.getHolderType());
        this.m_holderTypeField.setEnabled(false);
        this.m_holderTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                PageLinkWizardPage.this.m_holderType = (IType)event.proposal;
                PageLinkWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_pageTypeField.setLayoutData(new GridData(768));
        this.m_holderTypeField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        this.getOperation().setHolderType(this.getHolderType());
        this.getOperation().setPage(this.getPageType());
        this.getOperation().run(monitor, workingCopyManager);
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        if (this.getHolderType() == null) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"HolderTypeIsMissing")));
        } else if (this.getPageType() == null) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"PageTypeIsMissing")));
        } else {
            multiStatus.add(Status.OK_STATUS);
        }
    }

    public void setOperation(LinkPageOperation operation) {
        this.m_operation = operation;
    }

    public LinkPageOperation getOperation() {
        return this.m_operation;
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    public void setHolderType(IType holderPage) {
        try {
            this.setStateChanging(true);
            this.m_holderType = holderPage;
            if (this.isControlCreated()) {
                this.m_holderTypeField.acceptProposal(holderPage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getHolderType() {
        return this.m_holderType;
    }

    public void setPageType(IType pageType) {
        try {
            this.setStateChanging(true);
            this.m_pageType = pageType;
            if (this.isControlCreated()) {
                this.m_pageTypeField.acceptProposal(pageType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getPageType() {
        return this.m_pageType;
    }
}

