/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.executor;

import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.ScoutWizardDialogEx;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.AuthenticationHandlerTablePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.TypeNewWizard;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.TypeNewWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.widgets.Shell;

public class AuthenticationHandlerNewWizardExecutor
extends AbstractExecutor {
    private IScoutBundle m_bundle;
    private WebserviceEnum m_webserviceEnum;

    public boolean canRun(IStructuredSelection selection) {
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof AuthenticationHandlerTablePage) {
            AuthenticationHandlerTablePage ahtp = (AuthenticationHandlerTablePage)((Object)selectedElement);
            this.m_bundle = ahtp.getScoutBundle();
            this.m_webserviceEnum = ahtp.getWebserviceEnum();
        }
        return this.isEditable(this.m_bundle);
    }

    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        TypeNewWizard wizard = new TypeNewWizard(this.m_bundle, Texts.get("AuthenticationHandler"));
        wizard.setAllowModifyInterfaceType(false);
        wizard.setAllowModifySuperType(true);
        wizard.setAllowModifyPackage(true);
        wizard.setTypeSuffix("AuthenticationHandler");
        wizard.setInterfaceTypeSearchScopeFactory(new P_JavaSearchScopeFactory(this.m_webserviceEnum, this.m_bundle, true));
        wizard.setSuperTypeSearchScopeFactory(new P_JavaSearchScopeFactory(this.m_webserviceEnum, this.m_bundle, false));
        if (this.m_webserviceEnum == WebserviceEnum.PROVIDER) {
            wizard.setInterfaceType(TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.IAuthenticationHandler"));
            wizard.setRecommendedPackageFragment(JaxWsSdkUtility.getRecommendedProviderSecurityPackageName(this.m_bundle));
        } else {
            wizard.setInterfaceType(TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.consumer.IAuthenticationHandler"));
            wizard.setRecommendedPackageFragment(JaxWsSdkUtility.getRecommendedConsumerSecurityPackageName(this.m_bundle));
        }
        ScoutWizardDialogEx wizardDialog = new ScoutWizardDialogEx((IWizard)wizard);
        wizardDialog.setPageSize(680, 350);
        wizardDialog.setHelpAvailable(false);
        wizardDialog.open();
        return null;
    }

    private class P_JavaSearchScopeFactory
    extends TypeNewWizardPage.JavaSearchScopeFactory {
        private WebserviceEnum m_webserviceEnum;
        private IScoutBundle m_bundle;
        private boolean m_onlyInterfaceTypes;

        public P_JavaSearchScopeFactory(WebserviceEnum webserviceEnum, IScoutBundle bundle, boolean onlyInterfaceTypes) {
            this.m_webserviceEnum = webserviceEnum;
            this.m_bundle = bundle;
            this.m_onlyInterfaceTypes = onlyInterfaceTypes;
        }

        @Override
        public IJavaSearchScope create() {
            Set subTypes;
            IType type = this.m_webserviceEnum == WebserviceEnum.PROVIDER ? TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.IAuthenticationHandler") : TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.consumer.IAuthenticationHandler");
            if (this.m_onlyInterfaceTypes) {
                subTypes = TypeUtility.getPrimaryTypeHierarchy((IType)type).getAllSubtypes(type, new ITypeFilter(){

                    public boolean accept(IType candidate) {
                        block3: {
                            try {
                                if (TypeUtility.exists((IJavaElement)candidate) && candidate.isInterface()) break block3;
                                return false;
                            }
                            catch (JavaModelException e) {
                                JaxWsSdk.logError(e);
                                return false;
                            }
                        }
                        return TypeUtility.isOnClasspath((IJavaElement)candidate, (IJavaProject)P_JavaSearchScopeFactory.this.m_bundle.getJavaProject());
                    }
                });
                subTypes.add(type);
            } else {
                subTypes = TypeUtility.getPrimaryTypeHierarchy((IType)type).getAllSubtypes(type, TypeFilters.getTypesOnClasspath((IJavaProject)type.getJavaProject()));
            }
            return SearchEngine.createJavaSearchScope((IJavaElement[])((IJavaElement[])subTypes.toArray(new IType[subTypes.size()])));
        }
    }
}

