/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.part;

import java.util.LinkedList;
import java.util.List;
import javax.jws.WebService;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.jdt.compile.ScoutSeverityManager;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.JdtTypePropertyPart;
import org.eclipse.scout.sdk.ui.view.properties.presenter.AbstractPresenter;
import org.eclipse.scout.sdk.util.IScoutSeverityListener;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsConstants;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.marker.MarkerUtility;
import org.eclipse.scout.sdk.ws.jaxws.operation.AnnotationUpdateOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.WsdlResource;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.BindingFileNewAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.BuildPropertiesEditAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.FileOpenAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.RepairAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.StubRebuildAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.TypeOpenAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceConsumerNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.part.AnnotationProperty;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.ActionPresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.AnnotationPropertyTypePresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.BindingFilePresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.FilePresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.FolderPresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.SeparatorPresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.StringPresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.TypePresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.WsdlFilePresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.WsdlFolderPresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.util.IFileHandle;
import org.eclipse.scout.sdk.ws.jaxws.util.ISchemaArtifactVisitor;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.SchemaArtifactVisitor;
import org.eclipse.scout.sdk.ws.jaxws.util.SchemaUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IPageLoadedListener;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IPresenterValueChangedListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class WebServiceConsumerNodePagePropertyViewPart
extends JdtTypePropertyPart {
    public static final String SECTION_ID_REPAIR = "section.jaxws.repair";
    public static final String SECTION_ID_PROPERTIES = "section.jaxws.properties";
    public static final String SECTION_ID_STUB_PROPERTIES = "section.jaxws.build";
    public static final String SECTION_ID_LINKS = "section.jaxws.links";
    public static final String SECTION_ID_LINKS_REF_WSDLS = "section.jaxws.links.ref.wsdl";
    public static final String SECTION_ID_LINKS_INCLUDED_SCHEMAS = "section.jaxws.links.included.schema";
    public static final String SECTION_ID_LINKS_IMPORTED_SCHEMAS = "section.jaxws.links.imported.schema";
    public static final String SECTION_ID_SCOUT_WEB_SERVICE_CLIENT_ANNOTATION = "section.scoutWebServiceAnnotation";
    public static final int PRESENTER_ID_AUTHENTICATION_HANDLER = 2;
    private IPresenterValueChangedListener m_presenterListener;
    private StringPresenter m_targetNamespacePresenter;
    private StringPresenter m_servicePresenter;
    private StringPresenter m_portTypePresenter;
    private FolderPresenter m_stubFolderPresenter;
    private FilePresenter m_stubJarFilePresenter;
    private WsdlFolderPresenter m_wsdlFolderPresenter;
    private WsdlFilePresenter m_wsdlFilePresenter;
    private Composite m_bindingFilesComposite;
    private P_ScoutSeverityListener m_severityListener;
    private IPageLoadedListener m_pageLoadedListener;
    private AnnotationPropertyTypePresenter m_authenticationHandlerPresenter;
    private List<BindingFilePresenter> m_bindingFilePresenters;
    private ActionPresenter m_rebuildStubPresenter;
    private IScoutBundle m_bundle;

    protected void init() {
        this.m_bundle = this.getPage().getScoutBundle();
        this.m_presenterListener = new P_PresenterListener();
        this.m_severityListener = new P_ScoutSeverityListener();
        this.m_pageLoadedListener = new P_PageLoadedListener();
        ScoutSeverityManager.getInstance().addQualityManagerListener((IScoutSeverityListener)this.m_severityListener);
        this.getPage().addPageLoadedListener(this.m_pageLoadedListener);
        this.m_bindingFilePresenters = new LinkedList<BindingFilePresenter>();
    }

    protected void cleanup() {
        ScoutSeverityManager.getInstance().removeQualityManagerListener((IScoutSeverityListener)this.m_severityListener);
        this.getPage().removePageLoadedListener(this.m_pageLoadedListener);
        super.cleanup();
    }

    public WebServiceConsumerNodePage getPage() {
        return (WebServiceConsumerNodePage)super.getPage();
    }

    protected void createSections() {
        this.getForm().setRedraw(true);
        try {
            this.createSection(SECTION_ID_REPAIR, Texts.get("RepairRequired"), Texts.get("SectionRepairDescription"), false);
            this.getSection(SECTION_ID_REPAIR).setVisible(JaxWsSdk.getDefault().containsMarkerCommands(this.getPage().getMarkerGroupUUID()));
            RepairAction a = new RepairAction();
            ActionPresenter presenter = new ActionPresenter(this.getSection(SECTION_ID_REPAIR).getSectionClient(), a, this.getFormToolkit(), this.getPage());
            this.applyLayoutData(presenter);
            this.createSection(SECTION_ID_LINKS, Texts.get("ConsiderLinks"));
            this.createQuickLinkPresenters();
            this.createSection(SECTION_ID_LINKS_REF_WSDLS, Texts.get("ReferencedWsdlDefintions"));
            this.getSection(SECTION_ID_LINKS_REF_WSDLS).setExpanded(false);
            this.createSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS, Texts.get("ImportedXsdSchemas"));
            this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS).setExpanded(false);
            this.createSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS, Texts.get("IncludedXsdSchemas"));
            this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS).setExpanded(false);
            this.createQuickLinkPresentersForReferencedFiles();
            if (this.getPage().getBuildJaxWsBean() == null) {
                return;
            }
            this.createSection(SECTION_ID_STUB_PROPERTIES, Texts.get("StubProperties"));
            StubRebuildAction b = new StubRebuildAction();
            this.m_rebuildStubPresenter = new ActionPresenter(this.getSection(SECTION_ID_STUB_PROPERTIES).getSectionClient(), b, this.getFormToolkit(), this.getPage());
            this.applyLayoutData(this.m_rebuildStubPresenter);
            BuildPropertiesEditAction c = new BuildPropertiesEditAction();
            presenter = new ActionPresenter(this.getSection(SECTION_ID_STUB_PROPERTIES).getSectionClient(), c, this.getFormToolkit(), this.getPage());
            GridData gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            presenter.getContainer().setLayoutData((Object)gd);
            BindingFileNewAction d = new BindingFileNewAction();
            presenter = new ActionPresenter(this.getSection(SECTION_ID_STUB_PROPERTIES).getSectionClient(), d, this.getFormToolkit(), this.getPage());
            presenter.setEnabled(this.getPage().getBuildJaxWsBean() != null && !this.getPage().getType().isReadOnly());
            gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            presenter.getContainer().setLayoutData((Object)gd);
            this.m_bindingFilesComposite = new Composite(this.getSection(SECTION_ID_STUB_PROPERTIES).getSectionClient(), 0);
            gd = new GridData(768);
            gd.verticalIndent = 5;
            this.m_bindingFilesComposite.setLayoutData((Object)gd);
            this.createSection(SECTION_ID_SCOUT_WEB_SERVICE_CLIENT_ANNOTATION, Texts.get("Authentication"), null, true);
            this.getSection(SECTION_ID_SCOUT_WEB_SERVICE_CLIENT_ANNOTATION).setExpanded(false);
            this.m_authenticationHandlerPresenter = new AnnotationPropertyTypePresenter(this.getSection(SECTION_ID_SCOUT_WEB_SERVICE_CLIENT_ANNOTATION).getSectionClient(), this.getFormToolkit());
            this.m_authenticationHandlerPresenter.setPresenterId(2);
            this.m_authenticationHandlerPresenter.setLabel(Texts.get("Authentication"));
            this.m_authenticationHandlerPresenter.setAcceptNullValue(true);
            this.m_authenticationHandlerPresenter.setBundle(this.m_bundle);
            this.m_authenticationHandlerPresenter.setAnnotationType(TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebServiceClient"));
            this.m_authenticationHandlerPresenter.setProperty("authenticationHandler");
            this.m_authenticationHandlerPresenter.setDefaultPackageNameNewType(JaxWsSdkUtility.getRecommendedConsumerSecurityPackageName(this.m_bundle));
            this.m_authenticationHandlerPresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.m_authenticationHandlerPresenter.setSearchScopeFactory(this.createSubClassesSearchScopeFactory(TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.consumer.IAuthenticationHandler")));
            this.m_authenticationHandlerPresenter.setAllowChangeOfInterfaceType(true);
            this.m_authenticationHandlerPresenter.setInterfaceTypes(new IType[]{TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.consumer.IAuthenticationHandler")});
            this.m_authenticationHandlerPresenter.addValueChangedListener(this.m_presenterListener);
            this.m_authenticationHandlerPresenter.getContainer().setLayoutData((Object)new GridData());
            this.applyLayoutData(this.m_authenticationHandlerPresenter);
            this.createSection(SECTION_ID_PROPERTIES, Texts.get("WebserviceProperties"));
            this.getSection(SECTION_ID_PROPERTIES).setExpanded(true);
            this.m_servicePresenter = new StringPresenter(this.getSection(SECTION_ID_PROPERTIES).getSectionClient(), this.getFormToolkit());
            this.m_servicePresenter.setLabel(Texts.get("Service"));
            this.m_servicePresenter.setBundle(this.m_bundle);
            this.m_servicePresenter.setMarkerType(JaxWsConstants.MarkerType.Service);
            this.m_servicePresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.m_servicePresenter.setEditable(false);
            this.applyLayoutData(this.m_servicePresenter);
            this.m_portTypePresenter = new StringPresenter(this.getSection(SECTION_ID_PROPERTIES).getSectionClient(), this.getFormToolkit());
            this.m_portTypePresenter.setLabel(Texts.get("PortType"));
            this.m_portTypePresenter.setBundle(this.m_bundle);
            this.m_portTypePresenter.setMarkerType(JaxWsConstants.MarkerType.PortType);
            this.m_portTypePresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.m_portTypePresenter.setEditable(false);
            this.applyLayoutData(this.m_portTypePresenter);
            this.m_targetNamespacePresenter = new StringPresenter(this.getSection(SECTION_ID_PROPERTIES).getSectionClient(), this.getFormToolkit());
            this.m_targetNamespacePresenter.setLabel(Texts.get("TargetNamespace"));
            this.m_targetNamespacePresenter.setBundle(this.m_bundle);
            this.m_targetNamespacePresenter.setMarkerType(JaxWsConstants.MarkerType.TargetNamespace);
            this.m_targetNamespacePresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.m_targetNamespacePresenter.setEditable(false);
            this.applyLayoutData(this.m_targetNamespacePresenter);
            this.m_stubFolderPresenter = new FolderPresenter(this.getSection(SECTION_ID_PROPERTIES).getSectionClient(), this.getFormToolkit());
            this.m_stubFolderPresenter.setShowBrowseButton(false);
            this.m_stubFolderPresenter.setLabel(Texts.get("StubFolder"));
            this.m_stubFolderPresenter.setBundle(this.m_bundle);
            this.m_stubFolderPresenter.setMarkerType(JaxWsConstants.MarkerType.StubFolder);
            this.m_stubFolderPresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.applyLayoutData(this.m_stubFolderPresenter);
            this.m_stubJarFilePresenter = new FilePresenter(this.getSection(SECTION_ID_PROPERTIES).getSectionClient(), this.getFormToolkit());
            this.m_stubJarFilePresenter.setLabel(Texts.get("StubJar"));
            this.m_stubJarFilePresenter.setShowBrowseButton(false);
            this.m_stubJarFilePresenter.setBundle(this.m_bundle);
            this.m_stubJarFilePresenter.setMarkerType(JaxWsConstants.MarkerType.StubJar);
            this.m_stubJarFilePresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.applyLayoutData(this.m_stubJarFilePresenter);
            this.m_wsdlFolderPresenter = new WsdlFolderPresenter(this.getSection(SECTION_ID_PROPERTIES).getSectionClient(), this.getFormToolkit(), WebserviceEnum.CONSUMER);
            this.m_wsdlFolderPresenter.setLabel(Texts.get("WsdlFolder"));
            this.m_wsdlFolderPresenter.setBundle(this.m_bundle);
            this.m_wsdlFolderPresenter.setMarkerType(JaxWsConstants.MarkerType.WsdlFolder);
            this.m_wsdlFolderPresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.applyLayoutData(this.m_wsdlFolderPresenter);
            this.m_wsdlFilePresenter = new WsdlFilePresenter(this.m_bundle, this.getSection(SECTION_ID_PROPERTIES).getSectionClient(), this.getFormToolkit());
            this.m_wsdlFilePresenter.setLabel(Texts.get("WsdlFile"));
            this.m_wsdlFilePresenter.setMarkerType(JaxWsConstants.MarkerType.Wsdl);
            this.m_wsdlFilePresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.applyLayoutData(this.m_wsdlFilePresenter);
            this.updatePresenterValues();
        }
        finally {
            this.getForm().setRedraw(true);
        }
        super.createSections();
        ISection propSection = this.getSection("section.properties.advanced");
        if (propSection != null) {
            propSection.setExpanded(false);
        }
    }

    private void updatePresenterValues() {
        QName portTypeQName;
        this.createQuickLinkPresenters();
        this.createQuickLinkPresentersForReferencedFiles();
        BuildJaxWsBean buildJaxWsBean = this.getPage().getBuildJaxWsBean();
        Definition wsdlDefinition = this.getPage().getWsdlDefinition();
        String serviceName = null;
        String serviceTooltip = null;
        String portTypeName = null;
        String portTypeTooltip = null;
        IFile stubJarFile = null;
        QName serviceQName = JaxWsSdkUtility.extractServiceQNameFromWsClient(this.getPage().getType());
        if (serviceQName != null) {
            serviceName = serviceQName.getLocalPart();
            serviceTooltip = serviceQName.toString();
        }
        if ((portTypeQName = JaxWsSdkUtility.extractPortTypeQNameFromWsClient(this.getPage().getType())) != null) {
            portTypeName = portTypeQName.getLocalPart();
            portTypeTooltip = portTypeQName.toString();
        }
        if (buildJaxWsBean != null) {
            stubJarFile = JaxWsSdkUtility.getStubJarFile(this.m_bundle, buildJaxWsBean, buildJaxWsBean.getWsdl());
        }
        this.m_targetNamespacePresenter.setInput(wsdlDefinition != null ? wsdlDefinition.getTargetNamespace() : null);
        this.m_targetNamespacePresenter.setTooltip((String)this.m_targetNamespacePresenter.getValue());
        this.m_servicePresenter.setInput(serviceName);
        this.m_servicePresenter.setTooltip(serviceTooltip);
        this.m_portTypePresenter.setInput(portTypeName);
        this.m_portTypePresenter.setTooltip(portTypeTooltip);
        this.m_stubJarFilePresenter.setInput(stubJarFile);
        this.m_stubFolderPresenter.setInput(JaxWsSdkUtility.getFolder(this.m_bundle, JaxWsConstants.STUB_FOLDER, false));
        IFile wsdlFile = this.getPage().getWsdlResource().getFile();
        if (wsdlFile != null) {
            IPath wsdlFolderPath = wsdlFile.getProjectRelativePath().removeLastSegments(1);
            IFolder folder = JaxWsSdkUtility.getFolder(this.m_bundle, wsdlFolderPath, false);
            if (folder == null) {
                folder = JaxWsSdkUtility.getFolder(this.m_bundle, JaxWsConstants.PATH_WSDL_CONSUMER, false);
            }
            this.m_wsdlFolderPresenter.setInput(folder);
            this.m_wsdlFilePresenter.setFileDirectory(folder);
        }
        this.m_wsdlFolderPresenter.setBuildJaxWsBean(buildJaxWsBean);
        this.m_wsdlFilePresenter.setInput(wsdlFile);
        this.m_wsdlFilePresenter.setBuildJaxWsBean(buildJaxWsBean);
        IAnnotation scoutWebServiceClientAnnotation = JaxWsSdkUtility.getAnnotation(this.getPage().getType(), TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebServiceClient").getFullyQualifiedName(), false);
        this.getSection(SECTION_ID_SCOUT_WEB_SERVICE_CLIENT_ANNOTATION).setVisible(TypeUtility.exists((IJavaElement)scoutWebServiceClientAnnotation));
        if (TypeUtility.exists((IJavaElement)scoutWebServiceClientAnnotation)) {
            AnnotationProperty propertyValue = JaxWsSdkUtility.parseAnnotationTypeValue(this.getPage().getType(), scoutWebServiceClientAnnotation, "authenticationHandler");
            this.m_authenticationHandlerPresenter.setInput(propertyValue.getFullyQualifiedName());
            this.m_authenticationHandlerPresenter.setDeclaringType(this.getPage().getType());
            this.m_authenticationHandlerPresenter.setResetLinkVisible(!propertyValue.isInherited());
            this.m_authenticationHandlerPresenter.setBoldLabelText(!propertyValue.isInherited());
        }
        this.createBindingFilePresenters(buildJaxWsBean);
        this.validateRebuildStubPresenter();
        this.getSection(SECTION_ID_REPAIR).setVisible(JaxWsSdk.getDefault().containsMarkerCommands(this.getPage().getMarkerGroupUUID()));
    }

    private void createQuickLinkPresenters() {
        ActionPresenter actionPresenter;
        block4: {
            this.getForm().setRedraw(false);
            try {
                JaxWsSdkUtility.disposeChildControls(this.getSection(SECTION_ID_LINKS).getSectionClient());
                this.createQuickLinkForTypesPresenters();
                SeparatorPresenter separatorPresenter = new SeparatorPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), this.getFormToolkit());
                this.applyLayoutData(separatorPresenter);
                FileOpenAction a = new FileOpenAction();
                a.setLinkText(ResourceFactory.getBuildJaxWsResource(this.m_bundle).getFile().getName());
                a.setImage(JaxWsSdk.getImageDescriptor("build-jaxws.png"));
                a.setToolTip(Texts.get("JaxWsBuildDescriptor"));
                actionPresenter = new ActionPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), a, this.getFormToolkit(), ResourceFactory.getBuildJaxWsResource(this.m_bundle).getFile());
                this.applyLayoutData(actionPresenter);
                if (this.getPage().getBuildJaxWsBean() != null) break block4;
            }
            catch (Throwable throwable) {
                this.getForm().setRedraw(true);
                this.getSection(SECTION_ID_LINKS).setVisible(this.getSection(SECTION_ID_LINKS).getSectionClient().getChildren().length > 0);
                JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS));
                throw throwable;
            }
            this.getForm().setRedraw(true);
            this.getSection(SECTION_ID_LINKS).setVisible(this.getSection(SECTION_ID_LINKS).getSectionClient().getChildren().length > 0);
            JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS));
            return;
        }
        IFile wsdlFile = this.getPage().getWsdlResource().getFile();
        if (wsdlFile != null) {
            FileOpenAction b = new FileOpenAction();
            b.setLinkText(wsdlFile.getName());
            b.setImage(JaxWsSdk.getImageDescriptor("wsdl_file_obj.gif"));
            b.setToolTip("Web Services Description Language");
            actionPresenter = new ActionPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), b, this.getFormToolkit(), wsdlFile);
            actionPresenter.setEnabled(wsdlFile.exists());
            this.applyLayoutData(actionPresenter);
        }
        this.getForm().setRedraw(true);
        this.getSection(SECTION_ID_LINKS).setVisible(this.getSection(SECTION_ID_LINKS).getSectionClient().getChildren().length > 0);
        JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS));
    }

    private void createQuickLinkPresentersForReferencedFiles() {
        block5: {
            this.getForm().setRedraw(false);
            try {
                try {
                    JaxWsSdkUtility.disposeChildControls(this.getSection(SECTION_ID_LINKS_REF_WSDLS).getSectionClient());
                    JaxWsSdkUtility.disposeChildControls(this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS).getSectionClient());
                    JaxWsSdkUtility.disposeChildControls(this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS).getSectionClient());
                    WsdlResource wsdlResource = this.getPage().getWsdlResource();
                    SchemaUtility.visitArtifacts(wsdlResource.getFile(), (ISchemaArtifactVisitor<IFile>)new SchemaArtifactVisitor<IFile>(){

                        @Override
                        public void onReferencedWsdlArtifact(SchemaUtility.WsdlArtifact<IFile> wsdlArtifact) {
                            if (wsdlArtifact.getTypeEnum() == SchemaUtility.WsdlArtifact.TypeEnum.REFERENCED_WSDL) {
                                IFileHandle fileHandle = wsdlArtifact.getFileHandle();
                                FileOpenAction action = new FileOpenAction();
                                action.setLinkText(fileHandle.getName());
                                action.setImage(JaxWsSdk.getImageDescriptor("wsdl_file_obj.gif"));
                                ActionPresenter actionPresenter = new ActionPresenter(WebServiceConsumerNodePagePropertyViewPart.this.getSection(WebServiceConsumerNodePagePropertyViewPart.SECTION_ID_LINKS_REF_WSDLS).getSectionClient(), action, WebServiceConsumerNodePagePropertyViewPart.this.getFormToolkit(), fileHandle.getFile());
                                actionPresenter.setEnabled(fileHandle.exists());
                                WebServiceConsumerNodePagePropertyViewPart.this.applyLayoutData(actionPresenter);
                            }
                        }

                        @Override
                        public void onSchemaIncludeArtifact(SchemaUtility.SchemaIncludeArtifact<IFile> schemaIncludeArtifact) {
                            IFileHandle fileHandle = schemaIncludeArtifact.getFileHandle();
                            FileOpenAction b = new FileOpenAction();
                            b.setLinkText(fileHandle.getName());
                            b.setImage(JaxWsSdk.getImageDescriptor("xsdFile.gif"));
                            ActionPresenter actionPresenter = new ActionPresenter(WebServiceConsumerNodePagePropertyViewPart.this.getSection(WebServiceConsumerNodePagePropertyViewPart.SECTION_ID_LINKS_INCLUDED_SCHEMAS).getSectionClient(), b, WebServiceConsumerNodePagePropertyViewPart.this.getFormToolkit(), fileHandle.getFile());
                            actionPresenter.setEnabled(fileHandle.exists());
                            WebServiceConsumerNodePagePropertyViewPart.this.applyLayoutData(actionPresenter);
                        }

                        @Override
                        public void onSchemaImportArtifact(SchemaUtility.SchemaImportArtifact<IFile> schemaImportArtifact) {
                            IFileHandle fileHandle = schemaImportArtifact.getFileHandle();
                            FileOpenAction b = new FileOpenAction();
                            b.setLinkText(fileHandle.getName());
                            b.setImage(JaxWsSdk.getImageDescriptor("xsdFile.gif"));
                            b.setToolTip("namespace: " + StringUtility.nvl((Object)schemaImportArtifact.getNamespaceUri(), (String)"?"));
                            ActionPresenter actionPresenter = new ActionPresenter(WebServiceConsumerNodePagePropertyViewPart.this.getSection(WebServiceConsumerNodePagePropertyViewPart.SECTION_ID_LINKS_IMPORTED_SCHEMAS).getSectionClient(), b, WebServiceConsumerNodePagePropertyViewPart.this.getFormToolkit(), fileHandle.getFile());
                            actionPresenter.setEnabled(fileHandle.exists());
                            WebServiceConsumerNodePagePropertyViewPart.this.applyLayoutData(actionPresenter);
                        }
                    });
                }
                catch (Exception e) {
                    JaxWsSdk.logError(e);
                    this.getForm().setRedraw(true);
                    this.getSection(SECTION_ID_LINKS_REF_WSDLS).setVisible(this.getSection(SECTION_ID_LINKS_REF_WSDLS).getSectionClient().getChildren().length > 0);
                    JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS_REF_WSDLS));
                    this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS).setVisible(this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS).getSectionClient().getChildren().length > 0);
                    JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS));
                    this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS).setVisible(this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS).getSectionClient().getChildren().length > 0);
                    JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS));
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.getForm().setRedraw(true);
                this.getSection(SECTION_ID_LINKS_REF_WSDLS).setVisible(this.getSection(SECTION_ID_LINKS_REF_WSDLS).getSectionClient().getChildren().length > 0);
                JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS_REF_WSDLS));
                this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS).setVisible(this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS).getSectionClient().getChildren().length > 0);
                JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS));
                this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS).setVisible(this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS).getSectionClient().getChildren().length > 0);
                JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS));
                throw throwable;
            }
            this.getForm().setRedraw(true);
            this.getSection(SECTION_ID_LINKS_REF_WSDLS).setVisible(this.getSection(SECTION_ID_LINKS_REF_WSDLS).getSectionClient().getChildren().length > 0);
            JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS_REF_WSDLS));
            this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS).setVisible(this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS).getSectionClient().getChildren().length > 0);
            JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS));
            this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS).setVisible(this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS).getSectionClient().getChildren().length > 0);
            JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS));
        }
    }

    private void createQuickLinkForTypesPresenters() {
        TypeOpenAction a = new TypeOpenAction();
        a.setLinkText(this.getPage().getType().getElementName());
        ActionPresenter actionPresenter = new ActionPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), a, this.getFormToolkit(), this.getPage().getType());
        this.applyLayoutData(actionPresenter);
        IType portTypeInterfaceType = JaxWsSdkUtility.extractGenericSuperType(this.getPage().getType(), 1);
        try {
            IAnnotation annotation;
            if (TypeUtility.exists((IJavaElement)portTypeInterfaceType) && portTypeInterfaceType.isInterface() && TypeUtility.exists((IJavaElement)(annotation = JaxWsSdkUtility.getAnnotation(portTypeInterfaceType, WebService.class.getName(), false)))) {
                TypeOpenAction action = new TypeOpenAction();
                action.setLinkText(portTypeInterfaceType.getElementName());
                action.setToolTip(Texts.get("JaxWsPortTypeInterface"));
                ActionPresenter presenter = new ActionPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), action, this.getFormToolkit(), portTypeInterfaceType);
                this.applyLayoutData(presenter);
            }
        }
        catch (JavaModelException e) {
            JaxWsSdk.logError("failed to validate port type interface", e);
        }
    }

    private void createBindingFilePresenters(BuildJaxWsBean buildJaxWsBean) {
        this.getForm().setRedraw(false);
        try {
            this.m_bindingFilePresenters.clear();
            JaxWsSdkUtility.disposeChildControls(this.m_bindingFilesComposite);
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = 0;
            layout.marginHeight = 5;
            this.m_bindingFilesComposite.setLayout((Layout)layout);
            if (buildJaxWsBean == null) {
                return;
            }
            IFile[] bindingFiles = JaxWsSdkUtility.getBindingFiles(this.m_bundle, buildJaxWsBean.getPropertiers());
            int index = 0;
            while (index < bindingFiles.length) {
                BindingFilePresenter filePresenter = new BindingFilePresenter(this.m_bundle, this.m_bindingFilesComposite, this.getFormToolkit());
                filePresenter.setMarkerGroupUUID(JaxWsSdkUtility.toMarkerGroupUUID(this.getPage().getMarkerGroupUUID(), index));
                filePresenter.setInput(bindingFiles[index]);
                filePresenter.setBuildJaxWsBean(buildJaxWsBean);
                this.applyLayoutData(filePresenter);
                this.m_bindingFilePresenters.add(filePresenter);
                ++index;
            }
        }
        finally {
            this.getForm().setRedraw(true);
            JaxWsSdkUtility.doLayout(this.m_bindingFilesComposite);
            JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_STUB_PROPERTIES));
        }
    }

    private void applyLayoutData(AbstractPresenter presenter) {
        GridData layoutData = new GridData(768);
        presenter.getContainer().setLayoutData((Object)layoutData);
    }

    private TypePresenter.ISearchJavaSearchScopeFactory createSubClassesSearchScopeFactory(final IType superType) {
        return new TypePresenter.ISearchJavaSearchScopeFactory(){

            @Override
            public IJavaSearchScope create() {
                IType[] subTypes = JaxWsSdkUtility.getJdtSubTypes(WebServiceConsumerNodePagePropertyViewPart.this.m_bundle, superType.getFullyQualifiedName(), false, false, true, false);
                return SearchEngine.createJavaSearchScope((IJavaElement[])subTypes);
            }
        };
    }

    private void validateRebuildStubPresenter() {
        boolean valid = this.getPage().getBuildJaxWsBean() != null && !MarkerUtility.containsMarker(this.m_bundle, JaxWsConstants.MarkerType.Wsdl, this.getPage().getMarkerGroupUUID(), 2);
        this.m_rebuildStubPresenter.setEnabled(valid);
        if (valid) {
            StubRebuildAction action = new StubRebuildAction();
            this.m_rebuildStubPresenter.setAction(action);
            this.m_rebuildStubPresenter.setActionParams(this.getPage());
        }
    }

    private class P_PageLoadedListener
    implements IPageLoadedListener {
        private P_PageLoadedListener() {
        }

        @Override
        public void pageLoaded() {
            ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WebServiceConsumerNodePagePropertyViewPart.this.getPage().isPageUnloaded() || WebServiceConsumerNodePagePropertyViewPart.this.getForm().isDisposed()) {
                        return;
                    }
                    if (MarkerUtility.containsMarker(WebServiceConsumerNodePagePropertyViewPart.this.m_bundle, JaxWsConstants.MarkerType.MissingBuildJaxWsEntry, WebServiceConsumerNodePagePropertyViewPart.this.getPage().getMarkerGroupUUID(), 2)) {
                        return;
                    }
                    WebServiceConsumerNodePagePropertyViewPart.this.updatePresenterValues();
                }
            });
        }
    }

    private final class P_PresenterListener
    implements IPresenterValueChangedListener {
        private P_PresenterListener() {
        }

        @Override
        public void propertyChanged(int presenterId, Object value) {
            switch (presenterId) {
                case 2: {
                    IType type = WebServiceConsumerNodePagePropertyViewPart.this.getPage().getType();
                    String factoryFullyQualifiedName = (String)value;
                    if (!TypeUtility.existsType((String)factoryFullyQualifiedName)) {
                        return;
                    }
                    IType factoryType = TypeUtility.getType((String)factoryFullyQualifiedName);
                    AnnotationUpdateOperation op = new AnnotationUpdateOperation();
                    op.setDeclaringType(type);
                    op.setAnnotationType(TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebServiceClient"));
                    op.addTypeProperty("authenticationHandler", factoryType);
                    new OperationJob(new IOperation[]{op}).schedule();
                }
            }
        }
    }

    private class P_ScoutSeverityListener
    implements IScoutSeverityListener {
        private P_ScoutSeverityListener() {
        }

        public void severityChanged(IResource resource) {
            boolean accept = false;
            if (resource == WebServiceConsumerNodePagePropertyViewPart.this.getPage().getType().getResource()) {
                accept = true;
            }
            if (!accept && resource == ResourceFactory.getSunJaxWsResource(WebServiceConsumerNodePagePropertyViewPart.this.m_bundle).getFile()) {
                accept = true;
            }
            if (!accept && resource == ResourceFactory.getBuildJaxWsResource(WebServiceConsumerNodePagePropertyViewPart.this.m_bundle).getFile()) {
                accept = true;
            }
            if (!accept && resource == WebServiceConsumerNodePagePropertyViewPart.this.getPage().getWsdlResource().getFile()) {
                accept = true;
            }
            if (!accept) {
                XmlResource[] xmlResourceArray = WebServiceConsumerNodePagePropertyViewPart.this.getPage().getBindingFileResources();
                int n = xmlResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    XmlResource bindingFileResource = xmlResourceArray[n2];
                    if (resource == bindingFileResource.getFile()) {
                        accept = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!accept) {
                return;
            }
            ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WebServiceConsumerNodePagePropertyViewPart.this.getPage().isPageUnloaded() || WebServiceConsumerNodePagePropertyViewPart.this.getForm().isDisposed()) {
                        return;
                    }
                    WebServiceConsumerNodePagePropertyViewPart.this.getSection(WebServiceConsumerNodePagePropertyViewPart.SECTION_ID_REPAIR).setVisible(JaxWsSdk.getDefault().containsMarkerCommands(WebServiceConsumerNodePagePropertyViewPart.this.getPage().getMarkerGroupUUID()));
                    if (MarkerUtility.containsMarker(WebServiceConsumerNodePagePropertyViewPart.this.m_bundle, JaxWsConstants.MarkerType.MissingBuildJaxWsEntry, WebServiceConsumerNodePagePropertyViewPart.this.getPage().getMarkerGroupUUID(), 2)) {
                        return;
                    }
                    WebServiceConsumerNodePagePropertyViewPart.this.m_targetNamespacePresenter.updateInfo();
                    WebServiceConsumerNodePagePropertyViewPart.this.m_servicePresenter.updateInfo();
                    WebServiceConsumerNodePagePropertyViewPart.this.m_portTypePresenter.updateInfo();
                    WebServiceConsumerNodePagePropertyViewPart.this.m_wsdlFilePresenter.updateInfo();
                    WebServiceConsumerNodePagePropertyViewPart.this.m_wsdlFolderPresenter.updateInfo();
                    WebServiceConsumerNodePagePropertyViewPart.this.m_authenticationHandlerPresenter.updateInfo();
                    WebServiceConsumerNodePagePropertyViewPart.this.m_stubJarFilePresenter.updateInfo();
                    WebServiceConsumerNodePagePropertyViewPart.this.m_stubFolderPresenter.updateInfo();
                    for (BindingFilePresenter presenter : WebServiceConsumerNodePagePropertyViewPart.this.m_bindingFilePresenters) {
                        presenter.updateInfo();
                    }
                    WebServiceConsumerNodePagePropertyViewPart.this.validateRebuildStubPresenter();
                }
            });
        }
    }
}

