/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsConstants;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.operation.BindingFileCreateOperation;
import org.eclipse.scout.sdk.ws.jaxws.operation.BuildJaxWsEntryCreateOperation;
import org.eclipse.scout.sdk.ws.jaxws.operation.ExternalFileCopyOperation;
import org.eclipse.scout.sdk.ws.jaxws.operation.JaxWsServletRegistrationOperation;
import org.eclipse.scout.sdk.ws.jaxws.operation.SunJaxWsEntryCreateOperation;
import org.eclipse.scout.sdk.ws.jaxws.operation.WsProviderImplNewOperation;
import org.eclipse.scout.sdk.ws.jaxws.operation.WsStubGenerationOperation;
import org.eclipse.scout.sdk.ws.jaxws.operation.WsdlCreateOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.WsdlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.JaxWsServletRegistrationWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WsPropertiesExistingWsdlWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WsPropertiesNewWsdlWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WsProviderImplClassWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WsStubWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WsdlLocationWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WsdlSelectionWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.util.GlobalBindingRegistrationHelper;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.SchemaUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.ServletRegistrationUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IOperationFinishedListener;
import org.eclipse.ui.IWorkbench;

public class WsProviderNewWizard
extends AbstractWorkspaceWizard {
    private IScoutBundle m_bundle;
    private WsdlSelectionWizardPage m_wsdlSelectionWizardPage;
    private WsdlLocationWizardPage m_wsdlLocationWizardPage;
    private JaxWsServletRegistrationWizardPage m_servletRegistrationWizardPage;
    private WsPropertiesNewWsdlWizardPage m_wsPropertiesNewWsdlWizardPage;
    private WsPropertiesExistingWsdlWizardPage m_wsPropertiesExistingWsdlWizardPage;
    private WsProviderImplClassWizardPage m_wsProviderImplClassWizardPage;
    private WsStubWizardPage m_wsStubWizardPage;
    private JaxWsServletRegistrationOperation m_servletRegistrationOperation;
    private ExternalFileCopyOperation[] m_copyOperations;
    private BuildJaxWsEntryCreateOperation m_buildJaxWsEntryCreateOperation;
    private SunJaxWsEntryCreateOperation m_sunJaxWsEntryCreateOperation;
    private WsdlCreateOperation m_wsdlCreateOperation;
    private WsStubGenerationOperation m_stubGenerationOperation;
    private WsProviderImplNewOperation m_wsProviderImplNewOperation;
    private QName m_portTypeQName;
    private String m_alias;
    private boolean m_createBindingFile;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(Texts.get("CreateWsProvider"));
        this.m_copyOperations = new ExternalFileCopyOperation[0];
        this.m_bundle = UiUtility.getScoutBundleFromSelection((IStructuredSelection)selection);
    }

    public void addPages() {
        this.m_wsdlSelectionWizardPage = new WsdlSelectionWizardPage(this.m_bundle);
        this.m_wsdlSelectionWizardPage.setTitle(Texts.get("CreateWsProvider"));
        this.m_wsdlSelectionWizardPage.setWsdlFolder(JaxWsSdkUtility.getFolder(this.m_bundle, JaxWsConstants.PATH_WSDL_PROVIDER, false));
        this.m_wsdlSelectionWizardPage.setRootWsdlFolder(JaxWsSdkUtility.getFolder(this.m_bundle, JaxWsConstants.PATH_WSDL_PROVIDER, false));
        this.m_wsdlSelectionWizardPage.addPropertyChangeListener(new P_WsdlSelectionPropertyListener());
        this.addPage((IWizardPage)this.m_wsdlSelectionWizardPage);
        this.m_wsdlLocationWizardPage = new WsdlLocationWizardPage(this.m_bundle);
        this.m_wsdlLocationWizardPage.setTitle(Texts.get("CreateWsProvider"));
        this.m_wsdlLocationWizardPage.setExcludePage(this.m_wsdlSelectionWizardPage.isNewWsdl());
        this.m_wsdlLocationWizardPage.setWsdlFolderVisible(false);
        this.m_wsdlLocationWizardPage.setWsdlFolder(JaxWsSdkUtility.getFolder(this.m_bundle, JaxWsConstants.PATH_WSDL_PROVIDER, false));
        this.m_wsdlLocationWizardPage.setRootWsdlFolder(JaxWsSdkUtility.getFolder(this.m_bundle, JaxWsConstants.PATH_WSDL_PROVIDER, false));
        this.m_wsdlLocationWizardPage.setExcludePage(true);
        this.m_wsdlLocationWizardPage.addPropertyChangeListener(new P_WsdlLocationPropertyListener());
        this.addPage((IWizardPage)this.m_wsdlLocationWizardPage);
        this.m_servletRegistrationWizardPage = new JaxWsServletRegistrationWizardPage(this.m_bundle, false);
        this.m_servletRegistrationWizardPage.setTitle(Texts.get("CreateWsProvider"));
        this.m_servletRegistrationWizardPage.addPropertyChangeListener(new P_ServletRegistrationPropertyListener());
        this.m_servletRegistrationWizardPage.initializeDefaultValues(this.m_bundle);
        ServletRegistrationUtility.Registration registration = ServletRegistrationUtility.getServletRegistration(this.m_bundle);
        this.m_servletRegistrationWizardPage.setExcludePage(registration != null && !StringUtility.isNullOrEmpty((CharSequence)registration.getAlias()));
        this.addPage((IWizardPage)this.m_servletRegistrationWizardPage);
        this.m_wsPropertiesNewWsdlWizardPage = new WsPropertiesNewWsdlWizardPage(this.m_bundle);
        this.m_wsPropertiesNewWsdlWizardPage.setTitle(Texts.get("CreateWsProvider"));
        this.m_wsPropertiesNewWsdlWizardPage.setJaxWsServletAlias(this.m_servletRegistrationWizardPage.getAlias());
        this.m_wsPropertiesNewWsdlWizardPage.addPropertyChangeListener(new P_WsPropertiesNewWsdlPropertyListener());
        this.m_wsPropertiesNewWsdlWizardPage.setExcludePage(true);
        this.addPage((IWizardPage)this.m_wsPropertiesNewWsdlWizardPage);
        this.m_wsPropertiesExistingWsdlWizardPage = new WsPropertiesExistingWsdlWizardPage(this.m_bundle, WebserviceEnum.PROVIDER);
        this.m_wsPropertiesExistingWsdlWizardPage.setTitle(Texts.get("CreateWsProvider"));
        this.m_wsPropertiesExistingWsdlWizardPage.setJaxWsServletAlias(this.m_servletRegistrationWizardPage.getAlias());
        this.m_wsPropertiesExistingWsdlWizardPage.addPropertyChangeListener(new P_WsPropertiesExistingWsdlPropertyListener());
        this.m_wsPropertiesExistingWsdlWizardPage.setExcludePage(true);
        this.addPage((IWizardPage)this.m_wsPropertiesExistingWsdlWizardPage);
        this.m_wsStubWizardPage = new WsStubWizardPage(this.m_bundle);
        this.m_wsStubWizardPage.setTitle(Texts.get("CreateWsProvider"));
        this.addPage((IWizardPage)this.m_wsStubWizardPage);
        this.m_wsProviderImplClassWizardPage = new WsProviderImplClassWizardPage(this.m_bundle);
        this.m_wsProviderImplClassWizardPage.setTitle(Texts.get("CreateWsProvider"));
        this.addPage((IWizardPage)this.m_wsProviderImplClassWizardPage);
        this.m_wsdlSelectionWizardPage.setNewWsdl(true);
    }

    protected boolean beforeFinish() throws CoreException {
        String wsdlFileName;
        String urlPattern;
        String defaultPackageName;
        String targetNamespace;
        IFolder wsdlFolder = this.m_wsdlLocationWizardPage.getWsdlFolder();
        if (!this.m_wsdlSelectionWizardPage.isNewWsdl()) {
            File wsdlFile = this.m_wsdlLocationWizardPage.getWsdlFile();
            LinkedList<ExternalFileCopyOperation> copyOperations = new LinkedList<ExternalFileCopyOperation>();
            if (!JaxWsSdkUtility.existsFileInProject(this.m_bundle, wsdlFolder, wsdlFile)) {
                ExternalFileCopyOperation op = new ExternalFileCopyOperation();
                op.setBundle(this.m_bundle);
                op.setOverwrite(true);
                op.setExternalFile(this.m_wsdlLocationWizardPage.getWsdlFile());
                op.setWorkspacePath(wsdlFolder.getProjectRelativePath());
                copyOperations.add(op);
            }
            File[] fileArray = this.m_wsdlLocationWizardPage.getAdditionalFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!JaxWsSdkUtility.existsFileInProject(this.m_bundle, wsdlFolder, file)) {
                    ExternalFileCopyOperation op = new ExternalFileCopyOperation();
                    op.setBundle(this.m_bundle);
                    op.setOverwrite(true);
                    op.setExternalFile(file);
                    op.setWorkspacePath(wsdlFolder.getProjectRelativePath());
                    copyOperations.add(op);
                }
                ++n2;
            }
            this.m_copyOperations = copyOperations.toArray(new ExternalFileCopyOperation[copyOperations.size()]);
        }
        this.m_createBindingFile = this.m_wsStubWizardPage.isCreateBindingFile();
        QName serviceQName = null;
        QName portQName = null;
        this.m_servletRegistrationOperation = new JaxWsServletRegistrationOperation();
        this.m_servletRegistrationOperation.setBundle(this.m_bundle);
        this.m_servletRegistrationOperation.setRegistrationBundle(this.m_servletRegistrationWizardPage.getRegistrationBundle());
        this.m_servletRegistrationOperation.setJaxWsAlias(this.m_servletRegistrationWizardPage.getAlias());
        this.m_buildJaxWsEntryCreateOperation = new BuildJaxWsEntryCreateOperation(WebserviceEnum.PROVIDER);
        this.m_buildJaxWsEntryCreateOperation.setBundle(this.m_bundle);
        if (this.m_wsdlSelectionWizardPage.isNewWsdl()) {
            this.m_alias = this.m_wsPropertiesNewWsdlWizardPage.getAlias();
            targetNamespace = this.m_wsPropertiesNewWsdlWizardPage.getTargetNamespace();
        } else {
            this.m_alias = this.m_wsPropertiesExistingWsdlWizardPage.getAlias();
            targetNamespace = this.m_wsdlLocationWizardPage.getWsdlDefinition().getTargetNamespace();
        }
        this.m_buildJaxWsEntryCreateOperation.setAlias(this.m_alias);
        Map<String, List<String>> buildProperties = JaxWsSdkUtility.getDefaultBuildProperties();
        if (this.m_wsdlSelectionWizardPage.isNewWsdl()) {
            defaultPackageName = JaxWsSdkUtility.targetNamespaceToPackageName(targetNamespace);
        } else {
            Definition wsdlDefinition = this.m_wsdlLocationWizardPage.getWsdlDefinition();
            defaultPackageName = JaxWsSdkUtility.resolveStubPackageName(null, wsdlDefinition);
        }
        if (!CompareUtility.equals((Object)this.m_wsStubWizardPage.getPackageName(), (Object)defaultPackageName)) {
            JaxWsSdkUtility.addBuildProperty(buildProperties, "p", this.m_wsStubWizardPage.getPackageName());
        }
        this.m_buildJaxWsEntryCreateOperation.setBuildProperties(buildProperties);
        if (this.m_wsdlSelectionWizardPage.isNewWsdl()) {
            serviceQName = new QName(targetNamespace, this.m_wsPropertiesNewWsdlWizardPage.getServiceName());
            portQName = new QName(targetNamespace, this.m_wsPropertiesNewWsdlWizardPage.getPortName());
            this.m_portTypeQName = new QName(targetNamespace, this.m_wsPropertiesNewWsdlWizardPage.getPortTypeName());
            urlPattern = this.m_wsPropertiesNewWsdlWizardPage.getUrlPattern();
            wsdlFileName = this.m_wsPropertiesNewWsdlWizardPage.getWsdlName();
            this.m_wsdlCreateOperation = new WsdlCreateOperation();
            this.m_wsdlCreateOperation.setBundle(this.m_bundle);
            this.m_wsdlCreateOperation.setAlias(this.m_alias);
            WsdlResource wsdlResource = new WsdlResource(this.m_bundle);
            wsdlResource.setFile(JaxWsSdkUtility.getFile(this.m_bundle, wsdlFolder.getProjectRelativePath().append(this.m_wsPropertiesNewWsdlWizardPage.getWsdlName()), false));
            this.m_wsdlCreateOperation.setWsdlResource(wsdlResource);
            this.m_wsdlCreateOperation.setTargetNamespace(targetNamespace);
            this.m_wsdlCreateOperation.setService(this.m_wsPropertiesNewWsdlWizardPage.getServiceName());
            this.m_wsdlCreateOperation.setPortName(this.m_wsPropertiesNewWsdlWizardPage.getPortName());
            this.m_wsdlCreateOperation.setPortType(this.m_wsPropertiesNewWsdlWizardPage.getPortTypeName());
            this.m_wsdlCreateOperation.setBinding(this.m_wsPropertiesNewWsdlWizardPage.getBinding());
            this.m_wsdlCreateOperation.setUrlPattern(this.m_wsPropertiesNewWsdlWizardPage.getUrlPattern());
            this.m_wsdlCreateOperation.setServiceOperationName(this.m_wsPropertiesNewWsdlWizardPage.getServiceOperationName());
            this.m_wsdlCreateOperation.setWsdlStyle(this.m_wsPropertiesNewWsdlWizardPage.getWsdlStyle());
        } else {
            if (this.m_wsPropertiesExistingWsdlWizardPage.getService() != null) {
                serviceQName = this.m_wsPropertiesExistingWsdlWizardPage.getService().getQName();
            }
            if (this.m_wsPropertiesExistingWsdlWizardPage.getPort() != null) {
                portQName = serviceQName != null ? new QName(serviceQName.getNamespaceURI(), this.m_wsPropertiesExistingWsdlWizardPage.getPort().getName()) : new QName(this.m_wsPropertiesExistingWsdlWizardPage.getPort().getName());
            }
            this.m_portTypeQName = this.m_wsPropertiesExistingWsdlWizardPage.getPortType().getQName();
            urlPattern = this.m_wsPropertiesExistingWsdlWizardPage.getUrlPattern();
            wsdlFileName = this.m_wsdlLocationWizardPage.getWsdlFile().getName();
        }
        this.m_sunJaxWsEntryCreateOperation = new SunJaxWsEntryCreateOperation();
        this.m_sunJaxWsEntryCreateOperation.setBundle(this.m_bundle);
        this.m_sunJaxWsEntryCreateOperation.setImplTypeQualifiedName(StringUtility.join((String)".", (Object[])new Object[]{this.m_wsProviderImplClassWizardPage.getPackageName(), this.m_wsProviderImplClassWizardPage.getTypeName()}));
        this.m_sunJaxWsEntryCreateOperation.setAlias(this.m_alias);
        this.m_sunJaxWsEntryCreateOperation.setServiceQName(serviceQName);
        this.m_sunJaxWsEntryCreateOperation.setPortQName(portQName);
        this.m_sunJaxWsEntryCreateOperation.setUrlPattern(urlPattern);
        this.m_sunJaxWsEntryCreateOperation.setWsdlProjectRelativePath(wsdlFolder.getProjectRelativePath().append(wsdlFileName));
        this.m_stubGenerationOperation = new WsStubGenerationOperation();
        this.m_stubGenerationOperation.setBundle(this.m_bundle);
        this.m_stubGenerationOperation.setAlias(this.m_alias);
        this.m_stubGenerationOperation.setWsdlFolder(wsdlFolder);
        this.m_stubGenerationOperation.setProperties(buildProperties);
        this.m_stubGenerationOperation.setWsdlFileName(wsdlFileName);
        this.m_stubGenerationOperation.addOperationFinishedListener(new P_StubGenerationFinishedListener());
        this.m_wsProviderImplNewOperation = new WsProviderImplNewOperation();
        this.m_wsProviderImplNewOperation.setBundle(this.m_bundle);
        this.m_wsProviderImplNewOperation.setPackageName(this.m_wsProviderImplClassWizardPage.getPackageName());
        this.m_wsProviderImplNewOperation.setTypeName(this.m_wsProviderImplClassWizardPage.getTypeName());
        this.m_wsProviderImplNewOperation.setCreateScoutWebServiceAnnotation(this.m_wsProviderImplClassWizardPage.isAnnotateImplClass());
        this.m_wsProviderImplNewOperation.setSessionFactoryQName(this.m_wsProviderImplClassWizardPage.getSessionFactory());
        this.m_wsProviderImplNewOperation.setAuthenticationHandlerQName(this.m_wsProviderImplClassWizardPage.getAuthenticationHandler());
        this.m_wsProviderImplNewOperation.setCredentialValidationStrategyQName(this.m_wsProviderImplClassWizardPage.getCredentialValidationStrategy());
        return true;
    }

    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        JaxWsSdk.getDefault().getMarkerQueueManager().suspend();
        try {
            this.m_servletRegistrationOperation.run(monitor, workingCopyManager);
            ExternalFileCopyOperation[] externalFileCopyOperationArray = this.m_copyOperations;
            int n = this.m_copyOperations.length;
            int n2 = 0;
            while (n2 < n) {
                ExternalFileCopyOperation op = externalFileCopyOperationArray[n2];
                op.validate();
                op.run(monitor, workingCopyManager);
                ++n2;
            }
            if (this.m_wsdlCreateOperation != null) {
                this.m_wsdlCreateOperation.validate();
                this.m_wsdlCreateOperation.run(monitor, workingCopyManager);
            }
            if (this.m_createBindingFile) {
                WsdlResource wsdlResource;
                Map<String, List<String>> buildProperties = this.m_buildJaxWsEntryCreateOperation.getBuildProperties();
                if (this.m_wsdlCreateOperation != null) {
                    wsdlResource = this.m_wsdlCreateOperation.getWsdlResource();
                } else {
                    IFile wsdlFile = JaxWsSdkUtility.getFile(this.m_bundle, this.m_sunJaxWsEntryCreateOperation.getWsdlProjectRelativePath(), false);
                    wsdlResource = new WsdlResource(this.m_bundle);
                    wsdlResource.setFile(wsdlFile);
                }
                GlobalBindingRegistrationHelper.SchemaCandidate[] schemaCandidates = GlobalBindingRegistrationHelper.getSchemaCandidates(wsdlResource.getFile());
                int i = 0;
                while (i < schemaCandidates.length) {
                    GlobalBindingRegistrationHelper.SchemaCandidate candidate = schemaCandidates[i];
                    String schemaTargetNamespace = null;
                    if (schemaCandidates.length > 1) {
                        schemaTargetNamespace = SchemaUtility.getSchemaTargetNamespace(candidate.getSchema());
                    }
                    IPath bindingFilePath = JaxWsSdkUtility.toUniqueProjectRelativeBindingFilePath(this.m_bundle, this.m_alias, schemaTargetNamespace);
                    BindingFileCreateOperation op = new BindingFileCreateOperation();
                    op.setBundle(this.m_bundle);
                    op.setWsdlDestinationFolder(this.m_wsdlLocationWizardPage.getWsdlFolder());
                    op.setSchemaTargetNamespace(schemaTargetNamespace);
                    if (candidate.getWsdlArtifact().getTypeEnum() == SchemaUtility.WsdlArtifact.TypeEnum.REFERENCED_WSDL) {
                        op.setWsdlLocation((IFile)candidate.getWsdlArtifact().getFileHandle().getFile());
                    }
                    op.setProjectRelativePath(bindingFilePath);
                    JaxWsSdkUtility.addBuildProperty(buildProperties, "b", bindingFilePath.toString());
                    if (i == 0) {
                        op.setCreateGlobalBindingSection(true);
                    }
                    op.validate();
                    op.run(monitor, workingCopyManager);
                    ++i;
                }
                this.m_buildJaxWsEntryCreateOperation.setBuildProperties(buildProperties);
            }
            try {
                this.m_stubGenerationOperation.validate();
                this.m_stubGenerationOperation.run(monitor, workingCopyManager);
                IFile stubJarFile = JaxWsSdkUtility.getStubJarFile(this.m_bundle, this.m_buildJaxWsEntryCreateOperation.getBuildProperties(), this.m_sunJaxWsEntryCreateOperation.getWsdlProjectRelativePath().lastSegment());
                IType portTypeInterfaceType = JaxWsSdkUtility.resolvePortTypeInterfaceType(this.m_portTypeQName, stubJarFile);
                int maxWaitLoops = 10;
                while (portTypeInterfaceType == null && maxWaitLoops > 0) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        JaxWsSdk.logError(e);
                    }
                    portTypeInterfaceType = JaxWsSdkUtility.resolvePortTypeInterfaceType(this.m_portTypeQName, stubJarFile);
                    --maxWaitLoops;
                }
                this.m_wsProviderImplNewOperation.setPortTypeInterfaceType(portTypeInterfaceType);
                this.m_wsProviderImplNewOperation.validate();
                this.m_wsProviderImplNewOperation.run(monitor, workingCopyManager);
                String fqnPortType = this.m_wsProviderImplNewOperation.getCreatedType().getFullyQualifiedName();
                maxWaitLoops = 10;
                while (!TypeUtility.existsType((String)fqnPortType) && maxWaitLoops > 0) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        JaxWsSdk.logError(e);
                    }
                    --maxWaitLoops;
                }
            }
            catch (Exception e) {
                JaxWsSdk.logError(e);
            }
            this.m_buildJaxWsEntryCreateOperation.validate();
            this.m_buildJaxWsEntryCreateOperation.run(monitor, workingCopyManager);
            this.m_sunJaxWsEntryCreateOperation.validate();
            this.m_sunJaxWsEntryCreateOperation.run(monitor, workingCopyManager);
            return true;
        }
        finally {
            JaxWsSdk.getDefault().getMarkerQueueManager().resume();
        }
    }

    private class P_ServletRegistrationPropertyListener
    implements PropertyChangeListener {
        private P_ServletRegistrationPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("alias".equals(event.getPropertyName())) {
                if (WsProviderNewWizard.this.m_wsPropertiesNewWsdlWizardPage != null) {
                    WsProviderNewWizard.this.m_wsPropertiesNewWsdlWizardPage.setJaxWsServletAlias(WsProviderNewWizard.this.m_servletRegistrationWizardPage.getAlias());
                }
                if (WsProviderNewWizard.this.m_wsPropertiesExistingWsdlWizardPage != null) {
                    WsProviderNewWizard.this.m_wsPropertiesExistingWsdlWizardPage.setJaxWsServletAlias(WsProviderNewWizard.this.m_servletRegistrationWizardPage.getAlias());
                }
            }
        }
    }

    private class P_StubGenerationFinishedListener
    implements IOperationFinishedListener {
        private P_StubGenerationFinishedListener() {
        }

        @Override
        public void operationFinished(boolean success, Throwable exception) {
        }
    }

    private class P_WsPropertiesExistingWsdlPropertyListener
    implements PropertyChangeListener {
        private P_WsPropertiesExistingWsdlPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("portType".equals(event.getPropertyName())) {
                String portTypeName = null;
                PortType portType = (PortType)event.getNewValue();
                if (portType != null) {
                    portTypeName = portType.getQName().getLocalPart();
                    WsProviderNewWizard.this.m_wsProviderImplClassWizardPage.setTypeName(JaxWsSdkUtility.getPlainPortTypeName(portTypeName));
                } else {
                    WsProviderNewWizard.this.m_wsProviderImplClassWizardPage.setTypeName(null);
                }
            }
        }
    }

    private class P_WsPropertiesNewWsdlPropertyListener
    implements PropertyChangeListener {
        private P_WsPropertiesNewWsdlPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("targetNamespace".equals(event.getPropertyName())) {
                String targetNamespace = (String)event.getNewValue();
                String defaultPackageName = JaxWsSdkUtility.targetNamespaceToPackageName(targetNamespace);
                WsProviderNewWizard.this.m_wsStubWizardPage.setDefaultPackageName(defaultPackageName);
                WsProviderNewWizard.this.m_wsStubWizardPage.setPackageName(defaultPackageName);
            } else if ("portTypeName".equals(event.getPropertyName())) {
                WsProviderNewWizard.this.m_wsProviderImplClassWizardPage.setTypeName(JaxWsSdkUtility.getPlainPortTypeName((String)event.getNewValue()));
            }
        }
    }

    private class P_WsdlLocationPropertyListener
    implements PropertyChangeListener {
        private P_WsdlLocationPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("wsdlDefinition".equals(event.getPropertyName())) {
                Definition wsdlDefinition = (Definition)event.getNewValue();
                WsProviderNewWizard.this.m_wsPropertiesExistingWsdlWizardPage.setWsdlDefinition(wsdlDefinition);
                if (wsdlDefinition != null) {
                    String defaultPackageName = JaxWsSdkUtility.resolveStubPackageName(null, wsdlDefinition);
                    WsProviderNewWizard.this.m_wsStubWizardPage.setDefaultPackageName(defaultPackageName);
                    WsProviderNewWizard.this.m_wsStubWizardPage.setPackageName(defaultPackageName);
                } else {
                    WsProviderNewWizard.this.m_wsStubWizardPage.setDefaultPackageName(null);
                }
            }
        }
    }

    private class P_WsdlSelectionPropertyListener
    implements PropertyChangeListener {
        private P_WsdlSelectionPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("createNewWsdl".equals(event.getPropertyName())) {
                boolean createNewWsdl = (Boolean)event.getNewValue();
                WsProviderNewWizard.this.m_wsdlLocationWizardPage.setExcludePage(createNewWsdl);
                WsProviderNewWizard.this.m_wsPropertiesNewWsdlWizardPage.setExcludePage(!createNewWsdl);
                WsProviderNewWizard.this.m_wsPropertiesExistingWsdlWizardPage.setExcludePage(createNewWsdl);
            } else if ("wsdlFolder".equals(event.getPropertyName())) {
                WsProviderNewWizard.this.m_wsdlLocationWizardPage.setWsdlFolder((IFolder)event.getNewValue());
            }
        }
    }
}

