/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.util;

import org.eclipse.core.runtime.Path;
import org.eclipse.scout.commons.StringUtility;

public final class PathNormalizer {
    public static final String SLASH_SUFFIX = "/";

    private PathNormalizer() {
    }

    public static String toUrlPattern(String urlPattern) {
        if (!StringUtility.hasText((CharSequence)urlPattern)) {
            return null;
        }
        return new Path(urlPattern).makeAbsolute().removeTrailingSeparator().toString();
    }

    public static String toUrlPattern(String alias, String urlPattern) {
        if (!StringUtility.hasText((CharSequence)alias) || !StringUtility.hasText((CharSequence)urlPattern)) {
            return null;
        }
        return PathNormalizer.toUrlPattern(new Path(alias).append(urlPattern).toString());
    }

    public static String toServletAlias(String servletAlias) {
        if (!StringUtility.hasText((CharSequence)servletAlias)) {
            return null;
        }
        return new Path(servletAlias).makeAbsolute().removeTrailingSeparator().toString();
    }

    public static String toWsdlPath(String wsdlPath) {
        if (!StringUtility.hasText((CharSequence)wsdlPath)) {
            return null;
        }
        return new Path(wsdlPath).makeRelative().removeTrailingSeparator().toString();
    }

    public static String toTargetNamespace(String targetNamespace) {
        if (!StringUtility.hasText((CharSequence)targetNamespace)) {
            return null;
        }
        if (!targetNamespace.endsWith(SLASH_SUFFIX)) {
            return String.valueOf(targetNamespace) + SLASH_SUFFIX;
        }
        return targetNamespace;
    }

    public static String removeTrailingSeparatorFromTargetNamespace(String targetNamespace) {
        if (!StringUtility.hasText((CharSequence)targetNamespace)) {
            return null;
        }
        if (targetNamespace.endsWith(SLASH_SUFFIX)) {
            return targetNamespace.substring(0, targetNamespace.length() - 2);
        }
        return targetNamespace;
    }

    public static String toJarPath(String jarPath) {
        if (!StringUtility.hasText((CharSequence)jarPath)) {
            return null;
        }
        return new Path(jarPath).makeRelative().removeTrailingSeparator().toString();
    }
}

