/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.logger.internal.java;

import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.scout.commons.logger.JavaLogUtility;
import org.eclipse.scout.commons.logger.internal.AbstractScoutLogger;

public class JavaLogWrapper
extends AbstractScoutLogger {
    private Logger m_logger;

    public JavaLogWrapper(String name) {
        this.m_logger = Logger.getLogger(name);
    }

    @Override
    public String getName() {
        return this.m_logger.getName();
    }

    @Override
    public int getLevel() {
        Logger loggerWithLevel = this.m_logger;
        while (loggerWithLevel.getLevel() == null && loggerWithLevel.getParent() != null) {
            loggerWithLevel = loggerWithLevel.getParent();
        }
        return JavaLogUtility.javaToScoutLevel(loggerWithLevel.getLevel());
    }

    @Override
    public void setLevel(int level) {
        this.m_logger.setLevel(JavaLogUtility.scoutToJavaLevel(level));
    }

    @Override
    protected void logImpl(LogRecord record) {
        this.m_logger.log(record);
    }

    @Override
    public boolean isLoggable(int logLevel) {
        return this.m_logger.isLoggable(JavaLogUtility.scoutToJavaLevel(logLevel));
    }
}

