/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.session;

import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.jaxws.Activator;
import org.eclipse.scout.jaxws.session.DefaultServerSessionFactory;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServiceTunnelServlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@Deprecated
public class ServerSessionClassFinder {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ServerSessionClassFinder.class);

    public static Class<? extends IServerSession> find() {
        Class<? extends IServerSession> serverSessionClass = ServerSessionClassFinder.resolveJaxWsServerSession();
        if (serverSessionClass != null) {
            return serverSessionClass;
        }
        Bundle bundle = ServerSessionClassFinder.findServletContributorBundle();
        if (bundle == null) {
            LOG.error("Failed to find server session class. Specify the property '" + DefaultServerSessionFactory.PROP_QN_SESSION + "' in config.ini accordingly.");
            return null;
        }
        String fqn = String.valueOf(bundle.getSymbolicName()) + ".ServerSession";
        serverSessionClass = ServerSessionClassFinder.loadServerSessionSafe(bundle, fqn);
        if (serverSessionClass == null) {
            LOG.error("Failed to load server session class '" + fqn + "' from bundle '" + bundle.getSymbolicName() + "'. Specify the property '" + DefaultServerSessionFactory.PROP_QN_SESSION + "' in config.ini accordingly.");
            return null;
        }
        return serverSessionClass;
    }

    private static Bundle findServletContributorBundle() {
        IExtensionPoint xpServlet;
        block16: {
            IExtensionRegistry reg;
            block15: {
                ServiceReference ref;
                BundleContext context;
                block14: {
                    context = Activator.getDefault().getBundle().getBundleContext();
                    ref = context.getServiceReference(IExtensionRegistry.class.getName());
                    if (ref != null) break block14;
                    return null;
                }
                reg = (IExtensionRegistry)context.getService(ref);
                if (reg != null) break block15;
                return null;
            }
            xpServlet = reg.getExtensionPoint("org.eclipse.equinox.http.registry.servlets");
            if (xpServlet != null) break block16;
            return null;
        }
        try {
            HashSet<Bundle> serviceTunnelContributorBundles = new HashSet<Bundle>();
            IExtension[] iExtensionArray = xpServlet.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension xServlet = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = xServlet.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement cServlet = iConfigurationElementArray[n4];
                    if (cServlet.getName().equals("servlet")) {
                        String servletFqn = cServlet.getAttribute("class");
                        Bundle bundle = Platform.getBundle((String)cServlet.getContributor().getName());
                        try {
                            Class servletClass = bundle.loadClass(servletFqn);
                            if (ServiceTunnelServlet.class.isAssignableFrom(servletClass)) {
                                serviceTunnelContributorBundles.add(bundle);
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            int count = serviceTunnelContributorBundles.size();
            if (count == 1) {
                return (Bundle)serviceTunnelContributorBundles.iterator().next();
            }
            if (count == 0) {
                LOG.warn("No contribution bundle found for servlet '" + ServiceTunnelServlet.class.getSimpleName() + "'");
            } else {
                LOG.warn("Multiple contribution bundles found for servlet '" + ServiceTunnelServlet.class.getSimpleName() + "'.");
            }
        }
        catch (Throwable e) {
            LOG.error("failed to find servlet contributor", e);
        }
        return null;
    }

    private static Class<? extends IServerSession> resolveJaxWsServerSession() {
        Bundle bundle;
        String qnSession = Activator.getDefault().getBundle().getBundleContext().getProperty(DefaultServerSessionFactory.PROP_QN_SESSION);
        String snBundle = Activator.getDefault().getBundle().getBundleContext().getProperty(DefaultServerSessionFactory.PROP_SN_BUNDLE);
        if (!StringUtility.hasText((CharSequence)qnSession)) {
            return null;
        }
        if (!StringUtility.hasText((CharSequence)snBundle) && qnSession.split("\\.").length == 0) {
            LOG.error("Session class '" + qnSession + "' configured in config.ini '" + DefaultServerSessionFactory.PROP_QN_SESSION + "' must be fully qualified if not used in conjunction with belonging bundle '" + snBundle + "'.");
            return null;
        }
        if (StringUtility.hasText((CharSequence)snBundle)) {
            bundle = Platform.getBundle((String)snBundle);
            if (bundle == null) {
                LOG.error("Bundle with the symbolic name '" + snBundle + "' configured in config.ini '" + DefaultServerSessionFactory.PROP_SN_BUNDLE + "' could not be resolved. Please ensure to have typed the symbolic name correctly and that the bundle is resolved without errors.");
                return null;
            }
        } else {
            String symbolicName = qnSession.substring(0, qnSession.lastIndexOf(46));
            bundle = Platform.getBundle((String)symbolicName);
            if (bundle == null) {
                LOG.error("Bundle with the symbolic name '" + symbolicName + "' configured in config.ini could not be found. The attempt to derive the symbolic name from within the configured session '" + DefaultServerSessionFactory.PROP_QN_SESSION + "' failed. If the package name of the session does not correspond to the symbolic name of the bundle, please specify '" + DefaultServerSessionFactory.PROP_SN_BUNDLE + "' accordingly.");
                return null;
            }
        }
        return ServerSessionClassFinder.loadServerSessionSafe(bundle, qnSession);
    }

    private static Class<? extends IServerSession> loadServerSessionSafe(Bundle bundle, String serverSessionFqn) {
        try {
            Class clazz = bundle.loadClass(serverSessionFqn);
            if (IServerSession.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            LOG.error("Server session class '" + serverSessionFqn + "' could not be loaded as not of the type '" + IServerSession.class.getName() + "'");
        }
        catch (ClassNotFoundException e) {
            LOG.error("Server session class '" + serverSessionFqn + "' could not be found");
        }
        return null;
    }
}

