/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.activitymap;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.CompositeLong;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.IOrdered;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.OrderedCollection;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.action.tree.MoveActionNodesHandler;
import org.eclipse.scout.rt.client.extension.ui.basic.activitymap.ActivityMapChains;
import org.eclipse.scout.rt.client.extension.ui.basic.activitymap.IActivityMapExtension;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.IActivityMapContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.ActivityMapContextMenu;
import org.eclipse.scout.rt.client.ui.basic.activitymap.ActivityCell;
import org.eclipse.scout.rt.client.ui.basic.activitymap.ActivityMapEvent;
import org.eclipse.scout.rt.client.ui.basic.activitymap.ActivityMapListener;
import org.eclipse.scout.rt.client.ui.basic.activitymap.IActivityCellObserver;
import org.eclipse.scout.rt.client.ui.basic.activitymap.IActivityMap;
import org.eclipse.scout.rt.client.ui.basic.activitymap.IActivityMapUIFacade;
import org.eclipse.scout.rt.client.ui.basic.activitymap.MajorTimeColumn;
import org.eclipse.scout.rt.client.ui.basic.activitymap.MinorTimeColumn;
import org.eclipse.scout.rt.client.ui.basic.activitymap.MultiTimeRange;
import org.eclipse.scout.rt.client.ui.basic.activitymap.TimeRange;
import org.eclipse.scout.rt.client.ui.basic.activitymap.TimeScale;
import org.eclipse.scout.rt.client.ui.basic.activitymap.TimeScaleBuilder;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractActivityMap<RI, AI>
extends AbstractPropertyObserver
implements IActivityMap<RI, AI>,
IContributionOwner,
IExtensibleObject {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractActivityMap.class);
    private boolean m_initialized;
    private EventListenerList m_listenerList;
    private IActivityMapUIFacade m_activityMapUIFacade;
    private long m_minimumActivityDuration;
    private Map<RI, List<ActivityCell<RI, AI>>> m_resourceIdToActivities;
    private Map<CompositeObject, ActivityCell<RI, AI>> m_activities;
    private Set<RI> m_selectedResourceIds;
    private int m_tableChanging;
    private List<ActivityMapEvent> m_eventBuffer = new ArrayList<ActivityMapEvent>();
    private IActivityCellObserver<RI, AI> m_cellObserver;
    private boolean m_timeScaleValid;
    private IContributionOwner m_contributionHolder;
    private final ObjectExtensions<AbstractActivityMap<RI, AI>, IActivityMapExtension<RI, AI, ? extends AbstractActivityMap<RI, AI>>> m_objectExtensions = new ObjectExtensions((Object)this);
    private Class<RI> m_resourceIdClass;
    private Class<AI> m_activityIdClass;

    public AbstractActivityMap() {
        this(true);
    }

    public AbstractActivityMap(boolean callInitializer) {
        if (callInitializer) {
            this.callInitializer();
        }
    }

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <T> T getContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.getContribution(contribution);
    }

    protected void callInitializer() {
        if (!this.m_initialized) {
            this.interceptInitConfig();
            this.m_initialized = true;
        }
    }

    private Class<RI> getResourceIdClass() {
        if (this.m_resourceIdClass == null) {
            this.m_resourceIdClass = TypeCastUtility.getGenericsParameterClass(this.getClass(), IActivityMap.class, (int)0);
        }
        return this.m_resourceIdClass;
    }

    private Class<AI> getActivityIdClass() {
        if (this.m_activityIdClass == null) {
            this.m_activityIdClass = TypeCastUtility.getGenericsParameterClass(this.getClass(), IActivityMap.class, (int)1);
        }
        return this.m_activityIdClass;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=20.0)
    protected int getConfiguredWorkDayCount() {
        return 5;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=30.0)
    protected boolean getConfiguredWorkDaysOnly() {
        return false;
    }

    @ConfigProperty(value="HOUR_OF_DAY")
    @Order(value=110.0)
    protected int getConfiguredFirstHourOfDay() {
        return 8;
    }

    @ConfigProperty(value="HOUR_OF_DAY")
    @Order(value=130.0)
    protected int getConfiguredLastHourOfDay() {
        return 16;
    }

    @ConfigProperty(value="DURATION_MINUTES")
    @Order(value=120.0)
    protected long getConfiguredIntradayInterval() {
        return 1800000L;
    }

    @ConfigProperty(value="DURATION_MINUTES")
    @Order(value=125.0)
    protected long getConfiguredMinimumActivityDuration() {
        return 1800000L;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=140.0)
    protected boolean getConfiguredDrawSections() {
        return true;
    }

    protected List<Class<? extends IMenu>> getDeclaredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    @ConfigOperation
    @Order(value=60.0)
    protected void execDecorateActivityCell(ActivityCell<RI, AI> cell) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=70.0)
    protected void execActivityCellSelected(ActivityCell<RI, AI> cell) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=75.0)
    protected void execCellAction(RI resourceId, MinorTimeColumn column, ActivityCell<RI, AI> activityCell) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=80.0)
    protected void execInitActivityMap() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=90.0)
    protected void execDisposeActivityMap() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=100.0)
    protected TimeScale execCreateTimeScale() throws ProcessingException {
        return new TimeScaleBuilder(this).build();
    }

    @ConfigOperation
    @Order(value=110.0)
    protected void execDecorateMajorTimeColumn(TimeScale scale, MajorTimeColumn columns) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=120.0)
    protected void execDecorateMinorTimeColumn(TimeScale scale, MajorTimeColumn majorColumn, MinorTimeColumn minorColumn) throws ProcessingException {
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), new Runnable(){

            @Override
            public void run() {
                AbstractActivityMap.this.initConfig();
            }
        });
    }

    protected void initConfig() {
        this.m_listenerList = new EventListenerList();
        this.m_activityMapUIFacade = this.createUIFacade();
        this.m_resourceIdToActivities = new HashMap<RI, List<ActivityCell<RI, AI>>>();
        this.m_activities = new HashMap<CompositeObject, ActivityCell<RI, AI>>();
        this.m_cellObserver = new P_ActivityCellObserver();
        this.m_selectedResourceIds = new HashSet<RI>();
        this.setWorkDayCount(this.getConfiguredWorkDayCount());
        this.setWorkDaysOnly(this.getConfiguredWorkDaysOnly());
        this.setFirstHourOfDay(this.getConfiguredFirstHourOfDay());
        this.setIntradayInterval(this.getConfiguredIntradayInterval());
        this.setMinimumActivityDuration(this.getConfiguredMinimumActivityDuration());
        this.setLastHourOfDay(this.getConfiguredLastHourOfDay());
        this.setDrawSections(this.getConfiguredDrawSections());
        List<Class<IMenu>> declaredMenus = this.getDeclaredMenus();
        OrderedCollection menus = new OrderedCollection();
        for (Class<IMenu> menuClazz : declaredMenus) {
            try {
                IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, menuClazz);
                menus.addOrdered((IOrdered)menu);
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + menuClazz.getName() + "'.", (Throwable)e));
            }
        }
        this.m_contributionHolder = new ContributionComposite((Object)this);
        List contributedMenus = this.m_contributionHolder.getContributionsByClass(IMenu.class);
        menus.addAllOrdered((Collection)contributedMenus);
        try {
            this.injectMenusInternal((OrderedCollection<IMenu>)menus);
        }
        catch (Exception e) {
            LOG.error("error occured while dynamically contributing menus.", (Throwable)e);
        }
        new MoveActionNodesHandler(menus).moveModelObjects();
        ActivityMapContextMenu contextMenu = new ActivityMapContextMenu(this, (List<? extends IMenu>)menus.getOrderedList());
        this.setContextMenu(contextMenu);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ActivityCell cell;
                if (e.getPropertyName().equals("days")) {
                    AbstractActivityMap.this.invalidateTimeScale();
                    if (!AbstractActivityMap.this.isActivityMapChanging()) {
                        AbstractActivityMap.this.validateTimeScale();
                    }
                } else if (e.getPropertyName().equals("firstHourOfDay")) {
                    AbstractActivityMap.this.invalidateTimeScale();
                    if (!AbstractActivityMap.this.isActivityMapChanging()) {
                        AbstractActivityMap.this.validateTimeScale();
                    }
                } else if (e.getPropertyName().equals("lastHourOfDay")) {
                    AbstractActivityMap.this.invalidateTimeScale();
                    if (!AbstractActivityMap.this.isActivityMapChanging()) {
                        AbstractActivityMap.this.validateTimeScale();
                    }
                } else if (e.getPropertyName().equals("intradayInterval")) {
                    AbstractActivityMap.this.invalidateTimeScale();
                    if (!AbstractActivityMap.this.isActivityMapChanging()) {
                        AbstractActivityMap.this.validateTimeScale();
                    }
                } else if (e.getPropertyName().equals("planningMode")) {
                    AbstractActivityMap.this.invalidateTimeScale();
                    if (!AbstractActivityMap.this.isActivityMapChanging()) {
                        AbstractActivityMap.this.validateTimeScale();
                    }
                } else if (e.getPropertyName().equals("selectedActivityCell") && (cell = (ActivityCell)((Object)e.getNewValue())) != null) {
                    try {
                        AbstractActivityMap.this.interceptActivityCellSelected(cell);
                    }
                    catch (ProcessingException t) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(t);
                    }
                    catch (Throwable t) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
                    }
                }
            }
        });
        this.createTimeScale();
    }

    public final List<? extends IActivityMapExtension<RI, AI, ? extends AbstractActivityMap<RI, AI>>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    protected IActivityMapExtension<RI, AI, ? extends AbstractActivityMap<RI, AI>> createLocalExtension() {
        return new LocalActivityMapExtension(this);
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    protected void injectMenusInternal(OrderedCollection<IMenu> menus) {
    }

    protected IActivityMapUIFacade createUIFacade() {
        return new P_ActivityMapUIFacade();
    }

    @Override
    public final void initActivityMap() throws ProcessingException {
        this.initActivityMapInternal();
        this.interceptInitActivityMap();
        ActionUtility.initActions(this.getMenus());
    }

    protected void initActivityMapInternal() throws ProcessingException {
    }

    @Override
    public final void disposeActivityMap() {
        this.disposeActivityMapInternal();
        try {
            this.interceptDisposeActivityMap();
        }
        catch (Throwable t) {
            LOG.warn(this.getClass().getName(), t);
        }
    }

    protected void disposeActivityMapInternal() {
    }

    private void invalidateTimeScale() {
        this.m_timeScaleValid = false;
    }

    private void validateTimeScale() {
        if (!this.m_timeScaleValid) {
            this.m_timeScaleValid = true;
            this.createTimeScale();
        }
    }

    @Override
    public void createTimeScale() {
        try {
            TimeScale scale = this.interceptCreateTimeScale();
            this.setTimeScale(scale);
        }
        catch (ProcessingException t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(t);
        }
        catch (Throwable t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
        }
    }

    @Override
    public TimeScale getTimeScale() {
        TimeScale scale = (TimeScale)this.propertySupport.getProperty("timeScale");
        if (scale == null) {
            scale = new TimeScale();
        }
        return scale;
    }

    @Override
    public void setTimeScale(TimeScale scale) {
        if (scale == null) {
            scale = new TimeScale();
        }
        this.propertySupport.setProperty("timeScale", (Object)scale);
    }

    @Override
    public void addActivityMapListener(ActivityMapListener listener) {
        this.m_listenerList.add(ActivityMapListener.class, (EventListener)listener);
    }

    @Override
    public void removeActivityMapListener(ActivityMapListener listener) {
        this.m_listenerList.remove(ActivityMapListener.class, (EventListener)listener);
    }

    @Override
    public ActivityCell<RI, AI> resolveActivityCell(ActivityCell<RI, AI> cell) {
        if (cell == null) {
            return cell;
        }
        return this.m_activities.get(new CompositeObject(new Object[]{cell.getResourceId(), cell.getActivityId()}));
    }

    @Override
    public List<ActivityCell<RI, AI>> resolveActivityCells(List<? extends ActivityCell<RI, AI>> cells) {
        if (cells == null) {
            return CollectionUtility.emptyArrayList();
        }
        ArrayList<ActivityCell<RI, AI>> result = new ArrayList<ActivityCell<RI, AI>>(cells.size());
        for (ActivityCell<RI, AI> cell : cells) {
            if (this.resolveActivityCell(cell) != cell) continue;
            result.add(cell);
        }
        return result;
    }

    @Override
    public List<ActivityCell<RI, AI>> getActivityCells(RI resourceId) {
        ArrayList<RI> resourceList = new ArrayList<RI>();
        resourceList.add(resourceId);
        return this.getActivityCells((List<? extends RI>)resourceList);
    }

    @Override
    public List<ActivityCell<RI, AI>> getActivityCells(List<? extends RI> resourceIds) {
        ArrayList<ActivityCell<RI, AI>> all = new ArrayList<ActivityCell<RI, AI>>();
        for (RI resourceId : resourceIds) {
            List<ActivityCell<RI, AI>> list = this.m_resourceIdToActivities.get(resourceId);
            if (list == null) continue;
            all.addAll(list);
        }
        return all;
    }

    @Override
    public List<ActivityCell<RI, AI>> getAllActivityCells() {
        return new ArrayList<ActivityCell<RI, AI>>(this.m_activities.values());
    }

    @Override
    public void addActivityCells(List<? extends ActivityCell<RI, AI>> cells) {
        ArrayList<ActivityCell<RI, AI>> addedCells = new ArrayList<ActivityCell<RI, AI>>();
        for (ActivityCell<RI, AI> cell : cells) {
            CompositeObject key = new CompositeObject(new Object[]{cell.getResourceId(), cell.getActivityId()});
            if (this.m_activities.containsKey(key)) continue;
            this.m_activities.put(key, cell);
            List<ActivityCell<RI, AI>> list = this.m_resourceIdToActivities.get(cell.getResourceId());
            if (list == null) {
                list = new ArrayList<ActivityCell<RI, AI>>();
                this.m_resourceIdToActivities.put(cell.getResourceId(), list);
            }
            list.add(cell);
            addedCells.add(cell);
            this.decorateActivityCell(cell);
            cell.setObserver(this.m_cellObserver);
        }
        if (addedCells.size() > 0) {
            this.fireActivitiesInserted(addedCells);
        }
    }

    @Override
    public void updateActivityCells(List<? extends ActivityCell<RI, AI>> cells) {
        cells = this.resolveActivityCells(cells);
        this.updateActivityCellsInternal(cells);
    }

    @Override
    public void updateActivityCellsById(List<? extends RI> resourceIds) {
        this.updateActivityCellsInternal(this.getActivityCells(resourceIds));
    }

    private void updateActivityCellsInternal(List<? extends ActivityCell<RI, AI>> cells) {
        for (ActivityCell<RI, AI> cell : cells) {
            this.decorateActivityCell(cell);
        }
        this.fireActivitiesUpdated(cells);
    }

    @Override
    public void removeActivityCells(List<? extends ActivityCell<RI, AI>> cells) {
        cells = this.resolveActivityCells(cells);
        this.removeActivityCellsInternal(cells);
    }

    @Override
    public void removeActivityCellsById(List<? extends RI> resourceIds) {
        this.removeActivityCellsInternal(this.getActivityCells(resourceIds));
    }

    private void removeActivityCellsInternal(List<? extends ActivityCell<RI, AI>> cells) {
        if (CollectionUtility.hasElements(cells)) {
            for (ActivityCell cell : cells) {
                cell.setObserver(null);
                this.m_activities.remove(new CompositeObject(new Object[]{cell.getResourceId(), cell.getActivityId()}));
                List<ActivityCell<RI, AI>> list = this.m_resourceIdToActivities.get(cell.getResourceId());
                if (list == null) continue;
                list.remove((Object)cell);
            }
            this.fireActivitiesDeleted(cells);
        }
    }

    @Override
    public void removeAllActivityCells() {
        List<ActivityCell<RI, AI>> a = this.getAllActivityCells();
        if (CollectionUtility.hasElements(a)) {
            for (ActivityCell cell : a) {
                cell.setObserver(null);
            }
            this.m_activities.clear();
            this.m_resourceIdToActivities.clear();
            this.fireAllActivitiesDeleted(a);
        }
    }

    @Override
    public ActivityCell<RI, AI> getSelectedActivityCell() {
        return (ActivityCell)((Object)this.propertySupport.getProperty("selectedActivityCell"));
    }

    @Override
    public void setSelectedActivityCell(ActivityCell<RI, AI> cell) {
        cell = this.resolveActivityCell(cell);
        this.propertySupport.setProperty("selectedActivityCell", cell);
    }

    @Override
    public boolean isSelectedActivityCell(ActivityCell<RI, AI> cell) {
        return this.getSelectedActivityCell() == cell;
    }

    @Override
    public List<RI> getSelectedResourceIds() {
        List a = (List)this.propertySupport.getProperty("selectedResourceIds");
        if (a == null) {
            a = CollectionUtility.emptyArrayList();
        }
        return a;
    }

    @Override
    public void setSelectedResourceIds(List<? extends RI> resourceIds) {
        ArrayList internalResourceIds = CollectionUtility.arrayList(resourceIds);
        this.m_selectedResourceIds.clear();
        this.m_selectedResourceIds.addAll(internalResourceIds);
        this.propertySupport.setProperty("selectedResourceIds", (Object)internalResourceIds);
        if (CollectionUtility.size((Collection)internalResourceIds) != 1) {
            this.setSelectedActivityCell(null);
            return;
        }
        ActivityCell<RI, AI> selectedCell = this.getSelectedActivityCell();
        if (selectedCell == null) {
            return;
        }
        Object resourceId = CollectionUtility.firstElement(resourceIds);
        if (CompareUtility.notEquals((Object)resourceId, selectedCell.getResourceId())) {
            this.setSelectedActivityCell(null);
        }
    }

    @Override
    public List<RI> getResourceIds() {
        List resourceIds = (List)this.propertySupport.getProperty("resourceIds");
        if (resourceIds == null) {
            return CollectionUtility.emptyArrayList();
        }
        return CollectionUtility.arrayList((Collection)resourceIds);
    }

    @Override
    public void setResourceIds(List<? extends RI> resourceIds) {
        if (resourceIds == null) {
            resourceIds = CollectionUtility.emptyArrayList();
        }
        HashSet<RI> eliminatedResourceIdSet = new HashSet<RI>();
        eliminatedResourceIdSet.addAll(this.getResourceIds());
        eliminatedResourceIdSet.removeAll(resourceIds);
        try {
            this.setActivityMapChanging(true);
            this.propertySupport.setProperty("resourceIds", (Object)resourceIds);
            this.removeActivityCellsById(new ArrayList(eliminatedResourceIdSet));
            this.updateActivityCellsInternal(this.getAllActivityCells());
        }
        finally {
            this.setActivityMapChanging(false);
        }
    }

    @Override
    public void isSelectedResourceId(RI resourceId) {
        this.m_selectedResourceIds.contains(resourceId);
    }

    @Override
    public void setDrawSections(boolean drawSections) {
        this.propertySupport.setProperty("drawSections", (Object)drawSections);
    }

    @Override
    public boolean isDrawSections() {
        return this.propertySupport.getPropertyBool("drawSections");
    }

    @Override
    public void setMenus(List<? extends IMenu> menus) {
        this.getContextMenu().setChildActions(menus);
    }

    @Override
    public void addMenu(IMenu menu) {
        List<IMenu> menus = this.getMenus();
        menus.add(menu);
        this.setMenus(menus);
    }

    protected void setContextMenu(IActivityMapContextMenu contextMenu) {
        this.propertySupport.setProperty("contextMenus", (Object)contextMenu);
    }

    @Override
    public IActivityMapContextMenu getContextMenu() {
        return (IActivityMapContextMenu)this.propertySupport.getProperty("contextMenus");
    }

    @Override
    public List<IMenu> getMenus() {
        return this.getContextMenu().getChildActions();
    }

    private void fireCellAction(RI resourceId, MinorTimeColumn column, ActivityCell<RI, AI> activityCell) {
        try {
            this.interceptCellAction(resourceId, column, activityCell);
        }
        catch (ProcessingException t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(t);
        }
        catch (Throwable t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
        }
        ActivityMapEvent e = new ActivityMapEvent(this, 104, resourceId, column, activityCell);
        this.fireActivityMapEventInternal(e);
    }

    private void fireActivitiesInserted(List<? extends ActivityCell<RI, AI>> a) {
        ActivityMapEvent e = new ActivityMapEvent((IActivityMap)this, 100, a);
        this.fireActivityMapEventInternal(e);
    }

    private void fireActivitiesUpdated(List<? extends ActivityCell<RI, AI>> a) {
        ActivityMapEvent e = new ActivityMapEvent((IActivityMap)this, 101, a);
        this.fireActivityMapEventInternal(e);
    }

    private void fireActivitiesDeleted(List<? extends ActivityCell<RI, AI>> a) {
        ActivityMapEvent e = new ActivityMapEvent((IActivityMap)this, 102, a);
        this.fireActivityMapEventInternal(e);
    }

    private void fireAllActivitiesDeleted(List<? extends ActivityCell<RI, AI>> a) {
        ActivityMapEvent e = new ActivityMapEvent((IActivityMap)this, 105, a);
        this.fireActivityMapEventInternal(e);
    }

    private void fireActivityMapEventInternal(ActivityMapEvent e) {
        if (this.isActivityMapChanging()) {
            this.m_eventBuffer.add(e);
        } else {
            EventListener[] listeners = this.m_listenerList.getListeners(ActivityMapListener.class);
            if (listeners != null && listeners.length > 0) {
                int i = 0;
                while (i < listeners.length) {
                    ((ActivityMapListener)listeners[i]).activityMapChanged(e);
                    ++i;
                }
            }
        }
    }

    private void fireActivityMapEventBatchInternal(ActivityMapEvent[] batch) {
        EventListener[] listeners;
        if (this.isActivityMapChanging()) {
            LOG.error("Illegal State: firing an event batch while table is changing");
        } else if (batch.length > 0 && (listeners = this.m_listenerList.getListeners(ActivityMapListener.class)) != null && listeners.length > 0) {
            int i = 0;
            while (i < listeners.length) {
                ActivityMapEvent[] activityMapEventArray = batch;
                int n = batch.length;
                int n2 = 0;
                while (n2 < n) {
                    ActivityMapEvent e = activityMapEventArray[n2];
                    ((ActivityMapListener)listeners[i]).activityMapChanged(e);
                    ++n2;
                }
                ++i;
            }
        }
    }

    private void processChangeBuffer() {
        List<ActivityMapEvent> list = this.m_eventBuffer;
        this.m_eventBuffer = new ArrayList<ActivityMapEvent>();
        if (list.size() > 0) {
            HashMap<Integer, ArrayList<ActivityMapEvent>> coalesceMap = new HashMap<Integer, ArrayList<ActivityMapEvent>>();
            for (ActivityMapEvent e : list) {
                ArrayList<ActivityMapEvent> subList = (ArrayList<ActivityMapEvent>)coalesceMap.get(e.getType());
                if (subList == null) {
                    subList = new ArrayList<ActivityMapEvent>();
                    coalesceMap.put(e.getType(), subList);
                }
                subList.add(e);
            }
            TreeMap<Integer, ActivityMapEvent> sortedCoalescedMap = new TreeMap<Integer, ActivityMapEvent>();
            for (Map.Entry entry : coalesceMap.entrySet()) {
                int type = (Integer)entry.getKey();
                List subList = (List)entry.getValue();
                int lastIndex = subList.size() - 1;
                switch (type) {
                    case 105: {
                        sortedCoalescedMap.put(10, (ActivityMapEvent)subList.get(lastIndex));
                        break;
                    }
                    case 100: {
                        sortedCoalescedMap.put(20, this.coalesceActivityMapEvents(subList));
                        break;
                    }
                    case 102: {
                        sortedCoalescedMap.put(30, this.coalesceActivityMapEvents(subList));
                        break;
                    }
                    case 101: {
                        sortedCoalescedMap.put(40, this.coalesceActivityMapEvents(subList));
                        break;
                    }
                    case 104: {
                        sortedCoalescedMap.put(50, (ActivityMapEvent)subList.get(lastIndex));
                        break;
                    }
                    default: {
                        sortedCoalescedMap.put(-type, (ActivityMapEvent)subList.get(lastIndex));
                    }
                }
            }
            this.fireActivityMapEventBatchInternal(sortedCoalescedMap.values().toArray(new ActivityMapEvent[sortedCoalescedMap.size()]));
        }
    }

    private ActivityMapEvent coalesceActivityMapEvents(List<ActivityMapEvent> list) {
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        ActivityMapEvent last = list.get(list.size() - 1);
        ActivityMapEvent ce = new ActivityMapEvent(last.getActivityMap(), last.getType());
        ce.addPopupMenus(last.getPopupMenus());
        HashSet<ActivityCell> coalesceList = new HashSet<ActivityCell>();
        for (ActivityMapEvent t : list) {
            if (t.getActivityCount() <= 0) continue;
            coalesceList.addAll(t.getActivities());
        }
        ce.setActivities(new ArrayList(coalesceList));
        return ce;
    }

    @Override
    public boolean isActivityMapChanging() {
        return this.m_tableChanging > 0;
    }

    @Override
    public void setActivityMapChanging(boolean b) {
        if (b) {
            ++this.m_tableChanging;
            if (this.m_tableChanging == 1) {
                this.propertySupport.setPropertiesChanging(true);
            }
        } else if (this.m_tableChanging > 0) {
            --this.m_tableChanging;
            if (this.m_tableChanging == 0) {
                try {
                    this.validateTimeScale();
                    this.processChangeBuffer();
                }
                finally {
                    this.propertySupport.setPropertiesChanging(false);
                }
            }
        }
    }

    @Override
    public Date getBeginTime() {
        Calendar cal = Calendar.getInstance();
        Date[] a = this.getDays();
        if (a.length > 0) {
            cal.setTime(a[0]);
        } else {
            cal.setTime(DateUtility.truncDate((Date)new Date()));
        }
        switch (this.getPlanningMode()) {
            case 0: {
                cal.set(11, this.getFirstHourOfDay());
                break;
            }
            case 1: {
                break;
            }
        }
        return cal.getTime();
    }

    @Override
    public Date getEndTime() {
        Calendar cal = Calendar.getInstance();
        Date[] a = this.getDays();
        if (a.length > 0) {
            cal.setTime(a[a.length - 1]);
        } else {
            cal.setTime(DateUtility.truncDate((Date)new Date()));
        }
        switch (this.getPlanningMode()) {
            case 0: {
                cal.set(11, this.getLastHourOfDay());
                break;
            }
            case 1: {
                cal.add(5, 1);
                break;
            }
            case 2: {
                cal.add(5, 7);
            }
        }
        return cal.getTime();
    }

    @Override
    public void addDay(Date day) {
        if ((day = DateUtility.truncDate((Date)day)) != null) {
            TreeSet<Date> set = new TreeSet<Date>();
            set.addAll(Arrays.asList(this.getDays()));
            set.add(day);
            this.setDaysInternal(set);
        }
    }

    @Override
    public void removeDay(Date day) {
        if ((day = DateUtility.truncDate((Date)day)) != null) {
            TreeSet<Date> set = new TreeSet<Date>();
            set.addAll(Arrays.asList(this.getDays()));
            set.remove(day);
            this.setDaysInternal(set);
        }
    }

    @Override
    public void setDay(Date day) {
        day = DateUtility.truncDate((Date)day);
        TreeSet<Date> set = new TreeSet<Date>();
        if (day != null) {
            set.add(day);
        }
        this.setDaysInternal(set);
    }

    @Override
    public void setDays(Date[] days) {
        TreeSet<Date> set = new TreeSet<Date>();
        Date[] dateArray = days;
        int n = days.length;
        int n2 = 0;
        while (n2 < n) {
            Date d = dateArray[n2];
            set.add(DateUtility.truncDate((Date)d));
            ++n2;
        }
        this.setDaysInternal(set);
    }

    private void setDaysInternal(TreeSet<Date> set) {
        this.propertySupport.setProperty("days", (Object)set.toArray(new Date[set.size()]));
    }

    @Override
    public Date[] getDays() {
        Date[] a = (Date[])this.propertySupport.getProperty("days");
        if (a == null) {
            a = new Date[]{};
        }
        return a;
    }

    @Override
    public int getWorkDayCount() {
        return this.propertySupport.getPropertyInt("workDayCount");
    }

    @Override
    public void setWorkDayCount(int n) {
        if (n < 1 || n > 6) {
            return;
        }
        this.propertySupport.setPropertyInt("workDayCount", n);
    }

    @Override
    public boolean isWorkDaysOnly() {
        return this.propertySupport.getPropertyBool("workDaysOnly");
    }

    @Override
    public void setWorkDaysOnly(boolean b) {
        this.propertySupport.setPropertyBool("workDaysOnly", b);
    }

    @Override
    public int getFirstHourOfDay() {
        return this.propertySupport.getPropertyInt("firstHourOfDay");
    }

    @Override
    public void setFirstHourOfDay(int i) {
        this.propertySupport.setPropertyInt("firstHourOfDay", i);
    }

    @Override
    public int getLastHourOfDay() {
        return this.propertySupport.getPropertyInt("lastHourOfDay");
    }

    @Override
    public void setLastHourOfDay(int i) {
        this.propertySupport.setPropertyInt("lastHourOfDay", i);
    }

    @Override
    public long getIntradayInterval() {
        return this.propertySupport.getPropertyInt("intradayInterval");
    }

    @Override
    public void setIntradayInterval(long millis) {
        if (millis < 900000L || millis > 86400000L) {
            throw new IllegalArgumentException("intradayIntervalMinutes must be between 15 minutes and 24 hours");
        }
        this.propertySupport.setPropertyLong("intradayInterval", millis);
    }

    @Override
    public void setIntradayIntervalInMinutes(long min) {
        this.setIntradayInterval(min * 60000L);
    }

    @Override
    public long getMinimumActivityDuration() {
        return this.m_minimumActivityDuration;
    }

    @Override
    public void setMinimumActivityDuration(long minDuration) {
        this.m_minimumActivityDuration = minDuration;
    }

    @Override
    public void setMinimumActivityDurationInMinutes(long min) {
        this.setMinimumActivityDuration(min * 60000L);
    }

    @Override
    public int getPlanningMode() {
        return this.propertySupport.getPropertyInt("planningMode");
    }

    @Override
    public void setPlanningMode(int mode) {
        this.propertySupport.setPropertyInt("planningMode", mode);
    }

    @Override
    public Date getSelectedBeginTime() {
        return (Date)this.propertySupport.getProperty("selectedBeginTime");
    }

    @Override
    public Date getSelectedEndTime() {
        return (Date)this.propertySupport.getProperty("selectedEndTime");
    }

    @Override
    public void setSelectedTime(Date beginTime, Date endTime) {
        try {
            this.setActivityMapChanging(true);
            this.propertySupport.setProperty("selectedBeginTime", (Object)beginTime);
            this.propertySupport.setProperty("selectedEndTime", (Object)endTime);
            List<RI> selectedResourceIds = this.getSelectedResourceIds();
            if (selectedResourceIds.size() == 1) {
                Object resourceId = CollectionUtility.firstElement(selectedResourceIds);
                List<ActivityCell<Object, AI>> activityCells = this.getActivityCells(resourceId);
                for (ActivityCell<Object, AI> cell : activityCells) {
                    if (!CompareUtility.equals((Object)cell.getBeginTime(), (Object)beginTime) || !CompareUtility.equals((Object)cell.getEndTime(), (Object)endTime) && (cell == null || cell.getEndTime() == null || endTime == null || cell.getEndTime().getTime() != endTime.getTime() + 1L)) continue;
                    this.setSelectedActivityCell(cell);
                    return;
                }
            }
            this.setSelectedActivityCell(null);
        }
        finally {
            this.setActivityMapChanging(false);
        }
    }

    @Override
    public Object getContainer() {
        return this.propertySupport.getProperty("container");
    }

    public void setContainerInternal(Object container) {
        this.propertySupport.setProperty("container", container);
    }

    @Override
    public void decorateActivityCell(ActivityCell<RI, AI> cell) {
        try {
            try {
                cell.setObserver(null);
                this.decorateActivityCellInternal(cell);
                this.interceptDecorateActivityCell(cell);
            }
            catch (ProcessingException t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(t);
                cell.setObserver(this.m_cellObserver);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
                cell.setObserver(this.m_cellObserver);
            }
        }
        finally {
            cell.setObserver(this.m_cellObserver);
        }
    }

    protected void decorateActivityCellInternal(ActivityCell<RI, AI> p) {
        String from;
        String to = from = this.getTimeScale().getDateFormat().format(p.getBeginTime());
        if (p.getEndTime() != null) {
            to = this.getTimeScale().getDateFormat().format(p.getEndTime());
        }
        if (from.equals(to)) {
            p.setTooltipText(from);
        } else {
            p.setTooltipText(String.valueOf(from) + " - " + to);
        }
    }

    @Override
    public MultiTimeRange calculateSelectedTimeRanges(Date earliestBeginTime, Date latestEndTime) {
        Date max;
        MultiTimeRange multiRange = new MultiTimeRange();
        Calendar cal = Calendar.getInstance();
        Date[] dateArray = this.getDays();
        int n = dateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Date d = dateArray[n2];
            cal.setTime(d);
            cal.set(11, this.getFirstHourOfDay());
            Date from = cal.getTime();
            cal.set(11, this.getLastHourOfDay());
            cal.add(11, 1);
            Date to = cal.getTime();
            multiRange.add(from, to);
            ++n2;
        }
        Date min = multiRange.getBeginDate();
        if (min != null && min.before(earliestBeginTime)) {
            multiRange.remove(min, earliestBeginTime);
        }
        if ((max = multiRange.getEndDate()) != null && max.after(latestEndTime)) {
            multiRange.remove(latestEndTime, max);
        }
        return multiRange;
    }

    @Override
    public void planActivityForSelectedResources(boolean singleMatch, boolean chooseRandom, Date earliestBeginTime, Date latestEndTime, long preferredDuration) {
        earliestBeginTime = DateUtility.toUtilDate((Date)earliestBeginTime);
        latestEndTime = DateUtility.toUtilDate((Date)latestEndTime);
        if (earliestBeginTime == null) {
            earliestBeginTime = new Date();
        }
        if (latestEndTime == null) {
            latestEndTime = new Date(System.currentTimeMillis() + 315360000000L);
        }
        if (preferredDuration <= 0L) {
            preferredDuration = 1800000L;
        }
        this.setSelectedTime(null, null);
        if (singleMatch) {
            this.planActivityForSelectedResourcesSingleInternal(chooseRandom, earliestBeginTime, latestEndTime, preferredDuration);
        } else {
            this.planActivityForSelectedResourcesMultiInternal(earliestBeginTime, latestEndTime, preferredDuration);
        }
    }

    private void planActivityForSelectedResourcesSingleInternal(boolean chooseRandom, Date earliestBeginTime, Date latestEndTime, long preferredDuration) {
        MultiTimeRange multiTimeRange = this.calculateSelectedTimeRanges(earliestBeginTime, latestEndTime);
        if (multiTimeRange.isEmpty()) {
            return;
        }
        TreeMap<CompositeLong, ActivityCell<Integer, Integer>> sortMap = new TreeMap<CompositeLong, ActivityCell<Integer, Integer>>();
        Random rnd = new Random();
        int resourceIndex = 0;
        for (RI resourceId : this.getSelectedResourceIds()) {
            MultiTimeRange localTimeRanges = (MultiTimeRange)multiTimeRange.clone();
            for (ActivityCell<RI, AI> a : this.getActivityCells(resourceId)) {
                localTimeRanges.remove(a.getBeginTime(), a.getEndTime());
            }
            TimeRange[] timeRangeArray = localTimeRanges.getTimeRanges();
            int n = timeRangeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityCell<Integer, Integer> a;
                long sortNo;
                TimeRange tr = timeRangeArray[n2];
                long durationMillis = tr.getDurationMillis();
                long l = sortNo = chooseRandom ? rnd.nextLong() : (long)resourceIndex;
                if (durationMillis >= preferredDuration) {
                    a = new ActivityCell<Integer, Integer>(0, 0);
                    a.setBeginTime(tr.getFrom());
                    a.setEndTime(new Date(tr.getFrom().getTime() + preferredDuration));
                    sortMap.put(new CompositeLong(0L, a.getBeginTime().getTime(), sortNo), a);
                } else if (durationMillis >= 900000L) {
                    a = new ActivityCell<Integer, Integer>(0, 0);
                    a.setBeginTime(tr.getFrom());
                    a.setEndTime(new Date(tr.getFrom().getTime() + durationMillis));
                    sortMap.put(new CompositeLong(1L, -durationMillis, sortNo), a);
                }
                ++n2;
            }
            ++resourceIndex;
        }
        if (!sortMap.isEmpty()) {
            ActivityCell a = (ActivityCell)((Object)sortMap.get(sortMap.firstKey()));
            this.setSelectedTime(a.getBeginTime(), a.getEndTime());
        }
    }

    private void planActivityForSelectedResourcesMultiInternal(Date earliestBeginTime, Date latestEndTime, long preferredDuration) {
        MultiTimeRange multiTimeRange = this.calculateSelectedTimeRanges(earliestBeginTime, latestEndTime);
        if (multiTimeRange.isEmpty()) {
            return;
        }
        TreeMap<CompositeLong, ActivityCell<Integer, Integer>> sortMap = new TreeMap<CompositeLong, ActivityCell<Integer, Integer>>();
        for (RI resourceId : this.getSelectedResourceIds()) {
            for (ActivityCell activityCell : this.getActivityCells(resourceId)) {
                multiTimeRange.remove(activityCell.getBeginTime(), activityCell.getEndTime());
            }
        }
        TimeRange[] timeRangeArray = multiTimeRange.getTimeRanges();
        int n = timeRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityCell<Integer, Integer> a;
            Object tr = timeRangeArray[n2];
            long durationMillis = ((TimeRange)tr).getDurationMillis();
            if (durationMillis >= preferredDuration) {
                a = new ActivityCell<Integer, Integer>(0, 0);
                a.setBeginTime(((TimeRange)tr).getFrom());
                a.setEndTime(new Date(((TimeRange)tr).getFrom().getTime() + preferredDuration));
                sortMap.put(new CompositeLong(0L, a.getBeginTime().getTime()), a);
            } else if (durationMillis >= 900000L) {
                a = new ActivityCell<Integer, Integer>(0, 0);
                a.setBeginTime(((TimeRange)tr).getFrom());
                a.setEndTime(new Date(((TimeRange)tr).getFrom().getTime() + durationMillis));
                sortMap.put(new CompositeLong(1L, -durationMillis), a);
            }
            ++n2;
        }
        if (!sortMap.isEmpty()) {
            ActivityCell a = (ActivityCell)((Object)sortMap.get(sortMap.firstKey()));
            this.setSelectedTime(a.getBeginTime(), a.getEndTime());
        }
    }

    @Override
    public IActivityMapUIFacade getUIFacade() {
        return this.m_activityMapUIFacade;
    }

    protected final void interceptDecorateMinorTimeColumn(TimeScale scale, MajorTimeColumn majorColumn, MinorTimeColumn minorColumn) throws ProcessingException {
        List<IActivityMapExtension<RI, AI, AbstractActivityMap<RI, AI>>> extensions = this.getAllExtensions();
        ActivityMapChains.ActivityMapDecorateMinorTimeColumnChain<RI, AI> chain = new ActivityMapChains.ActivityMapDecorateMinorTimeColumnChain<RI, AI>(extensions);
        chain.execDecorateMinorTimeColumn(scale, majorColumn, minorColumn);
    }

    protected final void interceptActivityCellSelected(ActivityCell<RI, AI> cell) throws ProcessingException {
        List<IActivityMapExtension<RI, AI, AbstractActivityMap<RI, AI>>> extensions = this.getAllExtensions();
        ActivityMapChains.ActivityMapActivityCellSelectedChain<RI, AI> chain = new ActivityMapChains.ActivityMapActivityCellSelectedChain<RI, AI>(extensions);
        chain.execActivityCellSelected(cell);
    }

    protected final void interceptDisposeActivityMap() throws ProcessingException {
        List<IActivityMapExtension<RI, AI, AbstractActivityMap<RI, AI>>> extensions = this.getAllExtensions();
        ActivityMapChains.ActivityMapDisposeActivityMapChain<RI, AI> chain = new ActivityMapChains.ActivityMapDisposeActivityMapChain<RI, AI>(extensions);
        chain.execDisposeActivityMap();
    }

    protected final TimeScale interceptCreateTimeScale() throws ProcessingException {
        List<IActivityMapExtension<RI, AI, AbstractActivityMap<RI, AI>>> extensions = this.getAllExtensions();
        ActivityMapChains.ActivityMapCreateTimeScaleChain<RI, AI> chain = new ActivityMapChains.ActivityMapCreateTimeScaleChain<RI, AI>(extensions);
        return chain.execCreateTimeScale();
    }

    protected final void interceptDecorateActivityCell(ActivityCell<RI, AI> cell) throws ProcessingException {
        List<IActivityMapExtension<RI, AI, AbstractActivityMap<RI, AI>>> extensions = this.getAllExtensions();
        ActivityMapChains.ActivityMapDecorateActivityCellChain<RI, AI> chain = new ActivityMapChains.ActivityMapDecorateActivityCellChain<RI, AI>(extensions);
        chain.execDecorateActivityCell(cell);
    }

    protected final void interceptInitActivityMap() throws ProcessingException {
        List<IActivityMapExtension<RI, AI, AbstractActivityMap<RI, AI>>> extensions = this.getAllExtensions();
        ActivityMapChains.ActivityMapInitActivityMapChain<RI, AI> chain = new ActivityMapChains.ActivityMapInitActivityMapChain<RI, AI>(extensions);
        chain.execInitActivityMap();
    }

    protected final void interceptCellAction(RI resourceId, MinorTimeColumn column, ActivityCell<RI, AI> activityCell) throws ProcessingException {
        List<IActivityMapExtension<RI, AI, AbstractActivityMap<RI, AI>>> extensions = this.getAllExtensions();
        ActivityMapChains.ActivityMapCellActionChain<RI, AI> chain = new ActivityMapChains.ActivityMapCellActionChain<RI, AI>(extensions);
        chain.execCellAction(resourceId, column, activityCell);
    }

    protected final void interceptDecorateMajorTimeColumn(TimeScale scale, MajorTimeColumn columns) throws ProcessingException {
        List<IActivityMapExtension<RI, AI, AbstractActivityMap<RI, AI>>> extensions = this.getAllExtensions();
        ActivityMapChains.ActivityMapDecorateMajorTimeColumnChain<RI, AI> chain = new ActivityMapChains.ActivityMapDecorateMajorTimeColumnChain<RI, AI>(extensions);
        chain.execDecorateMajorTimeColumn(scale, columns);
    }

    protected static class LocalActivityMapExtension<RI, AI, OWNER extends AbstractActivityMap<RI, AI>>
    extends AbstractExtension<OWNER>
    implements IActivityMapExtension<RI, AI, OWNER> {
        public LocalActivityMapExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execDecorateMinorTimeColumn(ActivityMapChains.ActivityMapDecorateMinorTimeColumnChain<RI, AI> chain, TimeScale scale, MajorTimeColumn majorColumn, MinorTimeColumn minorColumn) throws ProcessingException {
            ((AbstractActivityMap)this.getOwner()).execDecorateMinorTimeColumn(scale, majorColumn, minorColumn);
        }

        @Override
        public void execActivityCellSelected(ActivityMapChains.ActivityMapActivityCellSelectedChain<RI, AI> chain, ActivityCell<RI, AI> cell) throws ProcessingException {
            ((AbstractActivityMap)this.getOwner()).execActivityCellSelected(cell);
        }

        @Override
        public void execDisposeActivityMap(ActivityMapChains.ActivityMapDisposeActivityMapChain<RI, AI> chain) throws ProcessingException {
            ((AbstractActivityMap)this.getOwner()).execDisposeActivityMap();
        }

        @Override
        public TimeScale execCreateTimeScale(ActivityMapChains.ActivityMapCreateTimeScaleChain<RI, AI> chain) throws ProcessingException {
            return ((AbstractActivityMap)this.getOwner()).execCreateTimeScale();
        }

        @Override
        public void execDecorateActivityCell(ActivityMapChains.ActivityMapDecorateActivityCellChain<RI, AI> chain, ActivityCell<RI, AI> cell) throws ProcessingException {
            ((AbstractActivityMap)this.getOwner()).execDecorateActivityCell(cell);
        }

        @Override
        public void execInitActivityMap(ActivityMapChains.ActivityMapInitActivityMapChain<RI, AI> chain) throws ProcessingException {
            ((AbstractActivityMap)this.getOwner()).execInitActivityMap();
        }

        @Override
        public void execCellAction(ActivityMapChains.ActivityMapCellActionChain<RI, AI> chain, RI resourceId, MinorTimeColumn column, ActivityCell<RI, AI> activityCell) throws ProcessingException {
            ((AbstractActivityMap)this.getOwner()).execCellAction(resourceId, column, activityCell);
        }

        @Override
        public void execDecorateMajorTimeColumn(ActivityMapChains.ActivityMapDecorateMajorTimeColumnChain<RI, AI> chain, TimeScale scale, MajorTimeColumn columns) throws ProcessingException {
            ((AbstractActivityMap)this.getOwner()).execDecorateMajorTimeColumn(scale, columns);
        }
    }

    private class P_ActivityCellObserver
    implements IActivityCellObserver<RI, AI> {
        private P_ActivityCellObserver() {
        }

        @Override
        public void cellChanged(ActivityCell<RI, AI> cell, int bitPos) {
            ArrayList cellList = new ArrayList(1);
            cellList.add(cell);
            AbstractActivityMap.this.fireActivitiesUpdated(cellList);
        }
    }

    private class P_ActivityMapUIFacade
    implements IActivityMapUIFacade<RI, AI> {
        private P_ActivityMapUIFacade() {
        }

        public void setSelectedDayListFromUI(Date[] days) {
            AbstractActivityMap.this.setDays(days);
        }

        @Override
        public void setSelectionFromUI(List<? extends RI> resourceIds, double[] normalizedRange) {
            try {
                AbstractActivityMap.this.setActivityMapChanging(true);
                double cellCenter = 1.0 / (double)AbstractActivityMap.this.getTimeScale().getMinorTimeColumns().length / 2.0;
                AbstractActivityMap.this.setSelectedResourceIds(resourceIds);
                Date beginTime = normalizedRange != null ? AbstractActivityMap.this.getTimeScale().getMinorTimeColumn(normalizedRange[0] + cellCenter).getBeginTime() : null;
                Date endTime = normalizedRange != null ? AbstractActivityMap.this.getTimeScale().getMinorTimeColumn(normalizedRange[1] - cellCenter).getEndTime() : null;
                AbstractActivityMap.this.setSelectedTime(beginTime, endTime);
            }
            finally {
                AbstractActivityMap.this.setActivityMapChanging(false);
            }
        }

        @Override
        public void setDaysFromUI(Date[] days) {
            AbstractActivityMap.this.setDays(days);
        }

        @Override
        public void setSelectedActivityCellFromUI(ActivityCell<RI, AI> cell) {
            AbstractActivityMap.this.setSelectedActivityCell(cell);
        }

        @Override
        public void fireCellActionFromUI(RI resourceId, double[] normalizedRange, ActivityCell<RI, AI> activityCell) {
            if (activityCell != null) {
                AbstractActivityMap.this.setSelectedActivityCell(activityCell);
            }
            MinorTimeColumn column = AbstractActivityMap.this.getTimeScale().getMinorTimeColumn((normalizedRange[0] + normalizedRange[1]) / 2.0);
            AbstractActivityMap.this.fireCellAction(resourceId, column, activityCell);
        }
    }
}

