/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public abstract class AbstractTreeNodeBuilder<LOOKUP_ROW_TYPE> {
    protected abstract ITreeNode createEmptyTreeNode() throws ProcessingException;

    public ITreeNode createTreeNode(LOOKUP_ROW_TYPE primaryKey, String text, int nodeStatus, boolean markChildrenLoaded) throws ProcessingException {
        return this.createTreeNode((ILookupRow<LOOKUP_ROW_TYPE>)new LookupRow(primaryKey, text), nodeStatus, markChildrenLoaded);
    }

    public List<ITreeNode> createTreeNodes(List<? extends ILookupRow<LOOKUP_ROW_TYPE>> lookupRows, int nodeStatus, boolean markChildrenLoaded) throws ProcessingException {
        ArrayList<ITreeNode> rootNodes = new ArrayList<ITreeNode>();
        HashMap<Object, ITreeNode> nodeMap = new HashMap<Object, ITreeNode>();
        HashMap<Object, ArrayList<ITreeNode>> parentChildMap = new HashMap<Object, ArrayList<ITreeNode>>();
        if (lookupRows != null) {
            for (ILookupRow iLookupRow : lookupRows) {
                ITreeNode node = this.createTreeNode(iLookupRow, nodeStatus, markChildrenLoaded);
                nodeMap.put(node.getPrimaryKey(), node);
                if (iLookupRow.getParentKey() != null) {
                    ArrayList<ITreeNode> list = (ArrayList<ITreeNode>)parentChildMap.get(iLookupRow.getParentKey());
                    if (list == null) {
                        list = new ArrayList<ITreeNode>();
                        parentChildMap.put(iLookupRow.getParentKey(), list);
                    }
                    list.add(node);
                    continue;
                }
                rootNodes.add(node);
            }
        }
        for (Map.Entry entry : parentChildMap.entrySet()) {
            Object parentKey = entry.getKey();
            ITreeNode parentNode = (ITreeNode)nodeMap.get(parentKey);
            if (parentNode instanceof AbstractTreeNode) {
                ((AbstractTreeNode)parentNode).addChildNodesInternal(parentNode.getChildNodeCount(), (List)entry.getValue(), true);
                continue;
            }
            rootNodes.addAll((Collection)entry.getValue());
        }
        return rootNodes;
    }

    public ITreeNode createTreeNode(ILookupRow<LOOKUP_ROW_TYPE> lookupRow, int nodeStatus, boolean markChildrenLoaded) throws ProcessingException {
        ITreeNode treeNode = this.createEmptyTreeNode();
        treeNode.setPrimaryKey(lookupRow.getKey());
        treeNode.setEnabledInternal(lookupRow.isEnabled());
        treeNode.setStatusInternal(nodeStatus);
        if (markChildrenLoaded) {
            treeNode.setChildrenLoaded(markChildrenLoaded);
        }
        Cell cell = treeNode.getCellForUpdate();
        cell.setValue(lookupRow);
        cell.setText(lookupRow.getText());
        cell.setTooltipText(lookupRow.getTooltipText());
        if (cell.getIconId() == null) {
            cell.setIconId(lookupRow.getIconId());
        }
        cell.setBackgroundColor(lookupRow.getBackgroundColor());
        cell.setForegroundColor(lookupRow.getForegroundColor());
        cell.setFont(lookupRow.getFont());
        if (!lookupRow.isActive()) {
            if (cell.getFont() == null) {
                cell.setFont(FontSpec.parse((String)"italic"));
            }
            cell.setText(String.valueOf(lookupRow.getText()) + " (" + ScoutTexts.get((String)"InactiveState", (String[])new String[0]) + ")");
        }
        return treeNode;
    }
}

