/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.extension.client.ui.action.menu.internal;

import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.extension.client.ui.action.menu.IMenuExtensionFilter;

public abstract class AbstractMenuExtension {
    private final IMenuExtensionFilter m_filter;
    private final Class<? extends IMenu> m_menuClass;

    public AbstractMenuExtension(Class<? extends IMenu> menuClass, IMenuExtensionFilter filter) {
        if (menuClass == null) {
            throw new IllegalArgumentException("menuClass must not be null");
        }
        this.m_menuClass = menuClass;
        this.m_filter = filter;
    }

    public Class<? extends IMenu> getMenuClass() {
        return this.m_menuClass;
    }

    public IMenuExtensionFilter getFilter() {
        return this.m_filter;
    }

    public boolean accept(Object anchor, Object container, IMenu menu) {
        if (anchor == null || container == null) {
            return false;
        }
        if (this.getFilter() != null) {
            return this.getFilter().accept(anchor, container, menu);
        }
        return true;
    }
}

