/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.jms.transactional;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.jms.AbstractJmsService;
import org.eclipse.scout.rt.server.jms.transactional.JmsTransactionMember;
import org.eclipse.scout.rt.server.transaction.ITransaction;

public abstract class AbstractTransactionalJmsService<T>
extends AbstractJmsService<T> {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(AbstractTransactionalJmsService.class);
    private final String m_transactionId;

    public AbstractTransactionalJmsService(String transactionId) {
        this.m_transactionId = transactionId;
    }

    public final String getTransactionId() {
        return this.m_transactionId;
    }

    @Override
    protected synchronized void setupConnection() throws ProcessingException {
        super.setupConnection();
        try {
            this.getConnection().start();
        }
        catch (JMSException e) {
            throw new ProcessingException("Failed starting JMS connection", (Throwable)e);
        }
    }

    protected Session createSession(Connection connection) throws ProcessingException {
        try {
            return connection.createSession(true, 2);
        }
        catch (JMSException e) {
            throw new ProcessingException("Error creating session", (Throwable)e);
        }
    }

    protected JmsTransactionMember<T> getTransaction() throws ProcessingException {
        ITransaction t = ThreadContext.getTransaction();
        if (t == null) {
            throw new IllegalStateException("not inside a scout transaction (ServerJob.schedule)");
        }
        JmsTransactionMember m = (JmsTransactionMember)t.getMember(this.getTransactionId());
        if (m == null) {
            Connection connection = this.getConnection();
            m = new JmsTransactionMember(this.getTransactionId(), connection, this.createSession(connection), this.lookupDestination(), this.createMessageSerializer());
            t.registerMember(m);
        }
        return m;
    }

    protected void send(T message) throws ProcessingException {
        JmsTransactionMember<T> transactionMember = this.getTransaction();
        transactionMember.send(message);
    }

    protected T receive(long timeoutMillis) throws ProcessingException {
        JmsTransactionMember<T> transactionMember = this.getTransaction();
        return transactionMember.receive(timeoutMillis);
    }

    protected T receive() throws ProcessingException {
        JmsTransactionMember<T> transactionMember = this.getTransaction();
        return transactionMember.receive(-1L);
    }

    protected T receiveNoWait() throws ProcessingException {
        JmsTransactionMember<T> transactionMember = this.getTransaction();
        return transactionMember.receive(0L);
    }
}

