/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import java.security.Principal;
import java.util.UUID;
import javax.security.auth.Subject;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.security.SimplePrincipal;
import org.eclipse.scout.commons.serialization.SerializationUtility;
import org.eclipse.scout.rt.server.IServerJobFactory;
import org.eclipse.scout.rt.server.IServerJobService;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServerJobFactory;
import org.eclipse.scout.rt.server.internal.ServerSessionClassFinder;
import org.eclipse.scout.rt.server.services.common.session.IServerSessionRegistryService;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.SERVICES;

public class ServerJobService
extends AbstractService
implements IServerJobService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ServerJobService.class);
    private static final String SERVER_PRINCIPAL = "anonymous";
    private final Subject m_serverSubject = this.createSubject("anonymous");
    private String m_serverSessionClassName;

    @Override
    public Subject getServerSubject() {
        return this.m_serverSubject;
    }

    @Override
    public Subject createSubject(String principal) {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new SimplePrincipal(principal));
        subject.setReadOnly();
        return subject;
    }

    public String getServerSessionClassName() {
        return this.m_serverSessionClassName;
    }

    public void setServerSessionClassName(String className) {
        this.m_serverSessionClassName = className;
    }

    @Override
    public Class<? extends IServerSession> getServerSessionClass() throws ProcessingException {
        String sessionName = this.getServerSessionClassName();
        if (!StringUtility.isNullOrEmpty((CharSequence)sessionName)) {
            return ServerJobService.loadSessionClass(sessionName);
        }
        LOG.error("No server session class defined: Set org.eclipse.scout.rt.server.ServerJobService#serverSessionClassName in your config.ini.");
        String classNameByConvention = new ServerSessionClassFinder().findClassNameByConvention();
        if (classNameByConvention != null) {
            return ServerJobService.loadSessionClass(classNameByConvention);
        }
        throw new ProcessingException("No found");
    }

    private static Class<? extends IServerSession> loadSessionClass(String sessionName) throws ProcessingException {
        try {
            Class<?> clazz = SerializationUtility.getClassLoader().loadClass(sessionName);
            if (IServerSession.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            throw new ProcessingException("Server session class '" + sessionName + "' could not be loaded as not of the type '" + IServerSession.class.getName() + "'");
        }
        catch (ClassNotFoundException e) {
            throw new ProcessingException("Server session class '" + sessionName + "' could not be found", (Throwable)e);
        }
    }

    @Override
    public IServerJobFactory createJobFactory() throws ProcessingException {
        return this.createJobFactory(this.createServerSession(), this.getServerSubject());
    }

    @Override
    public IServerJobFactory createJobFactory(IServerSession session, Subject subject) {
        return new ServerJobFactory(session, subject);
    }

    @Override
    public IServerSession createServerSession() throws ProcessingException {
        return this.createServerSession(this.getServerSessionClass(), this.getServerSubject());
    }

    @Override
    public IServerSession createServerSession(Class<? extends IServerSession> sessionClazz, Subject subject) throws ProcessingException {
        IServerSession session = ((IServerSessionRegistryService)SERVICES.getService(IServerSessionRegistryService.class)).newServerSession(sessionClazz, subject);
        String id = String.valueOf(sessionClazz.getName()) + UUID.randomUUID().toString();
        session.setIdInternal(id);
        return session;
    }
}

