/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.servicetunnel.http.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.servicetunnel.AbstractServiceTunnel;
import org.eclipse.scout.rt.servicetunnel.http.internal.HttpBackgroundExecutable;
import org.eclipse.scout.rt.servicetunnel.http.internal.HttpBackgroundExecutor;
import org.eclipse.scout.rt.servicetunnel.http.internal.IHttpBackgroundExecutor;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.processing.IServerProcessingCancelService;
import org.eclipse.scout.rt.shared.servicetunnel.DefaultServiceTunnelContentHandler;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnelContentHandler;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnelRequest;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnelResponse;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelResponse;

public abstract class AbstractInternalHttpServiceTunnel<T extends ISession>
extends AbstractServiceTunnel<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractInternalHttpServiceTunnel.class);
    private IServiceTunnelContentHandler m_contentHandler;

    public AbstractInternalHttpServiceTunnel(T session, URL url) {
        this(session, url, null);
    }

    public AbstractInternalHttpServiceTunnel(T session, URL url, String version) {
        super(session, version);
        this.setServerURL(url);
    }

    protected URLConnection createURLConnection(IServiceTunnelRequest call, byte[] callData) throws IOException {
        if (this.getServerURL().getProtocol().startsWith("file")) {
            throw new IOException("File connection is not supporting HTTP: " + this.getServerURL());
        }
        URLConnection urlConn = this.getServerURL().openConnection();
        String contentType = "text/xml";
        urlConn.setRequestProperty("Content-type", contentType);
        urlConn.setDoOutput(true);
        urlConn.setDoInput(true);
        urlConn.setDefaultUseCaches(false);
        urlConn.setUseCaches(false);
        this.addCustomHeaders(urlConn, "POST");
        OutputStream httpOut = urlConn.getOutputStream();
        httpOut.write(callData);
        httpOut.close();
        httpOut = null;
        return urlConn;
    }

    protected void addCustomHeaders(URLConnection urlConn, String method) throws IOException {
    }

    public IServiceTunnelContentHandler getContentHandler() {
        return this.m_contentHandler;
    }

    public void setContentHandler(IServiceTunnelContentHandler e) {
        this.m_contentHandler = e;
    }

    @Override
    public Object invokeService(Class serviceInterfaceClass, Method operation, Object[] callerArgs) throws ProcessingException {
        if (this.m_contentHandler == null) {
            this.m_contentHandler = new DefaultServiceTunnelContentHandler();
            this.m_contentHandler.initialize();
        }
        return super.invokeService(serviceInterfaceClass, operation, callerArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IServiceTunnelResponse tunnel(IServiceTunnelRequest req) {
        Object backgroundLock = new Object();
        IHttpBackgroundExecutor executor = this.createHttpBackgroundExecutor("ServerCallProcessing", req, backgroundLock);
        JobEx httpJob = executor.getJob();
        this.decorateBackgroundJob(req, (Job)httpJob);
        IServiceTunnelResponse res = null;
        boolean cancelled = false;
        boolean sentCancelRequest = false;
        Object object = backgroundLock;
        synchronized (object) {
            httpJob.schedule();
            while ((res = executor.getResponse()) == null) {
                IProgressMonitor mon = httpJob.getMonitor();
                if (!sentCancelRequest && (JobEx.isCurrentJobCanceled() || mon != null && mon.isCanceled())) {
                    sentCancelRequest = true;
                    boolean success = this.sendCancelRequest(req.getRequestSequence());
                    if (success) {
                        cancelled = true;
                        break;
                    }
                }
                if (httpJob.getState() == 0) break;
                try {
                    backgroundLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
        }
        if (res == null || cancelled) {
            return new ServiceTunnelResponse(null, null, (Throwable)new InterruptedException(ScoutTexts.get((String)"UserInterrupted", (String[])new String[0])));
        }
        return res;
    }

    protected void decorateBackgroundJob(IServiceTunnelRequest call, Job backgroundJob) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean sendCancelRequest(long requestSequence) {
        try {
            IServiceTunnelRequest cancelCall = this.createServiceTunnelRequest(this.getVersion(), IServerProcessingCancelService.class, IServerProcessingCancelService.class.getMethod("cancel", Long.TYPE), new Object[]{requestSequence});
            IHttpBackgroundExecutor executor = this.createHttpBackgroundExecutor("ServerCallCancelProcessing", cancelCall, new Object());
            JobEx cancelHttpJob = executor.getJob();
            cancelHttpJob.setSystem(true);
            cancelHttpJob.schedule();
            try {
                cancelHttpJob.join(10000L);
                IServiceTunnelResponse cancelResult = executor.getResponse();
                if (cancelResult == null) {
                    return false;
                }
                if (cancelResult.getException() != null) {
                    LOG.warn("cancel failed", cancelResult.getException());
                    return false;
                }
                Boolean result = (Boolean)cancelResult.getData();
                return result != null && result != false;
            }
            catch (InterruptedException ie) {
                return false;
            }
        }
        catch (Throwable e) {
            LOG.warn("failed to cancel server processing", e);
            return false;
        }
    }

    private IHttpBackgroundExecutor createHttpBackgroundExecutor(String name, IServiceTunnelRequest request, Object lock) {
        HttpBackgroundExecutable executable = new HttpBackgroundExecutable(request, lock, this);
        JobEx job = this.createHttpBackgroundJob(ScoutTexts.get((String)name, (String[])new String[0]), executable);
        return new HttpBackgroundExecutor(job, executable);
    }

    protected abstract JobEx createHttpBackgroundJob(String var1, HttpBackgroundExecutable var2);

    protected void preprocessHttpRepsonse(URLConnection urlConn, IServiceTunnelRequest call, int httpCode) {
    }
}

