/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeService;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.service.SERVICES;

public final class CODES {
    private CODES() {
    }

    public static <T extends ICodeType<?, ?>> T getCodeType(Class<T> type) {
        return ((ICodeService)SERVICES.getService(ICodeService.class)).getCodeType(type);
    }

    public static <T> ICodeType<T, ?> findCodeTypeById(T id) {
        return ((ICodeService)SERVICES.getService(ICodeService.class)).findCodeTypeById(id);
    }

    public static <T> ICodeType<T, ?> findCodeTypeById(Long partitionId, T codeTypeId) {
        return ((ICodeService)SERVICES.getService(ICodeService.class)).findCodeTypeById(partitionId, codeTypeId);
    }

    public static List<ICodeType<?, ?>> getCodeTypes(Class<?> ... types) {
        if (types == null) {
            return CollectionUtility.emptyArrayList();
        }
        ArrayList typeList = new ArrayList(types.length);
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> t = classArray[n2];
            if (ICodeType.class.isAssignableFrom(t)) {
                typeList.add(t);
            }
            ++n2;
        }
        return ((ICodeService)SERVICES.getService(ICodeService.class)).getCodeTypes(typeList);
    }

    public static List<ICodeType<?, ?>> getCodeTypes(List<Class<? extends ICodeType<?, ?>>> types) {
        return ((ICodeService)SERVICES.getService(ICodeService.class)).getCodeTypes(types);
    }

    public static <CODE_ID_TYPE, CODE extends ICode<CODE_ID_TYPE>> CODE getCode(Class<CODE> type) {
        return ((ICodeService)SERVICES.getService(ICodeService.class)).getCode(type);
    }

    public static <T extends ICodeType> T reloadCodeType(Class<T> type) throws ProcessingException {
        return ((ICodeService)SERVICES.getService(ICodeService.class)).reloadCodeType(type);
    }

    public static List<ICodeType<?, ?>> reloadCodeTypes(Class<?> ... types) throws ProcessingException {
        if (types == null) {
            return CollectionUtility.emptyArrayList();
        }
        ArrayList typeList = new ArrayList(types.length);
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> t = classArray[n2];
            if (ICodeType.class.isAssignableFrom(t)) {
                typeList.add(t);
            }
            ++n2;
        }
        return ((ICodeService)SERVICES.getService(ICodeService.class)).reloadCodeTypes(typeList);
    }

    public static List<ICodeType<?, ?>> reloadCodeTypes(List<Class<? extends ICodeType<?, ?>>> types) throws ProcessingException {
        return ((ICodeService)SERVICES.getService(ICodeService.class)).reloadCodeTypes(types);
    }

    public static List<ICodeType<?, ?>> getAllCodeTypes(String classPrefix) {
        return ((ICodeService)SERVICES.getService(ICodeService.class)).getAllCodeTypes(classPrefix);
    }
}

