/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.file;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;

public class CompressedOutputStream
extends OutputStream {
    private RemoteFile m_remoteFile;
    private ByteArrayOutputStream m_buffer;
    private Deflater m_deflater;
    private DeflaterOutputStream m_deflaterOutputStream;
    private CRC32 m_crc32;

    public CompressedOutputStream(RemoteFile f) {
        this.m_remoteFile = f;
        this.m_buffer = new ByteArrayOutputStream();
        this.m_deflater = new Deflater(9);
        this.m_deflaterOutputStream = new DeflaterOutputStream((OutputStream)this.m_buffer, this.m_deflater);
        this.m_crc32 = new CRC32();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.m_deflater.finish();
        this.m_deflaterOutputStream.finish();
        this.m_deflater.end();
        this.m_deflaterOutputStream.close();
        this.m_buffer.close();
        this.m_remoteFile.setCompressedData(this.m_buffer.toByteArray(), this.m_crc32.getValue());
    }

    @Override
    public void flush() throws IOException {
        this.m_deflaterOutputStream.flush();
        this.m_buffer.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.m_crc32.update(b);
        this.m_deflaterOutputStream.write(b);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        this.m_crc32.update(buf, off, len);
        this.m_deflaterOutputStream.write(buf, off, len);
        this.flush();
    }
}

