/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.scout.commons.annotations.Doc;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.spec.client.filter.IDocFilter;

public final class FilterUtility {
    private FilterUtility() {
    }

    public static <T> boolean isAccepted(T scoutObject, List<IDocFilter<T>> filters) {
        if (filters == null) {
            return true;
        }
        if (!FilterUtility.isAccepted(scoutObject, filters, Doc.Filtering.REJECT, Doc.Filtering.TRANSPARENT)) {
            return false;
        }
        if (scoutObject instanceof IFormField) {
            ICompositeField superField = ((IFormField)scoutObject).getParentField();
            while (superField != null) {
                ArrayList<IDocFilter<T>> fieldFilters = new ArrayList<IDocFilter<T>>();
                for (IDocFilter<T> f : filters) {
                    fieldFilters.add(f);
                }
                if (!FilterUtility.isAccepted(superField, fieldFilters, Doc.Filtering.REJECT, Doc.Filtering.ACCEPT_REJECT_CHILDREN)) {
                    return false;
                }
                superField = superField.getParentField();
            }
        }
        return true;
    }

    private static <T> boolean isAccepted(T scoutObject, List<IDocFilter<T>> filters, Doc.Filtering ... notAccepted) {
        for (IDocFilter<T> filter : filters) {
            Doc.Filtering filterResult = filter.accept(scoutObject);
            if (!Arrays.asList(notAccepted).contains(filterResult)) continue;
            return false;
        }
        return true;
    }
}

