/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.out.docbook;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.DocBookDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.mediawiki.core.MediaWikiLanguage;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public class DocBookConverter {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DocBookConverter.class);
    private static final String ENCODING = "utf-8";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void convertWikiToDocBook(File in, File out) {
        BufferedWriter writer = null;
        try {
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out.getPath()), ENCODING));
                DocBookDocumentBuilder builder = new DocBookDocumentBuilder((Writer)writer);
                MarkupParser parser = new MarkupParser((MarkupLanguage)new MediaWikiLanguage());
                parser.setBuilder((DocumentBuilder)builder);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(in.getPath()), ENCODING));
                parser.parse((Reader)reader);
                writer.flush();
                writer.close();
                return;
            }
            catch (FileNotFoundException e) {
                LOG.error("Error converting to docbook", (Throwable)e);
                if (writer == null) return;
                try {
                    writer.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (IOException e) {
                LOG.error("Error converting to docbook", (Throwable)e);
                if (writer == null) return;
                try {
                    writer.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

