/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Color;
import java.util.HashMap;
import java.util.zip.Adler32;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class HtmlViewCache {
    private HashMap<Object, View> m_viewMap = new HashMap();

    public void updateHtmlView(JLabel label, boolean customForeground) {
        String text = label.getText();
        View value = null;
        if (BasicHTML.isHTMLString(text)) {
            if (!customForeground) {
                label.setForeground(label.isEnabled() ? UIManager.getDefaults().getColor("TextField.foreground") : UIManager.getDefaults().getColor("TextField.inactiveForeground"));
            }
            Adler32 crc = new Adler32();
            crc.update(text.getBytes());
            Color fg = label.getForeground();
            String key = crc.getValue() + "." + label.getFont() + "." + (fg != null ? fg.getRGB() : 0);
            value = this.m_viewMap.get(key);
            if (value == null && (value = BasicHTML.createHTMLView(label, text)) != null) {
                this.m_viewMap.put(key, value);
            }
        }
        label.putClientProperty("html", value);
    }
}

