/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.activitymap;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.eclipse.scout.rt.ui.swing.ext.LookAndFeelUtility;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.ActivityComponent;

public class DefaultActivityComponent
extends JComponent
implements ActivityComponent,
FocusListener {
    private static final long serialVersionUID = 1L;
    private static Color defaultColor = new Color(0x88AAFF);
    private int m_rowIndex;
    private String m_text;

    public DefaultActivityComponent(int rowIndex) {
        this.m_rowIndex = rowIndex;
        this.setToolTipText(this.m_text);
        this.setBackground(defaultColor);
        this.setRequestFocusEnabled(true);
        this.setFocusable(true);
        this.addFocusListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DefaultActivityComponent.this.requestFocus();
            }
        });
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String s) {
        this.m_text = s;
        this.repaint();
    }

    @Override
    public int getRowIndex() {
        return this.m_rowIndex;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Shape oldShape = g.getClip();
        try {
            g.setColor(this.getBackground());
            g.fill3DRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, true);
            if (this.isFocusOwner()) {
                g.setColor(UIManager.getColor("Table.focusCellForeground"));
                LookAndFeelUtility.drawFocus(g, 1, 1, this.getWidth() - 2, this.getHeight() - 2);
            }
            g.setColor(this.getBackground());
            g.setFont(this.getFont());
            String s = this.m_text;
            if (s != null) {
                FontMetrics fm = g.getFontMetrics();
                g.setColor(this.getForeground());
                int sWidth = fm.stringWidth(s);
                int dx = Math.max(0, this.getWidth() - 4 - sWidth);
                g.clipRect(2, 2, this.getWidth() - 4, this.getHeight() - 4);
                g.drawString(s, 2 + dx / 2, this.getHeight() - 2 - fm.getDescent());
            }
        }
        finally {
            g.setClip(oldShape);
        }
    }
}

