/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.internal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayoutInfo;
import org.eclipse.scout.rt.ui.swing.ext.internal.GridLayoutCanvas;

public class LogicalGridLayoutSpyAction
extends AbstractAction {
    public static final String GROUP_BOX_MARKER = "groupBoxMarker";
    private static final long serialVersionUID = 1L;
    private GridLayoutCanvas m_canvas;
    private KeyEventDispatcher m_keyEventDispatcher;
    private JWindow m_frame;
    private static final List<Color> colors = CollectionUtility.arrayList((Object[])new Color[]{new Color(0, 0, 100), new Color(0, 100, 0), new Color(204, 0, 0), Color.magenta});

    @Override
    public void actionPerformed(ActionEvent e) {
        Component rootComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        while (rootComponent.getParent() != null && !(rootComponent instanceof Window)) {
            rootComponent = rootComponent.getParent();
        }
        Window parentWindow = null;
        if (rootComponent instanceof Window) {
            parentWindow = (Window)rootComponent;
        }
        this.m_frame = new JWindow(parentWindow);
        this.m_frame.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e1) {
                LogicalGridLayoutSpyAction.this.dispose();
            }
        });
        this.m_keyEventDispatcher = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e1) {
                switch (e1.getKeyCode()) {
                    case 27: 
                    case 127: {
                        LogicalGridLayoutSpyAction.this.dispose();
                    }
                }
                return false;
            }
        };
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kfm.addKeyEventDispatcher(this.m_keyEventDispatcher);
        this.m_frame.setBackground(new Color(0, 0, 0, 0));
        this.m_canvas = new GridLayoutCanvas();
        this.m_frame.setContentPane(this.m_canvas);
        ArrayList<JComponent> groupBoxComponents = new ArrayList<JComponent>();
        this.collectGroupBoxes(rootComponent, groupBoxComponents);
        int colorIndex = 0;
        for (JComponent g : groupBoxComponents) {
            this.renderGroupBoxLayout(g, rootComponent, (LogicalGridLayout)g.getLayout(), colors.get(colorIndex));
            colorIndex = (colorIndex + 1) % colors.size();
        }
        this.m_frame.setSize(rootComponent.getSize());
        this.m_frame.setLocationRelativeTo(rootComponent);
        this.m_frame.setVisible(true);
    }

    private void dispose() {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kfm.addKeyEventDispatcher(this.m_keyEventDispatcher);
        this.m_keyEventDispatcher = null;
        this.m_frame.dispose();
    }

    protected void collectGroupBoxes(Component comp, List<JComponent> groupBoxComponents) {
        JComponent jComp;
        if (comp instanceof JComponent && (jComp = (JComponent)comp).getClientProperty(GROUP_BOX_MARKER) != null && jComp.getLayout() instanceof LogicalGridLayout) {
            groupBoxComponents.add(jComp);
        }
        if (comp instanceof Container) {
            Component[] componentArray = ((Container)comp).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component childComp = componentArray[n2];
                this.collectGroupBoxes(childComp, groupBoxComponents);
                ++n2;
            }
        }
    }

    protected void renderGroupBoxLayout(JComponent group, Component rootComponent, LogicalGridLayout layout, Color color) {
        Rectangle bounds = group.getBounds();
        bounds.x = 0;
        bounds.y = 0;
        bounds = SwingUtilities.convertRectangle(group, bounds, rootComponent);
        this.m_canvas.addBounds(new GridLayoutCanvas.Bounds(new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height), color));
        LogicalGridLayoutInfo info = layout.getInfo();
        if (info == null) {
            return;
        }
        Rectangle[][] cellBounds = info.getCellBounds();
        if (cellBounds == null) {
            return;
        }
        if (cellBounds.length > 0 && cellBounds[0].length > 0) {
            Rectangle b;
            int[] xOffsets = new int[cellBounds[0].length - 1];
            int[] yOffsets = new int[cellBounds.length - 1];
            Rectangle prev = null;
            int x = 0;
            while (x < cellBounds[0].length) {
                b = cellBounds[0][x];
                if (prev != null) {
                    xOffsets[x - 1] = b.x - (b.x - (prev.x + prev.width)) / 2;
                }
                prev = b;
                ++x;
            }
            prev = null;
            int y = 0;
            while (y < cellBounds.length) {
                b = cellBounds[y][0];
                if (prev != null) {
                    yOffsets[y - 1] = b.y - (b.y - (prev.y + prev.height)) / 2;
                }
                prev = b;
                ++y;
            }
            x = 0;
            while (x < xOffsets.length) {
                this.m_canvas.addLine(new GridLayoutCanvas.Line(SwingUtilities.convertPoint(group, xOffsets[x], 0, rootComponent), SwingUtilities.convertPoint(group, xOffsets[x], bounds.height, rootComponent), color));
                ++x;
            }
            y = 0;
            while (y < yOffsets.length) {
                this.m_canvas.addLine(new GridLayoutCanvas.Line(SwingUtilities.convertPoint(group, 0, yOffsets[y], rootComponent), SwingUtilities.convertPoint(group, bounds.width, yOffsets[y], rootComponent), color));
                ++y;
            }
        }
    }
}

