/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.inject;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.BundleContextUtility;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.Activator;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.osgi.framework.Bundle;

public class UIDefaultsInjector {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(UIDefaultsInjector.class);
    protected String[] m_splashExtensions = new String[]{"png", "jpg", "bmp"};

    public void inject(UIDefaults defaults) {
        this.putIfUndefined(defaults, "control", new ColorUIResource(0xFFFFFF));
        this.putIfUndefined(defaults, "desktop", new ColorUIResource(0xFFFFFF));
        this.putIfUndefined(defaults, "textInactiveText", new ColorUIResource(0x666666));
        this.putIfUndefined(defaults, "DateChooser.applyButtonText", SwingUtility.getNlsText("Apply", new String[0]));
        this.putIfUndefined(defaults, "GroupBoxButtonBar.border", new BorderUIResource(new EmptyBorder(12, 0, 6, 0)));
        this.putIfUndefined(defaults, "GroupBox.border", new BorderUIResource(new EmptyBorder(6, 3, 3, 3)));
        this.putIfUndefined(defaults, "Label.defaultHorizontalAlignment", "LEFT");
        this.putIfUndefined(defaults, "Label.font", new FontUIResource("Dialog", 0, 12));
        this.putIfUndefined(defaults, "Hyperlink.foreground", new ColorUIResource(0x445599));
        this.putIfUndefined(defaults, "List.selectionBackground", new ColorUIResource(7125988));
        this.putIfUndefined(defaults, "ListBox.rowHeight", 20);
        this.putIfUndefined(defaults, "MenuBar.policy", "menubar");
        this.putIfUndefined(defaults, "PopupMenu.innerBorder", null);
        this.putIfUndefined(defaults, "Splash.icon", this.getSplashUIResource());
        this.putIfUndefined(defaults, "Splash.text", new ColorUIResource(34470));
        this.putIfUndefined(defaults, "StatusBar.StopButton.icon", this.createIconUIResource("status_interrupt"));
        this.putIfUndefined(defaults, "StatusBar.height", 29);
        this.putIfUndefined(defaults, "StatusBar.icon", null);
        this.putIfUndefined(defaults, "StatusBar.visible", true);
        this.putIfUndefined(defaults, "SwingScoutPopup.border", new BorderUIResource(new LineBorder(Color.gray, 1, true)));
        this.putIfUndefined(defaults, "SystemButton.cancelIcon", null);
        this.putIfUndefined(defaults, "SystemButton.noIcon", null);
        this.putIfUndefined(defaults, "SystemButton.yesIcon", null);
        this.putIfUndefined(defaults, "TabbedPane.tabAreaInsets", new InsetsUIResource(2, 2, 2, 6));
        this.putIfUndefined(defaults, "TabItem.foreground", new ColorUIResource(0, 0, 0));
        this.putIfUndefined(defaults, "TabItem.disabledText", new ColorUIResource(142, 143, 145));
        this.putIfUndefined(defaults, "TabItem.selected.foreground", new ColorUIResource(0, 0, 0));
        this.putIfUndefined(defaults, "Table.focusCellForeground", new ColorUIResource(0));
        this.putIfUndefined(defaults, "Table.rowHeight", 24);
        this.putIfUndefined(defaults, "TableHeader.rowHeight", 26);
        this.putIfUndefined(defaults, "TextField.border", new BorderUIResource(new EmptyBorder(0, 0, 0, 0)));
        this.putIfUndefined(defaults, "TitledBorder.border", new BorderUIResource(new EmptyBorder(0, 0, 0, 0)));
        this.putIfUndefined(defaults, "TitledBorder.font", new FontUIResource("Dialog", 0, 12));
        this.putIfUndefined(defaults, "TitledBorder.titleColor", new ColorUIResource(0));
        this.putIfUndefined(defaults, "Tree.closedIcon", this.createIconUIResource("tree_node"));
        this.putIfUndefined(defaults, "Tree.openIcon", this.createIconUIResource("tree_node_open"));
        this.putIfUndefined(defaults, "Tree.rowHeight", 24);
        this.putIfUndefined(defaults, "TreeBox.rowHeight", 20);
        Icon icon = Activator.getIcon("window");
        if (icon != null) {
            this.putIfUndefined(defaults, "Window.icon", icon);
        } else {
            ArrayList<Image> icons = new ArrayList<Image>();
            icons.add(Activator.getImage("window16"));
            icons.add(Activator.getImage("window32"));
            icons.add(Activator.getImage("window48"));
            icons.add(Activator.getImage("window256"));
            this.putIfUndefined(defaults, "Window.icons", icons);
        }
        defaults.put("OptionPane.okButtonText", SwingUtility.getNlsText("Ok", new String[0]));
        defaults.put("OptionPane.cancelButtonText", SwingUtility.getNlsText("Cancel", new String[0]));
        defaults.put("OptionPane.yesButtonText", SwingUtility.getNlsText("Yes", new String[0]));
        defaults.put("OptionPane.noButtonText", SwingUtility.getNlsText("No", new String[0]));
        defaults.put("FileChooser.lookInLabelText", SwingUtility.getNlsText("LookIn", new String[0]));
        defaults.put("FileChooser.filesOfTypeLabelText", SwingUtility.getNlsText("FilesOfType", new String[0]));
        defaults.put("FileChooser.fileNameLabelText", SwingUtility.getNlsText("FileName", new String[0]));
        defaults.put("FileChooser.saveButtonText", SwingUtility.getNlsText("Save", new String[0]));
        defaults.put("FileChooser.saveDialogTitleText", SwingUtility.getNlsText("Save", new String[0]));
        defaults.put("FileChooser.openButtonText", SwingUtility.getNlsText("Open", new String[0]));
        defaults.put("FileChooser.openDialogTitleText", SwingUtility.getNlsText("Open", new String[0]));
        defaults.put("FileChooser.cancelButtonText", SwingUtility.getNlsText("Cancel", new String[0]));
        defaults.put("FileChooser.updateButtonText", SwingUtility.getNlsText("Update", new String[0]));
        defaults.put("FileChooser.helpButtonText", SwingUtility.getNlsText("Help", new String[0]));
        this.putIfUndefined(defaults, "LoginDialog.username", SwingUtility.getNlsText("Username", new String[0]));
        this.putIfUndefined(defaults, "LoginDialog.password", SwingUtility.getNlsText("Password", new String[0]));
        this.putIfUndefined(defaults, "LoginDialog.title", SwingUtility.getNlsText("Login", new String[0]));
        this.putIfUndefined(defaults, "LoginDialog.savePassword", SwingUtility.getNlsText("SavePassword", new String[0]));
        this.putIfUndefined(defaults, "LoginDialog.ok", SwingUtility.getNlsText("Ok", new String[0]));
        this.putIfUndefined(defaults, "LoginDialog.cancel", SwingUtility.getNlsText("Cancel", new String[0]));
        this.putIfUndefined(defaults, "HeaderPanel.background", null);
        this.putIfUndefined(defaults, "HeaderPanel.height", 0);
        this.putIfUndefined(defaults, "HeaderPanel.logoHorizontalAlignment", 0);
        this.putIfUndefined(defaults, "HeaderPanel.logoVerticalAlignment", -1);
    }

    protected void putIfUndefined(UIDefaults defaults, Object key, Object defaultValue) {
        if (defaults.get(key) == null) {
            defaults.put(key, defaultValue);
        }
    }

    protected IconUIResource createIconUIResource(String resourceSimpleName) {
        Icon icon = Activator.getIcon(resourceSimpleName);
        if (icon != null) {
            return new IconUIResource(icon);
        }
        return null;
    }

    protected IconUIResource getSplashUIResource() {
        IconUIResource iconresource;
        block5: {
            iconresource = null;
            String splashPathProp = BundleContextUtility.getProperty((String)"osgi.splashPath");
            try {
                Path p;
                String bundleName;
                Bundle splashBundle;
                if (StringUtility.isNullOrEmpty((CharSequence)splashPathProp) || (splashBundle = Platform.getBundle((String)(bundleName = (p = new Path(splashPathProp)).lastSegment()))) == null) break block5;
                String[] stringArray = this.m_splashExtensions;
                int n = this.m_splashExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    Image img;
                    URL splashUrl;
                    String ext = stringArray[n2];
                    String imageName = "splash." + ext;
                    URL[] entries = FileLocator.findEntries((Bundle)splashBundle, (IPath)new Path(imageName));
                    if (entries != null && entries.length > 0 && (splashUrl = entries[entries.length - 1]) != null && (img = Toolkit.getDefaultToolkit().createImage(IOUtility.getContent((InputStream)splashUrl.openStream()))) != null) {
                        iconresource = new IconUIResource(new ImageIcon(img, imageName));
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                LOG.error("could not find splash for config.ini property 'osgi.splashPath' -> value '" + splashPathProp + "'.", (Throwable)e);
            }
        }
        if (iconresource == null) {
            iconresource = this.createIconUIResource("splash");
        }
        return iconresource;
    }
}

