/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.text;

import java.awt.Color;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.ui.swing.basic.ColorUtility;
import org.eclipse.scout.rt.ui.swing.text.IStyledTextCreator;

public class HTMLStyledTextCreator
implements IStyledTextCreator {
    private static final Pattern HTML_PATTERN = Pattern.compile("<html>(.*)</html>", 32);
    private static final Pattern BODY_PATTERN = Pattern.compile("<body[^>]*>(.*)</body>", 32);
    private Color m_backgroundColor;
    private Color m_foregroundColor;
    private int m_horizontalAlignment = Integer.MIN_VALUE;
    private int m_verticalAlignment = Integer.MIN_VALUE;
    private int m_height;
    private String m_text;
    private boolean m_textWrap;

    @Override
    public IStyledTextCreator setText(String text) {
        this.m_text = text;
        return this;
    }

    public String getText() {
        return this.m_text;
    }

    @Override
    public IStyledTextCreator setBackgroundColor(Color color) {
        this.m_backgroundColor = color;
        return this;
    }

    public Color getBackgroundColor() {
        return this.m_backgroundColor;
    }

    @Override
    public IStyledTextCreator setForegroundColor(Color color) {
        this.m_foregroundColor = color;
        return this;
    }

    public Color getForegroundColor() {
        return this.m_foregroundColor;
    }

    @Override
    public IStyledTextCreator setHorizontalAlignment(int scoutAlign) {
        this.m_horizontalAlignment = scoutAlign;
        return this;
    }

    public int getHorizontalAlignment() {
        return this.m_horizontalAlignment;
    }

    @Override
    public IStyledTextCreator setVerticalAlignment(int scoutAlign) {
        this.m_verticalAlignment = scoutAlign;
        return this;
    }

    public int getVerticalAlignment() {
        return this.m_verticalAlignment;
    }

    @Override
    public IStyledTextCreator setHeight(int height) {
        this.m_height = height;
        return this;
    }

    public int getHeight() {
        return this.m_height;
    }

    @Override
    public IStyledTextCreator setTextWrap(boolean wrap) {
        this.m_textWrap = wrap;
        return this;
    }

    public boolean isTextWrap() {
        return this.m_textWrap;
    }

    @Override
    public String createStyledText() {
        if (!StringUtility.hasText((CharSequence)this.getText())) {
            this.setText("<!-- -->");
        }
        String styledText = this.getText().trim();
        boolean originalTextIsHTML = false;
        if (HTML_PATTERN.matcher(styledText).matches()) {
            styledText = StringUtility.getTag((String)styledText, (String)"html");
            originalTextIsHTML = true;
        }
        if (BODY_PATTERN.matcher(styledText).matches()) {
            styledText = StringUtility.getTag((String)styledText, (String)"body");
        }
        if (!originalTextIsHTML) {
            styledText = StringUtility.replaceNewLines((String)styledText, (String)"<br>");
        }
        styledText = "<html><body style=\"" + this.getBodyStyle() + "\"><div align=\"" + this.getAlign() + "\"><table cellpadding=\"0\" cellspacing=\"0\"><tr><td valign=\"" + this.getValign() + "\" height=\"" + this.getHeight() + "px\" style=\"white-space:" + this.getWrapText() + ";\">" + styledText + "</td></tr></table></div></body></html>";
        return styledText;
    }

    protected String getValign() {
        if (this.getVerticalAlignment() == 0) {
            return "middle";
        }
        if (this.getVerticalAlignment() == 3) {
            return "bottom";
        }
        return "top";
    }

    protected String getAlign() {
        if (this.getHorizontalAlignment() == 0) {
            return "center";
        }
        if (this.getHorizontalAlignment() == 4) {
            return "right";
        }
        return "left";
    }

    protected String getWrapText() {
        if (!this.isTextWrap()) {
            return "nowrap";
        }
        return "normal";
    }

    protected String getBodyStyle() {
        String bodyStyle = "";
        if (StringUtility.hasText((CharSequence)ColorUtility.createStringFromColor(this.getBackgroundColor()))) {
            bodyStyle = String.valueOf(bodyStyle) + "background-color: " + ColorUtility.createStringFromColor(this.getBackgroundColor()) + ";";
        }
        if (StringUtility.hasText((CharSequence)ColorUtility.createStringFromColor(this.getForegroundColor()))) {
            bodyStyle = String.valueOf(bodyStyle) + "color: " + ColorUtility.createStringFromColor(this.getForegroundColor()) + ";";
        }
        return bodyStyle;
    }
}

