/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.filechooser;

import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.window.filechooser.ISwingScoutFileChooser;

public class SwingScoutFileChooser
implements ISwingScoutFileChooser {
    private ISwingEnvironment m_env;
    private IFileChooser m_scoutFileChooser;
    private Window m_owner;
    private boolean m_useAWT;

    public SwingScoutFileChooser(ISwingEnvironment env, IFileChooser fc, Window owner, boolean useAWT) {
        this.m_env = env;
        this.m_scoutFileChooser = fc;
        this.m_owner = owner;
        this.m_useAWT = useAWT;
    }

    @Override
    public void showFileChooser() {
        List<File> files = null;
        try {
            files = this.m_useAWT && !this.m_scoutFileChooser.isFolderMode() ? this.showFileChooserAWT() : this.showFileChooserSwing();
        }
        catch (Throwable throwable) {
            List<File> finalFiles = files;
            Runnable t = new Runnable(finalFiles){
                private final /* synthetic */ List val$finalFiles;
                {
                    this.val$finalFiles = list;
                }

                @Override
                public void run() {
                    SwingScoutFileChooser.this.m_scoutFileChooser.setFiles(this.val$finalFiles);
                }
            };
            this.m_env.invokeScoutLater(t, 0L);
            throw throwable;
        }
        List<File> finalFiles = files;
        Runnable t = new /* invalid duplicate definition of identical inner class */;
        this.m_env.invokeScoutLater(t, 0L);
    }

    protected List<File> showFileChooserSwing() {
        File f;
        block11: {
            int result;
            JFileChooser dlg;
            List extensions = this.m_scoutFileChooser.getFileExtensions();
            boolean openMode = this.m_scoutFileChooser.isTypeLoad();
            File curDir = this.m_scoutFileChooser.getDirectory();
            boolean folderMode = this.m_scoutFileChooser.isFolderMode();
            String fileName = this.m_scoutFileChooser.getFileName();
            try {
                SecurityManager sm = System.getSecurityManager();
                System.setSecurityManager(null);
                dlg = this.createFileChooserSwing(curDir);
                System.setSecurityManager(sm);
            }
            catch (Exception e) {
                dlg = this.createFileChooserSwing(curDir);
            }
            if (folderMode) {
                dlg.setFileSelectionMode(1);
            } else {
                dlg.setFileSelectionMode(0);
            }
            if (extensions.size() > 0) {
                FileFilter[] filters = dlg.getChoosableFileFilters();
                int i = 0;
                while (filters != null && i < filters.length) {
                    dlg.removeChoosableFileFilter(filters[i]);
                    ++i;
                }
                dlg.addChoosableFileFilter(new ExtensionFileFilter(extensions));
                i = 0;
                while (i < extensions.size()) {
                    String oneExt = (String)extensions.get(i);
                    dlg.addChoosableFileFilter(new ExtensionFileFilter(Collections.singletonList(oneExt)));
                    ++i;
                }
            }
            if (StringUtility.hasText((CharSequence)fileName) && !folderMode) {
                dlg.setSelectedFile(new File(fileName));
            }
            f = null;
            while ((result = openMode ? dlg.showOpenDialog(this.m_owner) : dlg.showSaveDialog(this.m_owner)) == 0) {
                int msgBoxResult;
                f = dlg.getSelectedFile();
                if (!folderMode && f != null && dlg.getFileFilter() instanceof ExtensionFileFilter) {
                    List<String> selectedExtensions = ((ExtensionFileFilter)dlg.getFileFilter()).getExtensions();
                    String path = f.getAbsolutePath();
                    if (selectedExtensions.size() == 1 && !dlg.getFileFilter().accept(f)) {
                        f = new File(String.valueOf(path) + "." + selectedExtensions.get(0));
                    }
                }
                if (!openMode && f != null && f.exists() && !f.isDirectory() && (msgBoxResult = JOptionPane.showConfirmDialog(this.m_owner, SwingUtility.getNlsText("FileExistsOwerwriteQuestion", new String[0]), null, 0)) != 0) continue;
                break block11;
            }
            f = null;
        }
        return CollectionUtility.arrayList((Object)f);
    }

    protected JFileChooser createFileChooserSwing(File curDir) {
        if (curDir != null) {
            return new JFileChooser(curDir);
        }
        return new JFileChooser();
    }

    protected List<File> showFileChooserAWT() {
        File f;
        FileDialog dlg;
        String fileName;
        boolean folderMode;
        File curDir;
        List extensions;
        block25: {
            extensions = this.m_scoutFileChooser.getFileExtensions();
            boolean openMode = this.m_scoutFileChooser.isTypeLoad();
            curDir = this.m_scoutFileChooser.getDirectory();
            folderMode = this.m_scoutFileChooser.isFolderMode();
            fileName = this.m_scoutFileChooser.getFileName();
            SecurityManager sm = System.getSecurityManager();
            try {
                try {
                    System.setSecurityManager(null);
                    StringBuffer buf = new StringBuffer();
                    if (extensions != null) {
                        int i = 0;
                        while (i < extensions.size()) {
                            if (i > 0) {
                                buf.append(", ");
                            }
                            buf.append("*." + (String)extensions.get(i));
                            ++i;
                        }
                    }
                    if (buf.length() == 0) {
                        buf.append("*.*");
                    }
                    dlg = this.createFileChooserAWT(this.m_owner, buf.toString(), openMode);
                    System.setSecurityManager(sm);
                }
                catch (Exception e) {
                    dlg = this.createFileChooserAWT(this.m_owner);
                    try {
                        System.setSecurityManager(sm);
                    }
                    catch (Throwable throwable) {}
                    break block25;
                }
            }
            catch (Throwable throwable) {
                try {
                    System.setSecurityManager(sm);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                System.setSecurityManager(sm);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (curDir != null) {
            f = curDir;
            if (!f.isDirectory()) {
                f = f.getAbsoluteFile().getParentFile();
            }
            dlg.setDirectory(f.getAbsolutePath());
        }
        if (extensions != null && extensions.isEmpty()) {
            final List extListFinal = extensions;
            if (StringUtility.hasText((CharSequence)fileName)) {
                dlg.setFile(fileName);
            } else {
                StringBuffer extBuf = new StringBuffer();
                int i = 0;
                while (i < extListFinal.size()) {
                    if (extBuf.length() > 0) {
                        extBuf.append(";");
                    }
                    extBuf.append("*." + (String)extListFinal.get(i));
                    ++i;
                }
                dlg.setFile(extBuf.toString());
            }
            dlg.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    int i = 0;
                    while (i < extListFinal.size()) {
                        if (name.toLowerCase().endsWith("." + (String)extListFinal.get(i))) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
            });
        }
        f = null;
        dlg.setVisible(true);
        if (dlg.getFile() != null) {
            String path;
            f = new File(dlg.getDirectory(), dlg.getFile());
            if (!folderMode && extensions.size() == 1 && !(path = f.getAbsolutePath()).toLowerCase().endsWith("." + (String)extensions.get(0))) {
                f = new File(String.valueOf(path) + "." + (String)extensions.get(0));
            }
        } else {
            f = null;
        }
        return CollectionUtility.arrayList((Object)f);
    }

    protected FileDialog createFileChooserAWT(Window owner) {
        return this.createFileChooserAWT(owner, "", true);
    }

    protected FileDialog createFileChooserAWT(Window owner, String title, boolean openMode) {
        if (owner instanceof Dialog) {
            return new FileDialog((Dialog)owner, title, openMode ? 0 : 1);
        }
        if (this.m_owner instanceof Frame) {
            return new FileDialog((Frame)this.m_owner, title, openMode ? 0 : 1);
        }
        return new FileDialog(new Frame(), title, openMode ? 0 : 1);
    }

    public static class ExtensionFileFilter
    extends FileFilter {
        private final List<String> m_extensions;

        public ExtensionFileFilter(List<String> extensions) {
            if (extensions == null) {
                this.m_extensions = CollectionUtility.emptyArrayList();
            } else {
                ArrayList<String> list = new ArrayList<String>(extensions.size());
                for (String extension : extensions) {
                    if (extension == null || "*".equals(extension)) continue;
                    list.add(extension.toLowerCase());
                }
                this.m_extensions = list;
            }
        }

        @Override
        public String getDescription() {
            if (this.m_extensions.isEmpty()) {
                return "*.*";
            }
            StringBuilder s = new StringBuilder();
            for (String extension : this.m_extensions) {
                s.append("*.");
                s.append(extension);
                s.append(";");
            }
            s.deleteCharAt(s.length() - 1);
            return s.toString();
        }

        public List<String> getExtensions() {
            return CollectionUtility.arrayList(this.m_extensions);
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || this.m_extensions.isEmpty() || this.fileNameMatches(f);
        }

        private boolean fileNameMatches(File f) {
            String name = f.getName().toLowerCase();
            for (String extension : this.m_extensions) {
                if (!name.endsWith(extension)) continue;
                return true;
            }
            return false;
        }
    }
}

