/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar.layout;

import org.eclipse.scout.rt.ui.swt.basic.calendar.layout.WeekItemData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class WeekItemLayout
extends Layout {
    private static final int MIN_WIDTH = 3;
    private static final int MIN_HEIGHT = 4;
    private int m_startHour = 6;
    private int m_endHour = 20;
    private boolean m_useOverflowCells = true;

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        return new Point(0, 0);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Control[] children = composite.getChildren();
        Rectangle clipRect = composite.getClientArea();
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            WeekItemData dat = (WeekItemData)child.getLayoutData();
            int yOffset = Math.max(0, dat.getOffsetCellHeader() - 1);
            int timelessHeight = Math.min(24 * dat.getTimelessMaxCount(), 33 * clipRect.height / 100);
            int hTimeless = Math.max(0, timelessHeight - 1);
            int yTimed = yOffset + hTimeless + 1;
            int hTimed = clipRect.height - yOffset - hTimeless;
            Rectangle r = new Rectangle(0, 0, 0, 0);
            long intervalMillis = (long)(this.m_endHour - this.m_startHour) * 3600000L;
            int timelessItemHeight = 0;
            int countTimeless = dat.getTimelessCount();
            if (countTimeless > 0) {
                timelessItemHeight = Math.max(5, hTimeless / countTimeless);
            }
            int absX = 0;
            int absY = 0;
            int w = clipRect.width;
            if (dat.getItem().isTimed()) {
                r.x = (int)(dat.getItem().getX0() * (float)w);
                r.width = (int)(dat.getItem().getX1() * (float)w) - r.x;
                r.width = r.width < 3 ? 3 : r.width;
                r.y = yTimed + (int)(dat.getItem().getFromRelative() * (long)hTimed / intervalMillis);
                r.height = yTimed + (int)(dat.getItem().getToRelative() * (long)hTimed / intervalMillis) - r.y;
                r.height = r.height < 4 ? 4 : r.height;
            } else {
                r.x = 0;
                r.width = w;
                r.y = yOffset + dat.getTimelessIndex() * timelessItemHeight;
                r.height = r.y < hTimeless + yOffset ? timelessItemHeight : 0;
            }
            ++r.x;
            r.width = Math.max(0, r.width - 2);
            ++r.y;
            r.height = Math.max(0, r.height - 2);
            child.setBounds(r.x + absX, r.y + absY, r.width, r.height);
            ++n2;
        }
    }

    public void setWorkingHours(int startHour, int endHour, boolean useOverflowCells) {
        this.m_startHour = startHour;
        this.m_endHour = endHour;
        this.m_useOverflowCells = useOverflowCells;
    }
}

