/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action;

import java.util.Collections;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scout.commons.holders.BooleanHolder;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.extensions.executor.ExecutorExtensionPoint;
import org.eclipse.scout.sdk.ui.extensions.executor.IExecutor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.services.IEvaluationService;

public abstract class AbstractScoutHandler
extends AbstractHandler
implements IScoutHandler {
    private String m_label;
    private String m_toolTip;
    private ImageDescriptor m_image;
    private String m_keyStroke;
    private boolean m_multiSelectSupported;
    private IScoutHandler.Category m_category;
    private final IExecutor m_menuExecutor;

    public AbstractScoutHandler(String label) {
        this(label, null);
    }

    public AbstractScoutHandler(String label, ImageDescriptor image) {
        this(label, image, null);
    }

    public AbstractScoutHandler(String label, ImageDescriptor image, String keyStroke) {
        this(label, image, keyStroke, false);
    }

    public AbstractScoutHandler(String label, ImageDescriptor image, String keyStroke, boolean multiSelectSupported) {
        this(label, image, keyStroke, multiSelectSupported, IScoutHandler.Category.OTHER);
    }

    public AbstractScoutHandler(String label, ImageDescriptor image, String keyStroke, boolean multiSelectSupported, IScoutHandler.Category cat) {
        this.m_label = label;
        this.m_image = image;
        this.m_keyStroke = keyStroke;
        this.m_multiSelectSupported = multiSelectSupported;
        this.m_category = cat == null ? IScoutHandler.Category.OTHER : cat;
        this.m_menuExecutor = ExecutorExtensionPoint.getExecutorFor(this.getExecutorId());
    }

    protected String getExecutorId() {
        return this.getClass().getName();
    }

    public final void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        if (evaluationContext instanceof BooleanHolder) {
            this.setBaseEnabled((Boolean)((BooleanHolder)evaluationContext).getValue());
        }
    }

    public final boolean isEnabled() {
        return super.isEnabled();
    }

    protected final void setBaseEnabled(boolean state) {
        super.setBaseEnabled(state);
    }

    @Override
    public boolean isActive(IStructuredSelection selection) {
        return true;
    }

    @Override
    public final boolean isVisible(IStructuredSelection selection) {
        return this.m_menuExecutor.canRun(selection);
    }

    @Override
    public String getLabel() {
        return this.m_label;
    }

    @Override
    public void setLabel(String label) {
        this.m_label = label;
    }

    @Override
    public String getToolTip() {
        return this.m_toolTip;
    }

    @Override
    public void setToolTip(String toolTip) {
        this.m_toolTip = toolTip;
    }

    @Override
    public ImageDescriptor getImage() {
        return this.m_image;
    }

    @Override
    public void setImage(ImageDescriptor imageName) {
        this.m_image = imageName;
    }

    @Override
    public String getKeyStroke() {
        return this.m_keyStroke;
    }

    @Override
    public void setKeyStroke(String keyStroke) {
        this.m_keyStroke = keyStroke;
    }

    @Override
    public boolean isMultiSelectSupported() {
        return this.m_multiSelectSupported;
    }

    @Override
    public void setMultiSelectSupported(boolean multiSelectSupported) {
        this.m_multiSelectSupported = multiSelectSupported;
    }

    @Override
    public IScoutHandler.Category getCategory() {
        return this.m_category;
    }

    @Override
    public void setCategory(IScoutHandler.Category category) {
        this.m_category = category;
    }

    @Override
    public final String getId() {
        return this.getClass().getName();
    }

    public static void exec(Shell shell, IScoutHandler action, Object ... args) {
        ExecutionEvent event = AbstractScoutHandler.createEvent(shell, args);
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (action.isVisible(selection) && action.isActive(selection)) {
            try {
                action.execute(event);
            }
            catch (ExecutionException e1) {
                ScoutSdkUi.logError("Unable to execute action. ", e1);
            }
        }
    }

    public static ExecutionEvent createEvent(Shell shell, IStructuredSelection sel) {
        IEvaluationContext parent = null;
        IEvaluationService esrvc = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        if (esrvc != null) {
            parent = esrvc.getCurrentState();
        }
        EvaluationContext ctx = new EvaluationContext(parent, (Object)sel);
        ctx.setAllowPluginActivation(true);
        ctx.addVariable("selection", (Object)sel);
        ctx.addVariable("activeShell", (Object)shell);
        ExecutionEvent event = new ExecutionEvent(null, Collections.EMPTY_MAP, null, (Object)ctx);
        return event;
    }

    public static ExecutionEvent createEvent(Shell shell, Object ... args) {
        return AbstractScoutHandler.createEvent(shell, (IStructuredSelection)new StructuredSelection(args));
    }

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        Display display;
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Object selection = null;
        selection = sel instanceof IStructuredSelection ? (IStructuredSelection)sel : StructuredSelection.EMPTY;
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (shell == null) {
            shell = ScoutSdkUi.getShell();
        }
        if (shell == null && (display = Display.getDefault()) != null) {
            shell = display.getActiveShell();
        }
        return this.m_menuExecutor.run(shell, (IStructuredSelection)selection, event);
    }
}

