/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.sdk.ui.extensions.IDragSourceDelegator;
import org.eclipse.scout.sdk.ui.extensions.IDropTargetDelegator;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;

public final class DndExtensionPoint {
    public static final String DROP_DELEGATOR_ATTR_NAME = "dropTargetDelegator";
    public static final String DRAG_DELEGATOR_ATTR_NAME = "dragSourceDelegator";
    public static final String EXTENSION_NAME = "outlineDragAndDrop";
    private static List<IDragSourceDelegator> dragSourceDelegates = null;
    private static List<IDropTargetDelegator> dropTargetDelegates = null;

    private DndExtensionPoint() {
    }

    private static synchronized void init() {
        if (dragSourceDelegates == null || dropTargetDelegates == null) {
            IExtension[] extensions;
            ArrayList<IDragSourceDelegator> dragDelegators = new ArrayList<IDragSourceDelegator>();
            ArrayList<IDropTargetDelegator> dropDelegators = new ArrayList<IDropTargetDelegator>();
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", EXTENSION_NAME);
            IExtension[] iExtensionArray = extensions = xp.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    try {
                        if (element.getAttribute(DRAG_DELEGATOR_ATTR_NAME) != null) {
                            IDragSourceDelegator dragDelegator = (IDragSourceDelegator)element.createExecutableExtension(DRAG_DELEGATOR_ATTR_NAME);
                            dragDelegators.add(dragDelegator);
                        } else if (element.getAttribute(DROP_DELEGATOR_ATTR_NAME) != null) {
                            IDropTargetDelegator dropDelegator = (IDropTargetDelegator)element.createExecutableExtension(DROP_DELEGATOR_ATTR_NAME);
                            dropDelegators.add(dropDelegator);
                        }
                    }
                    catch (CoreException e) {
                        ScoutSdkUi.logError("could not create an executable extension of point '" + extension.getExtensionPointUniqueIdentifier() + "'.", e);
                    }
                    ++n4;
                }
                ++n2;
            }
            dropTargetDelegates = CollectionUtility.arrayList(dropDelegators);
            dragSourceDelegates = CollectionUtility.arrayList(dragDelegators);
        }
    }

    public static List<IDragSourceDelegator> getDragSourceDelegators() {
        DndExtensionPoint.init();
        return CollectionUtility.arrayList(dragSourceDelegates);
    }

    public static List<IDropTargetDelegator> getDropTargetDelegators() {
        DndExtensionPoint.init();
        return CollectionUtility.arrayList(dropTargetDelegates);
    }
}

