/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.extensions.IPageFactory;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.osgi.framework.Bundle;

public final class ExplorerPageExtensionPoint {
    public static final String EXPLORER_PAGE_EXTENSION_ID = "explorerPage";
    public static final String PARENT_PAGE_ATTRIBUTE = "parentPageId";
    public static final String PAGE_ATTRIBUTE = "page";
    public static final String PAGE_FACTORY_ATTRIBUTE = "pageFactory";
    private static final Object LOCK = new Object();
    private static Map<String, List<ExplorerPageExtension>> pages = null;

    private ExplorerPageExtensionPoint() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load() {
        if (pages == null) {
            Object object = LOCK;
            synchronized (object) {
                if (pages == null) {
                    IExtension[] extensions;
                    HashMap<String, List<ExplorerPageExtension>> tmp = new HashMap<String, List<ExplorerPageExtension>>();
                    IExtensionRegistry reg = Platform.getExtensionRegistry();
                    IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", EXPLORER_PAGE_EXTENSION_ID);
                    IExtension[] iExtensionArray = extensions = xp.getExtensions();
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement[] elements;
                        IExtension extension = iExtensionArray[n2];
                        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                        int n3 = elements.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Bundle contributerBundle;
                            ExplorerPageExtension pageExt;
                            IConfigurationElement element = iConfigurationElementArray[n4];
                            if (PAGE_ATTRIBUTE.equals(element.getName())) {
                                pageExt = new ExplorerPageExtension();
                                pageExt.setParentPageId(element.getAttribute(PARENT_PAGE_ATTRIBUTE));
                                contributerBundle = Platform.getBundle((String)extension.getNamespaceIdentifier());
                                Class<IPage> pageClass = ExplorerPageExtensionPoint.getClassOfContribution(contributerBundle, element, PAGE_ATTRIBUTE, IPage.class);
                                if (pageClass != null) {
                                    pageExt.setPageClass(pageClass);
                                    ExplorerPageExtensionPoint.addExtension(tmp, pageExt);
                                }
                            } else if (PAGE_FACTORY_ATTRIBUTE.equals(element.getName())) {
                                pageExt = new ExplorerPageExtension();
                                pageExt.setParentPageId(element.getAttribute(PARENT_PAGE_ATTRIBUTE));
                                contributerBundle = Platform.getBundle((String)extension.getNamespaceIdentifier());
                                Class<IPageFactory> factoryClass = ExplorerPageExtensionPoint.getClassOfContribution(contributerBundle, element, "factory", IPageFactory.class);
                                if (factoryClass != null) {
                                    pageExt.setFactoryClass(factoryClass);
                                    ExplorerPageExtensionPoint.addExtension(tmp, pageExt);
                                }
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    pages = tmp;
                }
            }
        }
    }

    private static void addExtension(Map<String, List<ExplorerPageExtension>> collector, ExplorerPageExtension page) {
        List<ExplorerPageExtension> childNodes = collector.get(page.getParentPageId());
        if (childNodes == null) {
            childNodes = new ArrayList<ExplorerPageExtension>();
            collector.put(page.getParentPageId(), childNodes);
        }
        childNodes.add(page);
    }

    private static <T> Class<? extends T> getClassOfContribution(Bundle bundle, IConfigurationElement element, String attribute, Class<T> t) {
        Class clazz = null;
        if (bundle != null) {
            String clazzName = element.getAttribute(attribute);
            if (StringUtility.hasText((CharSequence)clazzName)) {
                try {
                    clazz = bundle.loadClass(clazzName);
                }
                catch (Exception tt) {
                    ScoutSdkUi.logWarning("Could not load class of extension '" + element.getName() + "'.", tt);
                }
            } else {
                ScoutSdkUi.logWarning("Page extension without class found. Contributed in bundle '" + bundle.getSymbolicName() + "'. Will be ignored.");
            }
        }
        return clazz;
    }

    public static List<ExplorerPageExtension> getExtensions(IPage parentPage) {
        ExplorerPageExtensionPoint.load();
        List<ExplorerPageExtension> list = pages.get(parentPage.getPageId());
        if (list != null) {
            return CollectionUtility.arrayList(list);
        }
        return CollectionUtility.emptyArrayList();
    }

    public static class ExplorerPageExtension {
        private Class<? extends IPage> m_pageClass;
        private Class<? extends IPageFactory> m_factoryClass;
        private String m_parentPageId;

        public void setPageClass(Class<? extends IPage> pageClass) {
            this.m_pageClass = pageClass;
        }

        public Class<? extends IPage> getPageClass() {
            return this.m_pageClass;
        }

        public IPage createPageInstance() {
            try {
                return this.getPageClass().newInstance();
            }
            catch (Exception e) {
                ScoutSdkUi.logError("could not instanciate class '" + this.getPageClass().getName() + "'.", e);
                return null;
            }
        }

        public void setFactoryClass(Class<? extends IPageFactory> factoryClass) {
            this.m_factoryClass = factoryClass;
        }

        public Class<? extends IPageFactory> getFactoryClass() {
            return this.m_factoryClass;
        }

        public IPageFactory createFactoryInstance() {
            try {
                return this.getFactoryClass().newInstance();
            }
            catch (Exception e) {
                ScoutSdkUi.logError("could not instanciate class '" + this.getFactoryClass().getName() + "'.", e);
                return null;
            }
        }

        public String getParentPageId() {
            return this.m_parentPageId;
        }

        private void setParentPageId(String parentPageId) {
            this.m_parentPageId = parentPageId;
        }
    }
}

