/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.multi;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.multi.AbstractMultiValuePresenter;
import org.eclipse.scout.sdk.ui.view.properties.presenter.util.MethodBean;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyUpdateOperation;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethodSet;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.scout.sdk.workspace.type.config.parser.IPropertySourceParser;
import org.eclipse.scout.sdk.workspace.type.config.parser.LongPropertySourceParser;
import org.eclipse.swt.widgets.Composite;

public class MultiLongPresenter
extends AbstractMultiValuePresenter<Long> {
    public MultiLongPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent, "[-+0-9\\'Eeinf]*");
    }

    @Override
    protected void init(ConfigurationMethodSet methodSet) throws CoreException {
        super.init(methodSet);
        Collection methodBeans = this.getMethodBeans();
        if (!MultiLongPresenter.allEqual(methodBeans)) {
            this.getTextComponent().setText("###");
        } else {
            this.getTextComponent().setText(this.formatDisplayValue((Long)methodBeans.iterator().next().getCurrentSourceValue()));
        }
    }

    @Override
    protected int getTextAlignment() {
        return 131072;
    }

    @Override
    protected String formatSourceValue(Long value) throws CoreException {
        if (value == Long.MAX_VALUE) {
            return "Long.MAX_VALUE";
        }
        if (value == Long.MIN_VALUE) {
            return "Long.MIN_VALUE";
        }
        return DecimalFormat.getNumberInstance(Locale.ENGLISH).format(value);
    }

    @Override
    protected String formatDisplayValue(Long value) throws CoreException {
        if (value == Long.MAX_VALUE) {
            return "inf";
        }
        if (value == Long.MIN_VALUE) {
            return "-inf";
        }
        return DecimalFormat.getNumberInstance(Locale.ENGLISH).format(value);
    }

    @Override
    protected Long parseSourceInput(String input, ConfigurationMethod method) throws CoreException {
        Long d = PropertyMethodSourceUtility.parseReturnParameterLong((String)input, (IMethod)method.peekMethod(), (ITypeHierarchy)method.getSuperTypeHierarchy());
        return d;
    }

    @Override
    protected Long parseDisplayInput(String input) throws CoreException {
        Long d = PropertyMethodSourceUtility.parseReturnParameterLong((String)input);
        return d;
    }

    @Override
    protected synchronized void storeMethods(Collection<MethodBean<Long>> beans, Long value) {
        ArrayList<ConfigPropertyUpdateOperation> list = new ArrayList<ConfigPropertyUpdateOperation>(beans.size());
        for (MethodBean<Long> bean : beans) {
            ConfigurationMethod method = bean.getMethod();
            ConfigPropertyUpdateOperation updateOp = new ConfigPropertyUpdateOperation(method, (IPropertySourceParser)new LongPropertySourceParser());
            updateOp.setValue((Object)value);
            list.add(updateOp);
        }
        new OperationJob(list).schedule();
    }
}

