/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.beanproperty;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.BeanPropertyNewOperation;
import org.eclipse.scout.sdk.operation.IBeanPropertyNewOperation;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.beanproperty.BeanPropertyNewWizardPage;
import org.eclipse.scout.sdk.util.type.IMethodFilter;
import org.eclipse.scout.sdk.util.type.MethodFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.ui.IWorkbench;

public class BeanPropertyNewWizard
extends AbstractWorkspaceWizard {
    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IType declaringType = UiUtility.getTypeFromSelection(selection);
        this.setWindowTitle(Texts.get((String)"NewProperty"));
        IJavaSearchScope createJavaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{declaringType.getJavaProject()});
        BeanPropertyNewWizardPage beanPropertyWizardPage = new BeanPropertyNewWizardPage(createJavaSearchScope, declaringType);
        BeanPropertyNewOperation op = new BeanPropertyNewOperation(declaringType);
        beanPropertyWizardPage.setOperation((IBeanPropertyNewOperation)op);
        HashSet<String> notAllowedMethodNames = new HashSet<String>();
        Set methods = TypeUtility.getMethods((IType)declaringType, (IMethodFilter)MethodFilters.getNameRegexFilter((Pattern)Pattern.compile("^(get|set|is).*")));
        for (IMethod m : methods) {
            notAllowedMethodNames.add(m.getElementName());
        }
        beanPropertyWizardPage.setNotAllowedNames(notAllowedMethodNames);
        this.addPage((IWizardPage)beanPropertyWizardPage);
    }
}

