/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.internal.typecache;

import java.util.Comparator;
import java.util.EventListener;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.internal.typecache.HierarchyCache;
import org.eclipse.scout.sdk.util.internal.typecache.ICacheableTypeHierarchyResult;
import org.eclipse.scout.sdk.util.internal.typecache.TypeHierarchy;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;

public abstract class AbstractCachedTypeHierarchy
extends TypeHierarchy
implements ICacheableTypeHierarchyResult,
ICachedTypeHierarchy {
    private final EventListenerList m_hierarchyListeners = new EventListenerList();
    private volatile boolean m_created = false;

    protected AbstractCachedTypeHierarchy(IType type) {
        super(type);
    }

    @Override
    protected void setBaseType(IType newBaseType) {
        super.setBaseType(newBaseType);
        this.invalidate();
    }

    @Override
    public boolean contains(IType type) {
        this.revalidateImpl();
        return super.contains(type);
    }

    @Override
    public Set<IType> getAllClasses(ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidateImpl();
        return super.getAllClasses(filter, comparator);
    }

    @Override
    public Set<IType> getAllInterfaces(ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidateImpl();
        return super.getAllInterfaces(filter, comparator);
    }

    @Override
    public boolean isSubtype(IType type, IType potentialSubtype) {
        if (CompareUtility.equals((Object)type, (Object)potentialSubtype)) {
            return true;
        }
        this.revalidateImpl();
        return super.isSubtype(type, potentialSubtype);
    }

    @Override
    public Set<IType> getAllSubtypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidateImpl();
        return super.getAllSubtypes(type, filter, comparator);
    }

    @Override
    public Set<IType> getAllSuperclasses(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidateImpl();
        return super.getAllSuperclasses(type, filter, comparator);
    }

    @Override
    public Set<IType> getAllSuperInterfaces(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidateImpl();
        return super.getAllSuperInterfaces(type, filter, comparator);
    }

    @Override
    public Set<IType> getAllTypes(ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidateImpl();
        return super.getAllTypes(filter, comparator);
    }

    @Override
    public Set<IType> getSubclasses(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidateImpl();
        return super.getSubclasses(type, filter, comparator);
    }

    @Override
    public Set<IType> getSubtypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidateImpl();
        return super.getSubtypes(type, filter, comparator);
    }

    @Override
    public IType getSuperclass(IType type) {
        this.revalidateImpl();
        return super.getSuperclass(type);
    }

    @Override
    public Set<IType> getSuperInterfaces(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidateImpl();
        return super.getSuperInterfaces(type, filter, comparator);
    }

    @Override
    public Set<IType> getSupertypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidateImpl();
        return super.getSupertypes(type, filter, comparator);
    }

    @Override
    public Set<IType> getAllSupertypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidateImpl();
        return super.getAllSupertypes(type, filter, comparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revalidateImpl() {
        if (!this.isCreated()) {
            AbstractCachedTypeHierarchy abstractCachedTypeHierarchy = this;
            synchronized (abstractCachedTypeHierarchy) {
                if (!this.isCreated()) {
                    HierarchyCache hierarchyCache = HierarchyCache.getInstance();
                    if (this.getBaseType() == null) {
                        hierarchyCache.removeCachedHierarchy(null);
                        throw new IllegalArgumentException("Type 'null' does not exist.");
                    }
                    IType newBaseType = TypeUtility.getType(this.getBaseType().getFullyQualifiedName());
                    if (TypeUtility.exists((IJavaElement)newBaseType) && TypeUtility.exists((IJavaElement)newBaseType.getJavaProject())) {
                        if (!newBaseType.equals(this.getBaseType())) {
                            hierarchyCache.replaceCachedHierarchy(this.getBaseType(), newBaseType, this);
                            this.setBaseType(newBaseType);
                        }
                    } else {
                        hierarchyCache.removeCachedHierarchy(this.getBaseType());
                        throw new IllegalArgumentException("Type '" + this.getBaseType().getFullyQualifiedName() + "' does not exist.");
                    }
                    this.revalidate();
                    boolean bl = this.m_created = this.getJdtHierarchy() != null;
                    if (!this.m_created) {
                        throw new IllegalArgumentException("Hierarchy '" + this.getBaseType().getFullyQualifiedName() + "' could not be re-validated. See prior errors for details.");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        boolean wasCreated = this.m_created;
        AbstractCachedTypeHierarchy abstractCachedTypeHierarchy = this;
        synchronized (abstractCachedTypeHierarchy) {
            this.m_created = false;
            this.setJdtHierarchy(null);
        }
        if (wasCreated) {
            this.fireHierarchyChanged();
        }
    }

    protected abstract void revalidate();

    private void fireHierarchyChanged() {
        ITypeHierarchyChangedListener[] iTypeHierarchyChangedListenerArray = (ITypeHierarchyChangedListener[])this.m_hierarchyListeners.getListeners(ITypeHierarchyChangedListener.class);
        int n = iTypeHierarchyChangedListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeHierarchyChangedListener l = iTypeHierarchyChangedListenerArray[n2];
            try {
                l.hierarchyInvalidated();
            }
            catch (Exception e) {
                SdkUtilActivator.logError("Error invoking hierarchy changed listener '" + l.getClass().getName() + "'.", e);
            }
            ++n2;
        }
    }

    @Override
    public boolean isCreated() {
        return this.m_created;
    }

    @Override
    public void addHierarchyListener(ITypeHierarchyChangedListener listener) {
        this.m_hierarchyListeners.add(ITypeHierarchyChangedListener.class, (EventListener)listener);
    }

    @Override
    public void removeHierarchyListener(ITypeHierarchyChangedListener listener) {
        this.m_hierarchyListeners.remove(ITypeHierarchyChangedListener.class, (EventListener)listener);
    }
}

