/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.typecache;

import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public class TypeHierarchyConstraints {
    private final IType m_baseType;
    private IJavaProject m_classpath;
    private boolean m_includeBaseType;
    private int m_searchFor;
    private int m_setFlags;
    private int m_notSetFlags;
    private static final String NOT_NULL_MSG = "hierarchy base type may not be null!";

    public TypeHierarchyConstraints(IType baseType, IJavaProject classpath) {
        if (!TypeUtility.exists((IJavaElement)baseType)) {
            throw new IllegalArgumentException(NOT_NULL_MSG);
        }
        this.m_baseType = baseType;
        this.m_classpath = classpath;
        this.m_includeBaseType = true;
        this.m_searchFor = 0;
        this.m_setFlags = 0;
        this.m_notSetFlags = 0;
    }

    public TypeHierarchyConstraints modifiersSet(int ... mods) {
        if (mods != null && mods.length > 0) {
            int[] nArray = mods;
            int n = mods.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                this.m_setFlags |= i;
                ++n2;
            }
        }
        return this;
    }

    public TypeHierarchyConstraints modifiersNotSet(int ... mods) {
        if (mods != null && mods.length > 0) {
            int[] nArray = mods;
            int n = mods.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                this.m_notSetFlags |= i;
                ++n2;
            }
        }
        return this;
    }

    public boolean modifiersAccepted(int modifiers) {
        return !((modifiers & this.m_setFlags) != this.m_setFlags && this.m_setFlags != 0 || (modifiers & this.m_notSetFlags) != 0 && this.m_notSetFlags != 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTypeAccepted(IType t, Set<IType> superTypes) {
        if (!superTypes.contains(this.getBaseType())) {
            return false;
        }
        if (this.getClasspath() != null && !TypeUtility.isOnClasspath((IJavaElement)t, this.getClasspath())) {
            return false;
        }
        if (this.getBaseType().equals(t) && !this.isIncludeBaseType()) {
            return false;
        }
        try {
            switch (this.getSearchFor()) {
                case 5: {
                    if (!t.isClass()) {
                        return false;
                    }
                }
                case 10: {
                    if (!t.isClass() && !t.isInterface()) {
                        return false;
                    }
                }
                case 9: {
                    if (!t.isClass() && !t.isEnum()) {
                        return false;
                    }
                }
                case 6: {
                    if (!t.isInterface()) {
                        return false;
                    }
                }
                case 11: {
                    if (!t.isInterface() && !t.isAnnotation()) {
                        return false;
                    }
                }
                case 7: {
                    if (!t.isEnum()) {
                        return false;
                    }
                }
                case 8: {
                    if (t.isAnnotation()) break;
                    return false;
                }
            }
            if (this.modifiersAccepted(t.getFlags())) return true;
            return false;
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logError("Error while checking for acceptance in hierarchy of base type '" + this.getBaseType().getFullyQualifiedName() + "'.", e);
            return false;
        }
    }

    public IType getBaseType() {
        return this.m_baseType;
    }

    public IJavaProject getClasspath() {
        return this.m_classpath;
    }

    public TypeHierarchyConstraints setClasspath(IJavaProject classpath) {
        this.m_classpath = classpath;
        return this;
    }

    public boolean isIncludeBaseType() {
        return this.m_includeBaseType;
    }

    public TypeHierarchyConstraints setIncludeBaseType(boolean includeBaseType) {
        this.m_includeBaseType = includeBaseType;
        return this;
    }

    public int getSearchFor() {
        return this.m_searchFor;
    }

    public TypeHierarchyConstraints setSearchFor(int searchFor) {
        this.m_searchFor = searchFor;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_baseType == null ? 0 : this.m_baseType.hashCode());
        result = 31 * result + (this.m_classpath == null ? 0 : this.m_classpath.hashCode());
        result = 31 * result + (this.m_includeBaseType ? 1231 : 1237);
        result = 31 * result + this.m_notSetFlags;
        result = 31 * result + this.m_searchFor;
        result = 31 * result + this.m_setFlags;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeHierarchyConstraints)) {
            return false;
        }
        TypeHierarchyConstraints other = (TypeHierarchyConstraints)obj;
        if (this.m_baseType == null ? other.m_baseType != null : !this.m_baseType.equals(other.m_baseType)) {
            return false;
        }
        if (this.m_classpath == null ? other.m_classpath != null : !this.m_classpath.equals(other.m_classpath)) {
            return false;
        }
        if (this.m_includeBaseType != other.m_includeBaseType) {
            return false;
        }
        if (this.m_notSetFlags != other.m_notSetFlags) {
            return false;
        }
        if (this.m_searchFor != other.m_searchFor) {
            return false;
        }
        return this.m_setFlags == other.m_setFlags;
    }
}

