/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.executor;

import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.marker.IMarkerRebuildListener;
import org.eclipse.scout.sdk.ws.jaxws.operation.BindingFileCreateOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.WsdlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceConsumerNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderNodePage;
import org.eclipse.scout.sdk.ws.jaxws.util.GlobalBindingRegistrationHelper;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.SchemaUtility;
import org.eclipse.swt.widgets.Shell;

public class BindingFileNewExecutor
extends AbstractExecutor {
    private IScoutBundle m_bundle;

    public boolean canRun(IStructuredSelection selection) {
        this.m_bundle = UiUtility.getScoutBundleFromSelection((IStructuredSelection)selection);
        return this.isEditable(this.m_bundle);
    }

    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        WsdlResource wsdlResource;
        BuildJaxWsBean buildJaxWsBean;
        GlobalBindingRegistrationHelper.SchemaCandidate schemaCandidate;
        block9: {
            IMarkerRebuildListener p;
            Object selected = selection.getFirstElement();
            schemaCandidate = null;
            if (selected instanceof WebServiceConsumerNodePage) {
                p = (WebServiceConsumerNodePage)selected;
                buildJaxWsBean = ((WebServiceConsumerNodePage)p).getBuildJaxWsBean();
                wsdlResource = ((WebServiceConsumerNodePage)p).getWsdlResource();
            } else if (selected instanceof WebServiceProviderNodePage) {
                p = (WebServiceProviderNodePage)selected;
                buildJaxWsBean = ((WebServiceProviderNodePage)p).getBuildJaxWsBean();
                wsdlResource = ((WebServiceProviderNodePage)p).getWsdlResource();
            } else {
                return null;
            }
            try {
                schemaCandidate = GlobalBindingRegistrationHelper.popupForSchema(wsdlResource.getFile());
            }
            catch (CoreException e) {
                if (e.getStatus() == null || e.getStatus().getCode() != Status.CANCEL_STATUS.getCode()) break block9;
                return null;
            }
        }
        BindingFileCreateOperation op = new BindingFileCreateOperation();
        if (schemaCandidate != null) {
            SchemaUtility.WsdlArtifact<IFile> wsdlArtifact = schemaCandidate.getWsdlArtifact();
            if (wsdlArtifact.getInlineSchemas().length > 1) {
                op.setSchemaTargetNamespace(SchemaUtility.getSchemaTargetNamespace(schemaCandidate.getSchema()));
            }
            if (wsdlArtifact.getTypeEnum() == SchemaUtility.WsdlArtifact.TypeEnum.REFERENCED_WSDL) {
                op.setWsdlLocation((IFile)wsdlArtifact.getFileHandle().getFile());
            }
        }
        IPath bindingFilePath = JaxWsSdkUtility.toUniqueProjectRelativeBindingFilePath(this.m_bundle, buildJaxWsBean.getAlias(), op.getSchemaTargetNamespace());
        Map<String, List<String>> properties = buildJaxWsBean.getPropertiers();
        JaxWsSdkUtility.addBuildProperty(properties, "b", bindingFilePath.toString());
        op.setBundle(this.m_bundle);
        op.setProjectRelativePath(bindingFilePath);
        op.setWsdlDestinationFolder(JaxWsSdkUtility.getParentFolder(this.m_bundle, wsdlResource.getFile()));
        op.setCreateGlobalBindingSection(!JaxWsSdkUtility.containsGlobalBindingSection(this.m_bundle, properties, false));
        new OperationJob(new IOperation[]{op}).schedule();
        buildJaxWsBean.setProperties(properties);
        ResourceFactory.getBuildJaxWsResource(this.m_bundle).storeXmlAsync(buildJaxWsBean.getXml().getOwnerDocument(), 8, buildJaxWsBean.getAlias());
        return null;
    }
}

