/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.executor;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.marker.IMarkerRebuildListener;
import org.eclipse.scout.sdk.ws.jaxws.operation.WsStubGenerationOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.WsdlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.ErrorDialog;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceConsumerNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IOperationFinishedListener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class StubRebuildExecutor
extends AbstractExecutor {
    private IScoutBundle m_bundle;
    private String m_markerGroupUUID;
    private WebserviceEnum m_webserviceEnum;

    public boolean canRun(IStructuredSelection selection) {
        this.m_bundle = UiUtility.getScoutBundleFromSelection((IStructuredSelection)selection);
        return this.isEditable(this.m_bundle);
    }

    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        WsdlResource wsdlResource;
        BuildJaxWsBean buildJaxWsBean;
        IMarkerRebuildListener p;
        Object selected = selection.getFirstElement();
        if (selected instanceof WebServiceConsumerNodePage) {
            p = (WebServiceConsumerNodePage)selected;
            buildJaxWsBean = ((WebServiceConsumerNodePage)p).getBuildJaxWsBean();
            wsdlResource = ((WebServiceConsumerNodePage)p).getWsdlResource();
            this.m_markerGroupUUID = ((WebServiceConsumerNodePage)p).getMarkerGroupUUID();
            this.m_webserviceEnum = WebserviceEnum.CONSUMER;
        } else if (selected instanceof WebServiceProviderNodePage) {
            p = (WebServiceProviderNodePage)selected;
            buildJaxWsBean = ((WebServiceProviderNodePage)p).getBuildJaxWsBean();
            wsdlResource = ((WebServiceProviderNodePage)p).getWsdlResource();
            this.m_markerGroupUUID = ((WebServiceProviderNodePage)p).getMarkerGroupUUID();
            this.m_webserviceEnum = WebserviceEnum.PROVIDER;
        } else {
            return null;
        }
        IPath wsdlFolderPath = wsdlResource.getFile().getProjectRelativePath().removeLastSegments(1);
        WsStubGenerationOperation op = new WsStubGenerationOperation();
        op.setBundle(this.m_bundle);
        op.setAlias(buildJaxWsBean.getAlias());
        op.setWsdlFolder(JaxWsSdkUtility.getFolder(this.m_bundle, wsdlFolderPath, false));
        op.setProperties(buildJaxWsBean.getPropertiers());
        op.addOperationFinishedListener(new P_OperationFinishedListener());
        op.setWsdlFileName(wsdlResource.getFile().getName());
        OperationJob job = new OperationJob(new IOperation[]{op});
        job.setSystem(false);
        job.setUser(false);
        job.setPriority(20);
        job.schedule();
        return null;
    }

    private class P_OperationFinishedListener
    implements IOperationFinishedListener {
        private P_OperationFinishedListener() {
        }

        @Override
        public void operationFinished(final boolean success, final Throwable e) {
            if (StubRebuildExecutor.this.m_webserviceEnum == WebserviceEnum.PROVIDER) {
                JaxWsSdk.getDefault().notifyPageReload(WebServiceProviderNodePage.class, StubRebuildExecutor.this.m_markerGroupUUID, 16);
            } else {
                JaxWsSdk.getDefault().notifyPageReload(WebServiceConsumerNodePage.class, StubRebuildExecutor.this.m_markerGroupUUID, 8);
            }
            ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (success) {
                        MessageBox messageBox = new MessageBox(ScoutSdkUi.getShell(), 34);
                        messageBox.setMessage(Texts.get("WsStubSuccessfullyGenerated"));
                        messageBox.open();
                    } else {
                        ErrorDialog dialog = new ErrorDialog(Texts.get("StubGenerationFailed"));
                        dialog.setError(Texts.get("WsStubGenerationFailed"), e);
                        dialog.open();
                    }
                }
            });
        }
    }
}

