/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.BuildPropertiesWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.BuildProperty;
import org.w3c.dom.Document;

public class BuildPropertiesWizard
extends AbstractWorkspaceWizard {
    private IScoutBundle m_bundle;
    private BuildJaxWsBean m_buildJaxWsBean;
    private List<BuildProperty> m_properties;
    private BuildPropertiesWizardPage m_wizardPage;

    public BuildPropertiesWizard(IScoutBundle bundle, BuildJaxWsBean buildJaxWsBean) {
        this.setWindowTitle(Texts.get("WsBuildDirectives"));
        this.m_bundle = bundle;
        this.m_buildJaxWsBean = buildJaxWsBean;
        this.m_properties = this.loadProperties(this.m_buildJaxWsBean);
    }

    public void addPages() {
        this.m_wizardPage = new BuildPropertiesWizardPage();
        this.m_wizardPage.setProperties(this.m_properties);
        this.addPage((IWizardPage)this.m_wizardPage);
    }

    protected boolean beforeFinish() throws CoreException {
        this.m_properties = this.m_wizardPage.getProperties();
        return true;
    }

    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        HashMap<String, List<String>> propertyMap = new HashMap<String, List<String>>();
        for (BuildProperty property : this.m_properties) {
            if (!propertyMap.containsKey(property.getName())) {
                propertyMap.put(property.getName(), new LinkedList());
            }
            if (!StringUtility.hasText((CharSequence)property.getValue())) continue;
            ((List)propertyMap.get(property.getName())).add(property.getValue());
        }
        this.m_buildJaxWsBean.setProperties(propertyMap);
        Document xmlDocument = this.m_buildJaxWsBean.getXml().getOwnerDocument();
        ResourceFactory.getBuildJaxWsResource(this.m_bundle).storeXml(xmlDocument, 8, monitor, this.m_buildJaxWsBean.getAlias());
        return true;
    }

    private List<BuildProperty> loadProperties(BuildJaxWsBean buildJaxWsBean) {
        LinkedList<BuildProperty> properties = new LinkedList<BuildProperty>();
        for (Map.Entry<String, List<String>> entry : buildJaxWsBean.getPropertiers().entrySet()) {
            String name = entry.getKey();
            List<String> values = entry.getValue();
            if (values == null || values.size() == 0) {
                properties.add(new BuildProperty(entry.getKey(), null));
                continue;
            }
            for (String value : values) {
                properties.add(new BuildProperty(name, value));
            }
        }
        return properties;
    }
}

