/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.util.IFileHandle;

public class JavaFileHandle
implements IFileHandle<File> {
    private final File m_file;

    public JavaFileHandle(File file) {
        this.m_file = file;
    }

    @Override
    public IFileHandle<File> getParent() {
        return new JavaFileHandle(this.m_file.getParentFile());
    }

    @Override
    public InputStream getInputStream() {
        if (this.m_file.isFile()) {
            try {
                return new FileInputStream(this.m_file);
            }
            catch (FileNotFoundException e) {
                JaxWsSdk.logError(String.format("Failed to get InputStream of file '%s'", this.m_file.getName()), e);
            }
        }
        return null;
    }

    @Override
    public File getFile() {
        return this.m_file;
    }

    @Override
    public boolean exists() {
        return this.m_file.exists();
    }

    @Override
    public String getName() {
        return this.m_file.getName();
    }

    @Override
    public IPath getFullPath() {
        return new Path(this.m_file.getPath());
    }

    @Override
    public IFileHandle<File> getChild(IPath path) {
        if (path == null) {
            return null;
        }
        File child = this.getFullPath().append(path).toFile();
        if (child.exists()) {
            return new JavaFileHandle(child);
        }
        return null;
    }

    public int hashCode() {
        return this.m_file.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.m_file.equals(((JavaFileHandle)obj).m_file);
    }
}

