/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class ClassIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?>[] m_segments;
    private final int m_hash;

    public ClassIdentifier(Class<?> ... segments) throws IllegalArgumentException {
        if (segments == null || segments.length == 0) {
            throw new IllegalArgumentException("The given classes array must not be null or empty");
        }
        Class<?>[] classArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> segment = classArray[n2];
            if (segment == null) {
                throw new IllegalArgumentException("null segments are not allowed.");
            }
            ++n2;
        }
        this.m_segments = segments;
        this.m_hash = Arrays.hashCode(this.m_segments);
    }

    public Class<?>[] getClasses() {
        return Arrays.copyOf(this.m_segments, this.m_segments.length);
    }

    public Class<?> getLastSegment() {
        return this.m_segments[this.m_segments.length - 1];
    }

    public Class<?> getSegment(int i) {
        if (i < 0 || i >= this.m_segments.length) {
            throw new IllegalArgumentException("index out of bounds");
        }
        return this.m_segments[i];
    }

    public int size() {
        return this.m_segments.length;
    }

    public static ClassIdentifier[] convertClassArrayToClassIdentifierArray(Class<?> ... classes) {
        if (classes == null || classes.length == 0) {
            return new ClassIdentifier[0];
        }
        ArrayList<ClassIdentifier> result = new ArrayList<ClassIdentifier>();
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (c != null) {
                result.add(new ClassIdentifier(c));
            }
            ++n2;
        }
        return result.toArray(new ClassIdentifier[result.size()]);
    }

    public int hashCode() {
        return this.m_hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClassIdentifier)) {
            return false;
        }
        ClassIdentifier other = (ClassIdentifier)obj;
        return Arrays.equals(this.m_segments, other.m_segments);
    }

    public String toString() {
        return "ClassIdentifier [" + Arrays.toString(this.m_segments) + "]";
    }
}

