/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.internal.resolver;

import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.server.Invoker;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.api.server.WSWebServiceContext;
import com.sun.xml.internal.ws.server.AbstractMultiInstanceResolver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import javax.security.auth.Subject;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.holders.ObjectHolder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.jaxws.annotation.ScoutWebService;
import org.eclipse.scout.jaxws.internal.ContextHelper;
import org.eclipse.scout.jaxws.internal.SessionHelper;
import org.eclipse.scout.jaxws.session.IServerSessionFactory;
import org.eclipse.scout.rt.server.IServerJobFactory;
import org.eclipse.scout.rt.server.IServerJobService;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ITransactionRunnable;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.service.SERVICES;

public class ScoutInstanceResolver<T>
extends AbstractMultiInstanceResolver<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ScoutInstanceResolver.class);
    private IServerSessionFactory m_sessionFactory;

    public ScoutInstanceResolver(Class<T> portTypeClass) {
        super(portTypeClass);
        if (portTypeClass == null) {
            throw new WebServiceException("No port type class configured in sun-jaxws.xml");
        }
    }

    public void start(WSWebServiceContext context, WSEndpoint endpoint) {
        this.m_sessionFactory = this.createSessionFactory(this.clazz);
        super.start(context, endpoint);
    }

    public T resolve(Packet packet) {
        return (T)super.create();
    }

    protected IServerSessionFactory createSessionFactory(Class<?> portTypeClass) {
        ScoutWebService annotation = portTypeClass.getAnnotation(ScoutWebService.class);
        if (annotation == null) {
            return null;
        }
        try {
            return annotation.sessionFactory().newInstance();
        }
        catch (Exception e) {
            LOG.error("Error occured while creating session factory.", (Throwable)e);
            return null;
        }
    }

    protected IServerSession getSession(MessageContext context) {
        if (this.m_sessionFactory == null) {
            return null;
        }
        IServerSession contextSession = ContextHelper.getContextSession(context);
        Class<? extends IServerSessionFactory> contextSessionFactory = ContextHelper.getContextSessionFactoryClass(context);
        if (contextSession == null || !CompareUtility.equals(this.m_sessionFactory.getClass(), contextSessionFactory)) {
            return SessionHelper.createNewServerSession(this.m_sessionFactory);
        }
        return contextSession;
    }

    public Invoker createInvoker() {
        return new P_Invoker();
    }

    protected class P_Invoker
    extends Invoker {
        protected WSWebServiceContext m_context;

        protected P_Invoker() {
        }

        public void start(WSWebServiceContext context, WSEndpoint endpoint) {
            this.m_context = context;
            ScoutInstanceResolver.this.start(context, endpoint);
        }

        public void dispose() {
            this.m_context = null;
            ScoutInstanceResolver.this.dispose();
        }

        public Object invoke(Packet packet, final Method method, final Object ... aobj) throws InvocationTargetException, IllegalAccessException {
            final Object portType = ScoutInstanceResolver.this.resolve(packet);
            if (portType == null) {
                throw new WebServiceException("No port type found");
            }
            Subject subject = null;
            try {
                subject = Subject.getSubject(AccessController.getContext());
            }
            catch (Exception e) {
                LOG.error("Failed to get subject of calling access context", (Throwable)e);
            }
            if (subject == null) {
                throw new WebServiceException("Webservice request was NOT dispatched due to security reasons: request must run on behalf of a subject context.");
            }
            IServerSession session = ScoutInstanceResolver.this.getSession(this.m_context.getMessageContext());
            if (session == null) {
                LOG.warn("Webservice request is not run in a session context as no server session is configured.");
                return method.invoke(portType, aobj);
            }
            try {
                final ObjectHolder resultHolder = new ObjectHolder();
                final Holder invocationTargetExceptionHolder = new Holder(InvocationTargetException.class);
                final Holder illegalAccessExceptionHolder = new Holder(IllegalAccessException.class);
                final Holder runtimeExceptionHolder = new Holder(RuntimeException.class);
                IServerJobFactory jobFactory = ((IServerJobService)SERVICES.getService(IServerJobService.class)).createJobFactory(session, subject);
                ServerJob serverJob = jobFactory.create("Tx", new ITransactionRunnable(){

                    public IStatus run(IProgressMonitor monitor) throws ProcessingException {
                        try {
                            resultHolder.setValue(method.invoke(portType, aobj));
                        }
                        catch (InvocationTargetException e) {
                            Throwable cause = e.getCause();
                            ThreadContext.getTransaction().addFailure(cause);
                            if (cause instanceof RuntimeException) {
                                LOG.warn("Webservice processing exception occured. Please handle faults by respective checked SOAP faults.", cause);
                                invocationTargetExceptionHolder.setValue((Object)new InvocationTargetException((Throwable)new WebServiceException("Internal Server Error")));
                            } else {
                                LOG.info("Webservice processing exception occured.", cause);
                                invocationTargetExceptionHolder.setValue((Object)e);
                            }
                        }
                        catch (IllegalAccessException e) {
                            ThreadContext.getTransaction().addFailure((Throwable)e);
                            LOG.error("Illegal access exception occured while dispatching webservice request. This might be caused because of Java security settings.", (Throwable)e);
                            illegalAccessExceptionHolder.setValue((Object)e);
                        }
                        catch (RuntimeException e) {
                            ThreadContext.getTransaction().addFailure((Throwable)e);
                            LOG.error("Unexpected error occured while dispatching webservice request.", (Throwable)e);
                            runtimeExceptionHolder.setValue((Object)e);
                        }
                        return Status.OK_STATUS;
                    }
                });
                serverJob.setSystem(true);
                serverJob.runNow((IProgressMonitor)new NullProgressMonitor());
                if (invocationTargetExceptionHolder.getValue() != null) {
                    throw (InvocationTargetException)invocationTargetExceptionHolder.getValue();
                }
                if (illegalAccessExceptionHolder.getValue() != null) {
                    throw (IllegalAccessException)illegalAccessExceptionHolder.getValue();
                }
                if (runtimeExceptionHolder.getValue() != null) {
                    throw (RuntimeException)runtimeExceptionHolder.getValue();
                }
                Object object = resultHolder.getValue();
                return object;
            }
            finally {
                ScoutInstanceResolver.this.postInvoke(packet, portType);
            }
        }
    }
}

