/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.services.ui.wizard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.internal.ui.AbstractTextComposition;
import org.eclipse.scout.nls.sdk.internal.ui.NlsUi;
import org.eclipse.scout.nls.sdk.internal.ui.TextField;
import org.eclipse.scout.nls.sdk.internal.ui.fields.IInputChangedListener;
import org.eclipse.scout.nls.sdk.internal.ui.fields.TextProposalField;
import org.eclipse.scout.nls.sdk.internal.ui.formatter.IInputValidator;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.services.model.ws.NlsServiceType;
import org.eclipse.scout.nls.sdk.services.model.ws.project.ServiceNlsProjectProvider;
import org.eclipse.scout.nls.sdk.simple.internal.NlsSdkSimple;
import org.eclipse.scout.nls.sdk.simple.ui.wizard.ResourceProposalModel;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.javacode.EntityTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementAbstractTypeContentProvider;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.IRegEx;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.resources.IResourceFilter;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class NewTextProviderServiceWizardPage
extends AbstractWorkspaceWizardPage {
    private static final String PROP_TRANSLATION_FOLDER = "translationFolder";
    private static final String PROP_TRANSLATION_FILE = "translationFile";
    private static final String PROP_SUPER_TYPE = "superType";
    private static final String PROP_CLASS_NAME = "className";
    private static final String PROP_TARGET_PACKAGE = "targetPackage";
    private ProposalTextField m_superTypeField;
    private StyledTextField m_className;
    private TextProposalField m_translationFolderField;
    private TextField<String> m_translationFileName;
    private EntityTextField m_entityField;
    private final IScoutBundle m_bundle;
    private final Set<String> m_languagesToCreate;
    private final List<NlsServiceType> m_existingServicesInPlugin;
    private final IType m_defaultProposal;

    public NewTextProviderServiceWizardPage(IScoutBundle bundle) {
        super(NewTextProviderServiceWizardPage.class.getName());
        this.setTitle("Create a new Text Provider Service");
        this.setDescription("Creates a new Text Provider Service.");
        this.setTargetPackage(DefaultTargetPackage.get((IScoutBundle)bundle, (String)"shared.services.textprovider"));
        this.m_bundle = bundle;
        this.m_languagesToCreate = new HashSet<String>();
        this.m_existingServicesInPlugin = this.getTextProviderServicesInSamePlugin();
        this.m_defaultProposal = RuntimeClasses.getSuperType((String)"org.eclipse.scout.rt.shared.services.common.text.ITextProviderService", (IJavaProject)ScoutUtility.getJavaProject((IScoutBundle)bundle));
    }

    private List<NlsServiceType> getTextProviderServicesInSamePlugin() {
        try {
            Set<IType> candidates = ServiceNlsProjectProvider.getRegisteredTextProviderTypes();
            ArrayList<NlsServiceType> ret = new ArrayList<NlsServiceType>(candidates.size());
            for (IType t : candidates) {
                NlsServiceType type;
                if (!this.m_bundle.getProject().equals((Object)t.getJavaProject().getProject()) || (type = new NlsServiceType(t)).getTranslationsFolderName() == null) continue;
                ret.add(type);
            }
            return ret;
        }
        catch (JavaModelException e) {
            NlsCore.logWarning((Throwable)e);
            return null;
        }
    }

    public void createContent(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createServiceGroup(parent);
        this.createTranslationGroup(parent);
        this.createLanguagesGroup(parent);
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        this.m_translationFileName.setValue((Object)"Texts");
        this.m_translationFolderField.setText("resources/texts");
        this.m_languagesToCreate.add(null);
        this.m_superTypeField.acceptProposal((Object)this.m_defaultProposal);
        if (DefaultTargetPackage.isPackageConfigurationEnabled()) {
            this.m_entityField.setText(this.getTargetPackage());
        }
    }

    private void createServiceGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Text Provider Service Class");
        IType iTextProviderService = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.text.ITextProviderService");
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField((Composite)group, "Super Class", (AbstractJavaElementContentProvider)new JavaElementAbstractTypeContentProvider(iTextProviderService, ScoutUtility.getJavaProject((IScoutBundle)this.m_bundle), new IType[]{this.m_defaultProposal}));
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            public void proposalAccepted(ContentProposalEvent event) {
                NewTextProviderServiceWizardPage.this.setSuperTypeInternal((IType)event.proposal);
                NewTextProviderServiceWizardPage.this.pingStateChanging();
            }
        });
        this.m_className = this.getFieldToolkit().createStyledTextField((Composite)group, "Service Name");
        this.m_className.setReadOnlySuffix("TextProviderService");
        this.m_className.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewTextProviderServiceWizardPage.this.setClassNameInternal(NewTextProviderServiceWizardPage.this.m_className.getText());
                NewTextProviderServiceWizardPage.this.pingStateChanging();
            }
        });
        if (DefaultTargetPackage.isPackageConfigurationEnabled()) {
            this.m_entityField = this.getFieldToolkit().createEntityTextField((Composite)group, Texts.get((String)"EntityTextField"), this.m_bundle);
            this.m_entityField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewTextProviderServiceWizardPage.this.setTargetPackageInternal(NewTextProviderServiceWizardPage.this.m_entityField.getText());
                    NewTextProviderServiceWizardPage.this.pingStateChanging();
                }
            });
            this.attachGridData((Control)this.m_entityField);
        }
        group.setLayout((Layout)new GridLayout(1, true));
        this.attachGridData((Control)group);
        this.attachGridData((Control)this.m_superTypeField);
        this.attachGridData((Control)this.m_className);
    }

    private Control createTranslationGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Translations");
        ResourceProposalModel model = new ResourceProposalModel();
        model.setResourceFilter(new IResourceFilter(){

            public boolean accept(IResourceProxy proxy) {
                IResource resource = proxy.requestResource();
                if (resource instanceof IFolder) {
                    IFolder folder = (IFolder)resource;
                    IJavaProject jp = JavaCore.create((IProject)folder.getProject());
                    try {
                        if (jp.getOutputLocation().toOSString().equals(folder.getFullPath().toOSString())) {
                            return false;
                        }
                    }
                    catch (JavaModelException e) {
                        NlsCore.logWarning((Throwable)e);
                    }
                    return !"META-INF".equals(folder.getProjectRelativePath().toOSString());
                }
                return false;
            }
        });
        List projectList = new ArrayList();
        if (this.m_bundle.getProject() != null) {
            try {
                projectList = NlsSdkSimple.getProjectGroup((IProject)this.m_bundle.getProject());
            }
            catch (Exception e) {
                NlsCore.logWarning((Throwable)e);
            }
        }
        model.setProjects(projectList.toArray(new IProject[projectList.size()]));
        KeyStroke stoke = KeyStroke.getInstance((int)262144, (int)32);
        this.m_translationFolderField = new TextProposalField((Composite)group, (IContentProposalProvider)model, stoke);
        this.m_translationFolderField.setLabelText("Translations Folder");
        this.m_translationFolderField.setLabelProvider((ILabelProvider)model);
        this.m_translationFolderField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewTextProviderServiceWizardPage.this.setTranslationFolderInternal(NewTextProviderServiceWizardPage.this.m_translationFolderField.getText());
                NewTextProviderServiceWizardPage.this.pingStateChanging();
            }
        });
        NlsUi.decorate((AbstractTextComposition)this.m_translationFolderField, (boolean)false);
        this.m_translationFileName = new TextField((Composite)group, 8);
        this.m_translationFileName.setLabelText("Translation File Prefix");
        this.m_translationFileName.setToolTipText("e.g. messages for messages[_language].properties");
        this.m_translationFileName.addInputChangedListener((IInputChangedListener)new IInputChangedListener<String>(){

            public void inputChanged(String input) {
                NewTextProviderServiceWizardPage.this.setTranlationFileNameInternal(input);
                NewTextProviderServiceWizardPage.this.pingStateChanging();
            }
        });
        this.m_translationFileName.setInputValidator(new IInputValidator(){

            public IStatus isValid(String value) {
                if (IRegEx.JAVAFIELD.matcher(value).matches()) {
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        });
        group.setLayout((Layout)new GridLayout(1, true));
        this.attachGridData((Control)group);
        this.attachGridData((Control)this.m_translationFolderField);
        this.attachGridData((Control)this.m_translationFileName);
        return group;
    }

    private Control createLanguagesGroup(Composite parent) {
        String[][] langs;
        Group group = new Group(parent, 0);
        group.setText("Languages");
        String[][] stringArrayArray = new String[5][];
        String[] stringArray = new String[2];
        stringArray[0] = Language.LANGUAGE_DEFAULT.getLocale().getLanguage();
        stringArrayArray[0] = stringArray;
        stringArrayArray[1] = new String[]{"German", "de"};
        stringArrayArray[2] = new String[]{"French", "fr"};
        stringArrayArray[3] = new String[]{"Italian", "it"};
        stringArrayArray[4] = new String[]{"Spanish", "es"};
        String[][] stringArrayArray2 = langs = stringArrayArray;
        int n = langs.length;
        int n2 = 0;
        while (n2 < n) {
            final String[] entry = stringArrayArray2[n2];
            final Button chk = new Button((Composite)group, 32);
            chk.setText(entry[0]);
            chk.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (chk.getSelection()) {
                        NewTextProviderServiceWizardPage.this.m_languagesToCreate.add(entry[1]);
                    } else {
                        NewTextProviderServiceWizardPage.this.m_languagesToCreate.remove(entry[1]);
                    }
                    NewTextProviderServiceWizardPage.this.pingStateChanging();
                }
            });
            if (entry[1] == null) {
                chk.setEnabled(false);
                chk.setSelection(true);
            }
            this.attachGridData((Control)chk);
            ++n2;
        }
        group.setLayout((Layout)new GridLayout(5, true));
        this.attachGridData((Control)group);
        return group;
    }

    protected void validatePage(MultiStatus multiStatus) {
        if (StringUtility.isNullOrEmpty((CharSequence)this.getClassName())) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.nls.sdk.services", "The class name must be specified."));
        } else if (TypeUtility.existsType((String)(String.valueOf(this.m_bundle.getPackageName(this.getTargetPackage())) + "." + this.getClassName()))) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ui", "Name already used. Choose another name."));
        } else if (!IRegEx.JAVAFIELD.matcher(this.getClassName()).matches()) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.nls.sdk.services", "The service class name is invalid."));
        }
        if (StringUtility.isNullOrEmpty((CharSequence)this.getTranslationFolder())) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.nls.sdk.services", "The translation folder must be specified."));
        }
        if (StringUtility.isNullOrEmpty((CharSequence)this.getTranlationFileName())) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.nls.sdk.services", "The translation file name must be specified."));
        }
        if (this.m_existingServicesInPlugin != null) {
            for (NlsServiceType existing : this.m_existingServicesInPlugin) {
                if (!CompareUtility.equals((Object)NewTextProviderServiceWizardPage.cleanFolder(existing.getTranslationsFolderName()), (Object)NewTextProviderServiceWizardPage.cleanFolder(this.getTranslationFolder())) || !CompareUtility.equals((Object)existing.getTranslationsPrefix(), (Object)this.getTranlationFileName())) continue;
                multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.nls.sdk.services", "A service for the given translations does already exist."));
                break;
            }
        }
        multiStatus.add(ScoutUtility.validatePackageName((String)this.getTargetPackage()));
        multiStatus.add(Status.OK_STATUS);
    }

    private static String cleanFolder(String f) {
        if (f != null && f.startsWith("/")) {
            f = f.substring(1);
        }
        if (f != null && f.endsWith("/")) {
            f = f.substring(0, f.length() - 1);
        }
        return f;
    }

    private void attachGridData(Control c) {
        c.setLayoutData((Object)new GridData(768));
    }

    public void setClassName(String input) {
        try {
            this.setStateChanging(true);
            this.setClassNameInternal(input);
            if (this.isControlCreated()) {
                this.m_className.setText(input);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setClassNameInternal(String input) {
        if (!StringUtility.hasText((CharSequence)input)) {
            input = null;
        }
        this.setPropertyString(PROP_CLASS_NAME, input);
    }

    public String getClassName() {
        return this.getPropertyString(PROP_CLASS_NAME);
    }

    public void setTranslationFolder(String folder) {
        try {
            this.setStateChanging(true);
            this.setTranslationFolderInternal(folder);
            if (this.isControlCreated()) {
                this.m_translationFolderField.setText(folder);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTranslationFolderInternal(String folder) {
        this.setPropertyString(PROP_TRANSLATION_FOLDER, folder);
    }

    public String getTranslationFolder() {
        return this.getPropertyString(PROP_TRANSLATION_FOLDER);
    }

    public void setTranlationFileName(String filename) {
        try {
            this.setStateChanging(true);
            this.setTranlationFileNameInternal(filename);
            if (this.isControlCreated()) {
                this.m_translationFileName.setValue((Object)filename);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTranlationFileNameInternal(String filename) {
        this.setPropertyString(PROP_TRANSLATION_FILE, filename);
    }

    public String getTranlationFileName() {
        return this.getPropertyString(PROP_TRANSLATION_FILE);
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.setSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal((Object)superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setSuperTypeInternal(IType type) {
        this.setProperty(PROP_SUPER_TYPE, type);
    }

    public IType getSuperType() {
        return (IType)this.getProperty(PROP_SUPER_TYPE);
    }

    public String[] getLanguages() {
        return this.m_languagesToCreate.toArray(new String[this.m_languagesToCreate.size()]);
    }

    public String getTargetPackage() {
        return (String)this.getProperty(PROP_TARGET_PACKAGE);
    }

    public void setTargetPackage(String targetPackage) {
        try {
            this.setStateChanging(true);
            this.setTargetPackageInternal(targetPackage);
            if (this.isControlCreated() && this.m_entityField != null) {
                this.m_entityField.setText(targetPackage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTargetPackageInternal(String targetPackage) {
        this.setProperty(PROP_TARGET_PACKAGE, targetPackage);
    }
}

