/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.simple.ui.dialog.language;

import java.beans.PropertyChangeListener;
import java.util.Locale;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.nls.sdk.internal.jdt.INlsFolder;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.ITranslationLocationChooserModel;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.simple.model.ws.project.SimpleNlsProject;

public class TranslationFileNewModel
implements ITranslationLocationChooserModel {
    public static final String PROP_LANGUAGE_ISO = "language";
    public static final String PROP_LANGUAGE_COUNTRY_ISO = "languageCountry";
    public static final String PROP_LANGUAGE_VARIANT = "languageVariant";
    public static final String PROP_FOLDER = "location";
    public static final String PROP_PATH = "path";
    private final SimpleNlsProject m_nlsProject;
    private final BasicPropertySupport m_propertySupport;

    public TranslationFileNewModel(SimpleNlsProject project) {
        this.m_nlsProject = project;
        this.m_propertySupport = new BasicPropertySupport((Object)this);
        this.setPath((IPath)new Path(this.m_nlsProject.getNlsType().getTranslationsFolderName()));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
    }

    public SimpleNlsProject getNlsProject() {
        return this.m_nlsProject;
    }

    public IProject getProject() {
        return this.m_nlsProject.getNlsType().getType().getJavaProject().getProject();
    }

    public void setLanguageIso(String isoLanguage) {
        this.m_propertySupport.setPropertyString(PROP_LANGUAGE_ISO, isoLanguage);
    }

    public String getLanguageIso() {
        return this.m_propertySupport.getPropertyString(PROP_LANGUAGE_ISO);
    }

    public void setCountryIso(String isoCountry) {
        this.m_propertySupport.setPropertyString(PROP_LANGUAGE_COUNTRY_ISO, isoCountry);
    }

    public String getCountryIso() {
        return this.m_propertySupport.getPropertyString(PROP_LANGUAGE_COUNTRY_ISO);
    }

    public void setLanguageVariant(String languageVariant) {
        this.m_propertySupport.setPropertyString(PROP_LANGUAGE_VARIANT, languageVariant);
    }

    public String getLanguageVariant() {
        return this.m_propertySupport.getPropertyString(PROP_LANGUAGE_VARIANT);
    }

    public Language getLanguage() {
        String variant;
        String langIso = this.getLanguageIso();
        if (langIso == null) {
            return null;
        }
        String countryIso = this.getCountryIso();
        if (countryIso == null) {
            countryIso = "";
        }
        if ((variant = this.getLanguageVariant()) == null) {
            variant = "";
        }
        return new Language(new Locale(langIso, countryIso, variant));
    }

    public INlsFolder getFolder() {
        return (INlsFolder)this.m_propertySupport.getProperty(PROP_FOLDER);
    }

    public void setFolder(INlsFolder folder) {
        this.m_propertySupport.setProperty(PROP_FOLDER, (Object)folder);
    }

    public void setPath(IPath path) {
        this.m_propertySupport.setProperty(PROP_PATH, (Object)path);
    }

    public IPath getPath() {
        return (IPath)this.m_propertySupport.getProperty(PROP_PATH);
    }
}

