/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.model;

import java.util.List;
import java.util.Map;
import org.eclipse.scout.nls.sdk.internal.model.IReferenceProvider;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.search.ui.text.Match;

public class NlsReferenceProvider
implements IReferenceProvider {
    private final Map<String, List<Match>> m_matches;

    public NlsReferenceProvider(Map<String, List<Match>> matches) {
        this.m_matches = matches;
    }

    @Override
    public int getReferenceCount(INlsEntry entry) {
        if (this.m_matches.containsKey(entry.getKey())) {
            return this.m_matches.get(entry.getKey()).size();
        }
        return 0;
    }

    @Override
    public Match[] getReferences(INlsEntry entry) {
        if (this.m_matches.containsKey(entry.getKey())) {
            List<Match> list = this.m_matches.get(entry.getKey());
            return list.toArray(new Match[list.size()]);
        }
        return new Match[0];
    }
}

