/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.model.util;

import java.util.Locale;
import org.eclipse.scout.nls.sdk.internal.NlsCore;

public class Language {
    public static final Language LANGUAGE_DEFAULT = new Language(new Locale("default"));
    public static final Language LANGUAGE_KEY = new Language(new Locale("key"));
    private boolean m_isLocal;
    private final Locale m_locale;

    public Language(Locale locale) {
        if (locale == null) {
            IllegalArgumentException e = new IllegalArgumentException("locale cannot be null!");
            NlsCore.logError(e.getMessage(), e);
            throw e;
        }
        this.m_locale = locale;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public String getDispalyName() {
        if (this.m_locale == LANGUAGE_DEFAULT.getLocale()) {
            return "default";
        }
        return this.m_locale.getDisplayName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Language)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return this.m_locale.hashCode();
    }

    public String toString() {
        return this.getDispalyName();
    }

    public String getIsoCode() {
        return this.m_locale.toString();
    }

    public boolean isLocal() {
        return this.m_isLocal;
    }

    public void setLocal(boolean isLocal) {
        this.m_isLocal = isLocal;
    }
}

