/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action;

import java.security.Permission;
import java.util.List;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.ITypeWithClassId;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.Replace;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.action.ActionChains;
import org.eclipse.scout.rt.client.extension.ui.action.IActionExtension;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionUIFacade;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStrokeNormalizer;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractAction
extends AbstractPropertyObserver
implements IAction,
IExtensibleObject {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractAction.class);
    private boolean m_initialized;
    private final IActionUIFacade m_uiFacade = this.createUIFacade();
    private boolean m_inheritAccessibility;
    private boolean m_enabledGranted = true;
    private boolean m_enabledProperty;
    private boolean m_enabledProcessingAction = true;
    private boolean m_enabledInheritAccessibility = true;
    private boolean m_visibleProperty;
    private boolean m_visibleGranted = true;
    private boolean m_toggleAction;
    private boolean m_separator;
    private final ObjectExtensions<AbstractAction, IActionExtension<? extends AbstractAction>> m_objectExtensions = new ObjectExtensions((Object)this);

    public AbstractAction() {
        this(true);
    }

    public AbstractAction(boolean callInitializer) {
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected void callInitializer() {
        if (!this.m_initialized) {
            this.interceptInitConfig();
            this.m_initialized = true;
        }
    }

    @Override
    public final void initAction() throws ProcessingException {
        this.interceptInitAction();
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=30.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=40.0)
    protected String getConfiguredText() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=50.0)
    protected String getConfiguredTooltipText() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=55.0)
    protected String getConfiguredKeyStroke() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=10.0)
    protected boolean getConfiguredEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=20.0)
    protected boolean getConfiguredVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=22.0)
    protected boolean getConfiguredInheritAccessibility() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=25.0)
    protected boolean getConfiguredToggleAction() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    protected boolean getConfiguredSeparator() {
        return false;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=120.0)
    protected double getConfiguredViewOrder() {
        return 9.876543212345678E16;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitAction() throws ProcessingException {
    }

    @Deprecated
    @Order(value=20.0)
    protected void execPrepareAction() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=30.0)
    protected void execAction() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=32.0)
    protected void execSelectionChanged(boolean selection) throws ProcessingException {
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), new Runnable(){

            @Override
            public void run() {
                AbstractAction.this.initConfig();
            }
        });
    }

    protected void initConfig() {
        this.setIconId(this.getConfiguredIconId());
        this.setText(this.getConfiguredText());
        this.setTooltipText(this.getConfiguredTooltipText());
        this.setKeyStroke(this.getConfiguredKeyStroke());
        this.setInheritAccessibility(this.getConfiguredInheritAccessibility());
        this.setEnabled(this.getConfiguredEnabled());
        this.setVisible(this.getConfiguredVisible());
        this.setToggleAction(this.getConfiguredToggleAction());
        this.setSeparator(this.getConfiguredSeparator());
        this.setOrder(this.calculateViewOrder());
    }

    protected IActionUIFacade createUIFacade() {
        return new P_UIFacade();
    }

    protected IActionExtension<? extends AbstractAction> createLocalExtension() {
        return new LocalActionExtension<AbstractAction>(this);
    }

    public final List<? extends IActionExtension<? extends AbstractAction>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    @Override
    public int acceptVisitor(IActionVisitor visitor) {
        switch (visitor.visit(this)) {
            case 0: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 2: {
                return 0;
            }
        }
        return 1;
    }

    protected double calculateViewOrder() {
        double viewOrder = this.getConfiguredViewOrder();
        if (viewOrder == 9.876543212345678E16) {
            Class<?> cls = this.getClass();
            while (cls != null && IAction.class.isAssignableFrom(cls)) {
                if (cls.isAnnotationPresent(Order.class)) {
                    Order order = cls.getAnnotation(Order.class);
                    return order.value();
                }
                cls = cls.getSuperclass();
            }
        }
        return viewOrder;
    }

    @Override
    public Object getProperty(String name) {
        return this.propertySupport.getProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.propertySupport.setProperty(name, value);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertySupport.hasProperty(name);
    }

    @Override
    public String getActionId() {
        Class<?> c = this.getClass();
        while (c.isAnnotationPresent(Replace.class)) {
            c = c.getSuperclass();
        }
        String s = c.getName();
        int i = Math.max(s.lastIndexOf(36), s.lastIndexOf(46));
        s = s.substring(i + 1);
        return s;
    }

    @Override
    public void doAction() throws ProcessingException {
        if (this.isEnabled() && this.isVisible()) {
            try {
                this.setEnabledProcessingAction(false);
                this.doActionInternal();
            }
            finally {
                this.setEnabledProcessingAction(true);
            }
        }
    }

    protected void doActionInternal() throws ProcessingException {
        this.interceptAction();
    }

    @Override
    public String getIconId() {
        return this.propertySupport.getPropertyString("iconId");
    }

    @Override
    public void setIconId(String iconId) {
        this.propertySupport.setPropertyString("iconId", iconId);
    }

    @Override
    public String getText() {
        return this.propertySupport.getPropertyString("text");
    }

    @Override
    public String getTextWithMnemonic() {
        return this.propertySupport.getPropertyString("&text");
    }

    @Override
    public void setText(String text) {
        if (text != null) {
            this.propertySupport.setPropertyString("text", StringUtility.removeMnemonic((String)text));
            this.propertySupport.setPropertyString("&text", text);
            this.propertySupport.setProperty("mnemonic", (Object)Character.valueOf(StringUtility.getMnemonic((String)text)));
        } else {
            this.propertySupport.setPropertyString("text", null);
            this.propertySupport.setPropertyString("&text", null);
            this.propertySupport.setProperty("mnemonic", (Object)Character.valueOf('\u0000'));
        }
    }

    public double getOrder() {
        return this.propertySupport.getPropertyDouble("viewOrder");
    }

    public void setOrder(double order) {
        this.propertySupport.setPropertyDouble("viewOrder", order);
    }

    @Override
    public String getKeyStroke() {
        return this.propertySupport.getPropertyString("keystroke");
    }

    @Override
    public void setKeyStroke(String k) {
        KeyStrokeNormalizer scoutKeystroke = new KeyStrokeNormalizer(k);
        scoutKeystroke.normalize();
        if (scoutKeystroke.isValid()) {
            this.propertySupport.setPropertyString("keystroke", scoutKeystroke.getNormalizedKeystroke());
        } else {
            LOG.warn("Could not create keystroke '" + k + "' because it is invalid!");
        }
    }

    @Override
    public String getTooltipText() {
        return this.propertySupport.getPropertyString("tooltipText");
    }

    @Override
    public void setTooltipText(String text) {
        this.propertySupport.setPropertyString("tooltipText", text);
    }

    @Override
    public boolean isSeparator() {
        return this.m_separator;
    }

    @Override
    public void setSeparator(boolean b) {
        this.m_separator = b;
    }

    @Override
    public boolean isEnabled() {
        return this.propertySupport.getPropertyBool("enabled");
    }

    @Override
    public boolean isThisAndParentsEnabled() {
        if (!this.isEnabled()) {
            return false;
        }
        AbstractAction temp = this;
        while (temp instanceof IActionNode) {
            if ((temp = ((IActionNode)((Object)temp)).getParent()) == null) {
                return true;
            }
            if (temp.isEnabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setEnabled(boolean b) {
        this.m_enabledProperty = b;
        this.setEnabledInternal();
    }

    @Override
    public boolean isSelected() {
        return this.propertySupport.getPropertyBool("selected");
    }

    @Override
    public void setSelected(boolean b) {
        if (this.setSelectedInternal(b)) {
            try {
                this.interceptSelectionChanged(b);
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
    }

    protected boolean setSelectedInternal(boolean b) {
        return this.propertySupport.setPropertyBool("selected", b);
    }

    @Override
    public boolean isToggleAction() {
        return this.m_toggleAction;
    }

    @Override
    public void setToggleAction(boolean b) {
        this.m_toggleAction = b;
    }

    @Override
    public boolean isVisible() {
        return this.propertySupport.getPropertyBool("visible");
    }

    @Override
    public boolean isThisAndParentsVisible() {
        if (!this.isVisible()) {
            return false;
        }
        AbstractAction temp = this;
        while (temp instanceof IActionNode) {
            if ((temp = ((IActionNode)((Object)temp)).getParent()) == null) {
                return true;
            }
            if (temp.isVisible()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setVisible(boolean b) {
        this.m_visibleProperty = b;
        this.setVisibleInternal();
    }

    @Override
    public boolean isInheritAccessibility() {
        return this.m_inheritAccessibility;
    }

    @Override
    public void setInheritAccessibility(boolean b) {
        this.m_inheritAccessibility = b;
    }

    @Override
    public void setEnabledInheritAccessibility(boolean b) {
        this.m_enabledInheritAccessibility = b;
        this.setEnabledInternal();
    }

    @Override
    public boolean isEnabledInheritAccessibility() {
        return this.m_enabledInheritAccessibility;
    }

    @Override
    public void setEnabledPermission(Permission p) {
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : true;
        this.setEnabledGranted(b);
    }

    @Override
    public boolean isEnabledGranted() {
        return this.m_enabledGranted;
    }

    @Override
    public void setEnabledGranted(boolean b) {
        this.m_enabledGranted = b;
        this.setEnabledInternal();
    }

    @Override
    public boolean isEnabledProcessingAction() {
        return this.m_enabledProcessingAction;
    }

    @Override
    public void setEnabledProcessingAction(boolean b) {
        this.m_enabledProcessingAction = b;
        this.setEnabledInternal();
    }

    private void setEnabledInternal() {
        this.propertySupport.setPropertyBool("enabled", this.m_enabledGranted && this.m_enabledProperty && this.m_enabledProcessingAction && this.m_enabledInheritAccessibility);
    }

    @Override
    public void setVisiblePermission(Permission p) {
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : true;
        this.setVisibleGranted(b);
    }

    @Override
    public boolean isVisibleGranted() {
        return this.m_visibleGranted;
    }

    @Override
    public void setVisibleGranted(boolean b) {
        this.m_visibleGranted = b;
        this.setVisibleInternal();
    }

    private void setVisibleInternal() {
        this.propertySupport.setPropertyBool("visible", this.m_visibleGranted && this.m_visibleProperty);
    }

    public String classId() {
        String simpleClassId = ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass());
        if (this.getContainer() != null) {
            return String.valueOf(simpleClassId) + "_" + this.getContainer().classId();
        }
        return simpleClassId;
    }

    @Override
    public char getMnemonic() {
        Character c = (Character)this.propertySupport.getProperty("mnemonic");
        return c != null ? c.charValue() : (char)'\u0000';
    }

    public String combineKeyStrokes(String ... keys) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (builder.length() > 0) {
                builder.append("-");
            }
            builder.append(key);
            ++n2;
        }
        return builder.toString();
    }

    @Override
    @Deprecated
    public final void prepareAction() {
        try {
            this.prepareActionInternal();
            this.execPrepareAction();
        }
        catch (Throwable t) {
            LOG.warn("Action " + this.getClass().getName(), t);
        }
    }

    @Override
    public IActionUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    protected void prepareActionInternal() throws ProcessingException {
    }

    @Override
    public ITypeWithClassId getContainer() {
        return (ITypeWithClassId)this.propertySupport.getProperty("container");
    }

    @Override
    public void setContainerInternal(ITypeWithClassId container) {
        this.propertySupport.setProperty("container", (Object)container);
    }

    protected final void interceptSelectionChanged(boolean selection) throws ProcessingException {
        List<? extends IActionExtension<? extends AbstractAction>> extensions = this.getAllExtensions();
        ActionChains.ActionSelectionChangedChain chain = new ActionChains.ActionSelectionChangedChain(extensions);
        chain.execSelectionChanged(selection);
    }

    protected final void interceptAction() throws ProcessingException {
        List<? extends IActionExtension<? extends AbstractAction>> extensions = this.getAllExtensions();
        ActionChains.ActionActionChain chain = new ActionChains.ActionActionChain(extensions);
        chain.execAction();
    }

    protected final void interceptInitAction() throws ProcessingException {
        List<? extends IActionExtension<? extends AbstractAction>> extensions = this.getAllExtensions();
        ActionChains.ActionInitActionChain chain = new ActionChains.ActionInitActionChain(extensions);
        chain.execInitAction();
    }

    protected static class LocalActionExtension<OWNER extends AbstractAction>
    extends AbstractExtension<OWNER>
    implements IActionExtension<OWNER> {
        public LocalActionExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execSelectionChanged(ActionChains.ActionSelectionChangedChain chain, boolean selection) throws ProcessingException {
            ((AbstractAction)this.getOwner()).execSelectionChanged(selection);
        }

        @Override
        public void execAction(ActionChains.ActionActionChain chain) throws ProcessingException {
            ((AbstractAction)this.getOwner()).execAction();
        }

        @Override
        public void execInitAction(ActionChains.ActionInitActionChain chain) throws ProcessingException {
            ((AbstractAction)this.getOwner()).execInitAction();
        }
    }

    protected class P_UIFacade
    implements IActionUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void fireActionFromUI() {
            try {
                if (AbstractAction.this.isThisAndParentsEnabled() && AbstractAction.this.isThisAndParentsVisible()) {
                    AbstractAction.this.doAction();
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
            catch (Throwable e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected exception", e));
            }
        }

        @Override
        public void setSelectedFromUI(boolean b) {
            AbstractAction.this.setSelected(b);
        }
    }
}

