/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.listbox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.OrderedComparator;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.listbox.IListBoxExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.listbox.ListBoxChains;
import org.eclipse.scout.rt.client.services.lookup.FormFieldProvisioningContext;
import org.eclipse.scout.rt.client.services.lookup.ILookupCallProvisioningService;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTableRowBuilder;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRowFilter;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.CompositeFieldUtility;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBoxFilterBox;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.ActiveOrCheckedRowsFilter;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.CheckedRowsFilter;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.IListBox;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractValueFieldData;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

@ClassId(value="3dc8747d-19eb-4c0a-b5fc-c3dc2ad0783d")
public abstract class AbstractListBox<KEY>
extends AbstractValueField<Set<KEY>>
implements IListBox<KEY> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractListBox.class);
    private ITable m_table;
    private ILookupCall<KEY> m_lookupCall;
    private Class<? extends ICodeType<?, KEY>> m_codeTypeClass;
    private boolean m_valueTableSyncActive;
    private ITableRowFilter m_checkedRowsFilter;
    private ITableRowFilter m_activeRowsFilter;
    private List<IFormField> m_fields;
    private Map<Class<? extends IFormField>, IFormField> m_movedFormFieldsByClass;

    public AbstractListBox() {
        this(true);
    }

    public AbstractListBox(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="LOOKUP_CALL")
    @Order(value=240.0)
    @ValidationRule(value="lookupCall")
    protected Class<? extends ILookupCall<KEY>> getConfiguredLookupCall() {
        return null;
    }

    @ConfigProperty(value="CODE_TYPE")
    @Order(value=250.0)
    @ValidationRule(value="codeType")
    protected Class<? extends ICodeType<?, KEY>> getConfiguredCodeType() {
        return null;
    }

    @Override
    @Order(value=210.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredAutoAddDefaultMenus() {
        return false;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=230.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=260.0)
    protected boolean getConfiguredAutoLoad() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    protected boolean getConfiguredFilterActiveRows() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=280.0)
    protected boolean getConfiguredFilterCheckedRows() {
        return false;
    }

    @Override
    protected double getConfiguredGridWeightY() {
        return 1.0;
    }

    private List<Class<IFormField>> getConfiguredFields() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClasses((Class[])dca, IFormField.class);
    }

    @Override
    protected boolean execIsEmpty() throws ProcessingException {
        return this.getValue().isEmpty();
    }

    @ConfigOperation
    @Order(value=250.0)
    protected void execPrepareLookup(ILookupCall<KEY> call) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=260.0)
    protected void execFilterLookupResult(ILookupCall<KEY> call, List<ILookupRow<KEY>> result) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=230.0)
    protected List<? extends ILookupRow<KEY>> execLoadTableData() throws ProcessingException {
        List<ILookupRow<KEY>> data;
        if (this.getLookupCall() != null) {
            ILookupCall<KEY> call = ((ILookupCallProvisioningService)SERVICES.getService(ILookupCallProvisioningService.class)).newClonedInstance(this.getLookupCall(), new FormFieldProvisioningContext(this));
            this.prepareLookupCall(call);
            data = call.getDataByAll();
            data = this.filterLookupResult(call, data);
        } else {
            data = this.filterLookupResult(null, null);
        }
        return data;
    }

    @ConfigOperation
    @Order(value=240.0)
    protected void execPopulateTable() throws ProcessingException {
        List<ILookupRow<KEY>> data = null;
        if (!this.isMasterRequired() || this.getMasterValue() != null) {
            data = this.interceptLoadTableData();
        }
        ArrayList<ITableRow> rows = new ArrayList<ITableRow>();
        if (data != null) {
            for (ILookupRow<KEY> lr : data) {
                rows.add(this.getTableRowBuilder().createTableRow(lr));
            }
        }
        this.getTable().replaceRows(rows);
    }

    private Class<? extends ITable> getConfiguredTable() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List tableClasses = ConfigurationUtility.filterClasses((Class[])dca, ITable.class);
        if (tableClasses.size() == 1) {
            return (Class)CollectionUtility.firstElement((List)tableClasses);
        }
        for (Class tableClazz : tableClasses) {
            if (tableClazz.getDeclaringClass() == AbstractListBox.class) continue;
            return tableClazz;
        }
        return null;
    }

    @Override
    protected void execChangedMasterValue(Object newMasterValue) throws ProcessingException {
        this.setValue(null);
        this.loadListBoxData();
    }

    @Override
    protected void initConfig() {
        this.m_fields = CollectionUtility.emptyArrayList();
        this.m_movedFormFieldsByClass = new HashMap<Class<? extends IFormField>, IFormField>();
        super.initConfig();
        this.setFilterActiveRows(this.getConfiguredFilterActiveRows());
        this.setFilterActiveRowsValue(TriState.TRUE);
        this.setFilterCheckedRows(this.getConfiguredFilterCheckedRows());
        this.setFilterCheckedRowsValue(this.getConfiguredFilterCheckedRows());
        try {
            Class<ITable> configuredTable;
            List contributedTables = this.m_contributionHolder.getContributionsByClass(ITable.class);
            this.m_table = (ITable)CollectionUtility.firstElement((List)contributedTables);
            if (this.m_table == null && (configuredTable = this.getConfiguredTable()) != null) {
                this.m_table = (ITable)ConfigurationUtility.newInnerInstance((Object)this, configuredTable);
            }
            if (this.m_table != null) {
                if (this.m_table instanceof AbstractTable) {
                    ((AbstractTable)this.m_table).setContainerInternal(this);
                }
                this.updateActiveRowsFilter();
                this.updateCheckedRowsFilter();
                this.m_table.addTableListener(new TableAdapter(){

                    @Override
                    public void tableChanged(TableEvent e) {
                        switch (e.getType()) {
                            case 103: {
                                if (AbstractListBox.this.getTable().isCheckable()) break;
                                AbstractListBox.this.syncTableToValue();
                                break;
                            }
                            case 101: {
                                if (!AbstractListBox.this.getTable().isCheckable()) break;
                                AbstractListBox.this.syncTableToValue();
                            }
                        }
                    }
                });
                if (this.m_table.getDefaultIconId() == null && this.getConfiguredIconId() != null) {
                    this.m_table.setDefaultIconId(this.getConfiguredIconId());
                }
                this.m_table.setEnabled(this.isEnabled());
            } else {
                LOG.warn("there is no inner class of type ITable in " + this.getClass().getName());
            }
        }
        catch (Exception e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + this.getConfiguredTable().getName() + "'.", (Throwable)e));
        }
        if (this.getConfiguredLookupCall() != null) {
            try {
                ILookupCall<KEY> call = this.getConfiguredLookupCall().newInstance();
                this.setLookupCall(call);
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + this.getConfiguredLookupCall().getName() + "'.", (Throwable)e));
            }
        }
        if (this.getConfiguredCodeType() != null) {
            this.setCodeTypeClass(this.getConfiguredCodeType());
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (AbstractListBox.this.m_table != null) {
                    String name = e.getPropertyName();
                    if ("enabled".equals(name)) {
                        AbstractListBox.this.m_table.setEnabled(AbstractListBox.this.isEnabled());
                    } else if ("filterCheckedRowsValue".equals(name)) {
                        AbstractListBox.this.updateCheckedRowsFilter();
                    } else if ("filterActiveRowsValue".equals(name)) {
                        AbstractListBox.this.updateActiveRowsFilter();
                    }
                }
            }
        });
        List<Class<IFormField>> fieldClasses = this.getConfiguredFields();
        List contributedFields = this.m_contributionHolder.getContributionsByClass(IFormField.class);
        ArrayList<IFormField> fieldList = new ArrayList<IFormField>(fieldClasses.size() + contributedFields.size());
        for (Class<IFormField> fieldClazz : fieldClasses) {
            try {
                IFormField f = (IFormField)ConfigurationUtility.newInnerInstance((Object)this, fieldClazz);
                fieldList.add(f);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + fieldClazz.getName() + "'.", t));
            }
        }
        fieldList.addAll(contributedFields);
        Collections.sort(fieldList, new OrderedComparator());
        for (IFormField f : fieldList) {
            f.setParentFieldInternal(this);
        }
        this.m_fields = fieldList;
    }

    @Override
    public void addField(IFormField f) {
        CompositeFieldUtility.addField(f, this, this.m_fields);
    }

    @Override
    public void removeField(IFormField f) {
        CompositeFieldUtility.removeField(f, this, this.m_fields);
    }

    @Override
    public void moveFieldTo(IFormField f, ICompositeField newContainer) {
        CompositeFieldUtility.moveFieldTo(f, this, newContainer, this.m_movedFormFieldsByClass);
    }

    @Override
    public Map<Class<? extends IFormField>, IFormField> getMovedFields() {
        return Collections.unmodifiableMap(this.m_movedFormFieldsByClass);
    }

    public ListBoxFilterBox getListBoxFilterBox() {
        return this.getFieldByClass((Class)ListBoxFilterBox.class);
    }

    @Override
    protected void initFieldInternal() throws ProcessingException {
        this.getTable().initTable();
        if (this.getConfiguredAutoLoad()) {
            try {
                this.setValueChangeTriggerEnabled(false);
                this.loadListBoxData();
            }
            finally {
                this.setValueChangeTriggerEnabled(true);
            }
        }
        super.initFieldInternal();
    }

    @Override
    protected void disposeFieldInternal() {
        super.disposeFieldInternal();
        this.getTable().disposeTable();
    }

    public AbstractTableRowBuilder<KEY> getTableRowBuilder() {
        return new P_TableRowBuilder();
    }

    @Override
    public final ITable getTable() {
        return this.m_table;
    }

    @Override
    public boolean isFilterCheckedRows() {
        return this.propertySupport.getPropertyBool("filterCheckedRows");
    }

    @Override
    public void setFilterCheckedRows(boolean b) {
        this.propertySupport.setPropertyBool("filterCheckedRows", b);
    }

    @Override
    public boolean getFilterCheckedRowsValue() {
        return this.propertySupport.getPropertyBool("filterCheckedRowsValue");
    }

    @Override
    public void setFilterCheckedRowsValue(boolean b) {
        this.propertySupport.setPropertyBool("filterCheckedRowsValue", b);
    }

    @Override
    public boolean isFilterActiveRows() {
        return this.propertySupport.getPropertyBool("filterActiveRows");
    }

    @Override
    public void setFilterActiveRows(boolean b) {
        this.propertySupport.setPropertyBool("filterActiveRows", b);
    }

    @Override
    public TriState getFilterActiveRowsValue() {
        return (TriState)this.propertySupport.getProperty("filterActiveRowsValue");
    }

    @Override
    public void setFilterActiveRowsValue(TriState t) {
        if (t == null) {
            t = TriState.TRUE;
        }
        this.propertySupport.setProperty("filterActiveRowsValue", (Object)t);
    }

    private void updateActiveRowsFilter() {
        try {
            this.getTable().setTableChanging(true);
            if (this.m_activeRowsFilter != null) {
                this.getTable().removeRowFilter(this.m_activeRowsFilter);
                this.m_activeRowsFilter = null;
            }
            this.m_activeRowsFilter = new ActiveOrCheckedRowsFilter(this.getActiveColumnInternal(), this.getFilterActiveRowsValue());
            this.getTable().addRowFilter(this.m_activeRowsFilter);
        }
        finally {
            this.getTable().setTableChanging(false);
        }
    }

    private void updateCheckedRowsFilter() {
        try {
            this.getTable().setTableChanging(true);
            if (this.m_checkedRowsFilter != null) {
                this.getTable().removeRowFilter(this.m_checkedRowsFilter);
                this.m_checkedRowsFilter = null;
            }
            if (this.getFilterCheckedRowsValue()) {
                this.m_checkedRowsFilter = new CheckedRowsFilter();
                this.getTable().addRowFilter(this.m_checkedRowsFilter);
            }
        }
        finally {
            this.getTable().setTableChanging(false);
        }
    }

    @Override
    public void loadListBoxData() throws ProcessingException {
        if (this.getTable() != null) {
            try {
                this.m_valueTableSyncActive = true;
                this.getTable().setTableChanging(true);
                this.interceptPopulateTable();
            }
            finally {
                this.getTable().setTableChanging(false);
                this.m_valueTableSyncActive = false;
            }
            this.syncValueToTable();
        }
    }

    @Override
    public final void prepareLookupCall(ILookupCall<KEY> call) throws ProcessingException {
        this.prepareLookupCallInternal(call);
        this.interceptPrepareLookup(call);
    }

    private List<ILookupRow<KEY>> filterLookupResult(ILookupCall<KEY> call, List<? extends ILookupRow<KEY>> data) throws ProcessingException {
        ArrayList result = CollectionUtility.arrayList(data);
        this.interceptFilterLookupResult(call, result);
        Iterator resultIt = result.iterator();
        while (resultIt.hasNext()) {
            ILookupRow row = (ILookupRow)resultIt.next();
            if (row == null) {
                resultIt.remove();
                continue;
            }
            if (row.getKey() != null) continue;
            LOG.warn("The key of a lookup row may not be null. Row has been removed for list box '" + this.getClass().getName() + "'.");
            resultIt.remove();
        }
        return result;
    }

    private void prepareLookupCallInternal(ILookupCall<KEY> call) {
        call.setActive(TriState.UNDEFINED);
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
    }

    @Override
    public final ILookupCall<KEY> getLookupCall() {
        return this.m_lookupCall;
    }

    @Override
    public void setLookupCall(ILookupCall<KEY> call) {
        this.m_lookupCall = call;
    }

    @Override
    public Class<? extends ICodeType<?, KEY>> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    @Override
    public void setCodeTypeClass(Class<? extends ICodeType<?, KEY>> codeTypeClass) {
        this.m_codeTypeClass = codeTypeClass;
        this.m_lookupCall = null;
        if (this.m_codeTypeClass != null) {
            this.m_lookupCall = CodeLookupCall.newInstanceByService(this.m_codeTypeClass);
        }
    }

    @Override
    protected void valueChangedInternal() {
        super.valueChangedInternal();
        this.syncValueToTable();
    }

    @Override
    protected String formatValueInternal(Set<KEY> validValue) {
        if (!CollectionUtility.hasElements(validValue)) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        List<ITableRow> rows = this.getKeyColumnInternal().findRows((KEY)validValue);
        if (CollectionUtility.hasElements(rows)) {
            Iterator<ITableRow> rowIt = rows.iterator();
            b.append(this.getTextColumnInternal().getValue(rowIt.next()));
            while (rowIt.hasNext()) {
                b.append(", ");
                b.append(this.getTextColumnInternal().getValue(rowIt.next()));
            }
        }
        return b.toString();
    }

    @Override
    protected final Set<KEY> validateValueInternal(Set<KEY> rawValue0) throws ProcessingException {
        HashSet rawValue = CollectionUtility.hashSet(rawValue0);
        return this.doValidateValueInternal(rawValue);
    }

    protected Set<KEY> doValidateValueInternal(Set<KEY> rawValue) throws ProcessingException {
        if (CollectionUtility.isEmpty(rawValue)) {
            return rawValue;
        }
        ITable table = this.getTable();
        if (table != null && (table.isCheckable() && !table.isMultiCheck() || !table.isCheckable() && !table.isMultiSelect()) && rawValue.size() > 1) {
            LOG.warn(String.valueOf(this.getClass().getName()) + " only accepts a single value. Got " + CollectionUtility.format(rawValue) + ". Using only first value.");
            return CollectionUtility.hashSet((Object)CollectionUtility.firstElement(rawValue));
        }
        return rawValue;
    }

    @Override
    public boolean isContentValid() {
        boolean valid = super.isContentValid();
        if (valid && this.isMandatory() && this.getValue().isEmpty()) {
            return false;
        }
        return valid;
    }

    @Override
    public Set<KEY> getValue() {
        return CollectionUtility.hashSet((Collection)((Collection)super.getValue()));
    }

    @Override
    public Set<KEY> getInitValue() {
        return CollectionUtility.hashSet((Collection)((Collection)super.getInitValue()));
    }

    @Override
    public KEY getSingleValue() {
        return (KEY)CollectionUtility.firstElement((Collection)((Collection)super.getValue()));
    }

    @Override
    public void setSingleValue(KEY value) {
        HashSet<KEY> valueSet = new HashSet<KEY>();
        if (value != null) {
            valueSet.add(value);
        }
        this.setValue(valueSet);
    }

    @Override
    public int getCheckedKeyCount() {
        return this.getValue().size();
    }

    @Override
    public KEY getCheckedKey() {
        return (KEY)CollectionUtility.firstElement(this.getCheckedKeys());
    }

    @Override
    public Set<KEY> getCheckedKeys() {
        return this.getValue();
    }

    @Override
    public ILookupRow<KEY> getCheckedLookupRow() {
        return (ILookupRow)CollectionUtility.firstElement(this.getCheckedLookupRows());
    }

    @Override
    public Set<ILookupRow<KEY>> getCheckedLookupRows() {
        Collection<ITableRow> checkedRows = this.getTable().getCheckedRows();
        HashSet<ILookupRow<KEY>> result = new HashSet<ILookupRow<KEY>>(checkedRows.size());
        for (ITableRow row : checkedRows) {
            ICell cell = row.getCell(1);
            result.add((ILookupRow<KEY>)new LookupRow(row.getCellValue(0), cell.getText(), cell.getIconId(), cell.getTooltipText(), cell.getBackgroundColor(), cell.getForegroundColor(), cell.getFont(), cell.isEnabled()));
        }
        return result;
    }

    @Override
    public void checkKey(KEY key) {
        if (key == null) {
            this.checkKeys(null);
        } else {
            this.checkKeys(CollectionUtility.hashSet(key));
        }
    }

    @Override
    public void checkKeys(Collection<? extends KEY> keys) {
        this.setValue(CollectionUtility.hashSetWithoutNullElements(keys));
    }

    @Override
    public void setFormInternal(IForm form) {
        super.setFormInternal(form);
        this.getListBoxFilterBox().setFormInternal(form);
    }

    @Override
    public void uncheckAllKeys() {
        this.checkKeys(null);
    }

    @Override
    public Set<KEY> getUncheckedKeys() {
        Set<KEY> checkedKeys;
        HashSet result = new HashSet();
        Object initValue = this.getInitValue();
        if (initValue != null) {
            result.addAll(initValue);
        }
        if ((checkedKeys = this.getCheckedKeys()) != null) {
            result.removeAll(checkedKeys);
        }
        return result;
    }

    @Override
    public void checkAllKeys() {
        this.checkKeys(this.getKeyColumnInternal().getValues());
    }

    @Override
    public void checkAllActiveKeys() {
        this.checkKeys(this.getKeyColumnInternal().getValues(this.getActiveColumnInternal().findRows(true)));
    }

    @Override
    public void uncheckAllInactiveKeys() {
        this.checkKeys(this.getKeyColumnInternal().getValues(this.getActiveColumnInternal().findRows(false)));
    }

    @Override
    public void exportFormFieldData(AbstractFormFieldData target) throws ProcessingException {
        AbstractValueFieldData v = (AbstractValueFieldData)target;
        Object value = this.getValue();
        if (CollectionUtility.isEmpty((Collection)value)) {
            v.setValue(null);
        } else {
            v.setValue((Object)CollectionUtility.hashSet((Collection)this.getValue()));
        }
    }

    private IColumn<KEY> getKeyColumnInternal() {
        return this.getTable().getColumnSet().getColumn(0);
    }

    private IColumn<String> getTextColumnInternal() {
        return this.getTable().getColumnSet().getColumn(1);
    }

    private IColumn<Boolean> getActiveColumnInternal() {
        return this.getTable().getColumnSet().getColumn(2);
    }

    private void syncValueToTable() {
        if (this.m_valueTableSyncActive) {
            return;
        }
        try {
            this.m_valueTableSyncActive = true;
            this.getTable().setTableChanging(true);
            Set<KEY> checkedKeys = this.getCheckedKeys();
            List<ITableRow> checkedRows = this.getKeyColumnInternal().findRows((KEY)checkedKeys);
            for (ITableRow row : this.getTable().getRows()) {
                row.setChecked(false);
            }
            for (ITableRow row : checkedRows) {
                row.setChecked(true);
            }
            if (!this.getTable().isCheckable()) {
                this.getTable().selectRows(checkedRows, false);
            }
        }
        finally {
            this.getTable().setTableChanging(false);
            this.m_valueTableSyncActive = false;
        }
    }

    private void syncTableToValue() {
        if (this.m_valueTableSyncActive) {
            return;
        }
        try {
            this.m_valueTableSyncActive = true;
            this.m_table.setTableChanging(true);
            Collection<ITableRow> checkedRows = this.getTable().isCheckable() ? this.getTable().getCheckedRows() : this.getTable().getSelectedRows();
            this.checkKeys(this.getKeyColumnInternal().getValues(checkedRows));
            if (!this.getTable().isCheckable()) {
                for (ITableRow row : this.m_table.getRows()) {
                    row.setChecked(row.isSelected());
                }
            }
        }
        finally {
            this.getTable().setTableChanging(false);
            this.m_valueTableSyncActive = false;
        }
        if (!this.m_table.getUIFacade().isUIProcessing()) {
            this.updateActiveRowsFilter();
        }
        this.updateCheckedRowsFilter();
    }

    public <F extends IFormField> F getFieldByClass(Class<F> c) {
        return CompositeFieldUtility.getFieldByClass(this, c);
    }

    @Override
    public IFormField getFieldById(String id) {
        return CompositeFieldUtility.getFieldById(this, id);
    }

    public <X extends IFormField> X getFieldById(String id, Class<X> type) {
        return CompositeFieldUtility.getFieldById(this, id, type);
    }

    @Override
    public int getFieldCount() {
        return this.m_fields.size();
    }

    @Override
    public int getFieldIndex(IFormField f) {
        return this.m_fields.indexOf(f);
    }

    @Override
    public List<IFormField> getFields() {
        return CollectionUtility.arrayList(this.m_fields);
    }

    @Override
    public boolean visitFields(IFormFieldVisitor visitor, int startLevel) {
        if (!visitor.visitField(this, startLevel, 0)) {
            return false;
        }
        int index = 0;
        for (IFormField field : this.m_fields) {
            if (field instanceof ICompositeField ? !((ICompositeField)field).visitFields(visitor, startLevel + 1) : !visitor.visitField(field, startLevel, index)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    @Override
    public final int getGridColumnCount() {
        return 1;
    }

    @Override
    public final int getGridRowCount() {
        return 1;
    }

    @Override
    public void rebuildFieldGrid() {
        GridData gd = this.getListBoxFilterBox().getGridDataHints();
        gd.x = 0;
        gd.y = 0;
        this.getListBoxFilterBox().setGridDataInternal(gd);
    }

    protected final void interceptPopulateTable() throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ListBoxChains.ListBoxPopulateTableChain chain = new ListBoxChains.ListBoxPopulateTableChain(extensions);
        chain.execPopulateTable();
    }

    protected final List<? extends ILookupRow<KEY>> interceptLoadTableData() throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ListBoxChains.ListBoxLoadTableDataChain chain = new ListBoxChains.ListBoxLoadTableDataChain(extensions);
        return chain.execLoadTableData();
    }

    protected final void interceptFilterLookupResult(ILookupCall<KEY> call, List<ILookupRow<KEY>> result) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ListBoxChains.ListBoxFilterLookupResultChain<KEY> chain = new ListBoxChains.ListBoxFilterLookupResultChain<KEY>(extensions);
        chain.execFilterLookupResult(call, result);
    }

    protected final void interceptPrepareLookup(ILookupCall<KEY> call) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ListBoxChains.ListBoxPrepareLookupChain<KEY> chain = new ListBoxChains.ListBoxPrepareLookupChain<KEY>(extensions);
        chain.execPrepareLookup(call);
    }

    @Override
    protected IListBoxExtension<KEY, ? extends AbstractListBox<KEY>> createLocalExtension() {
        return new LocalListBoxExtension(this);
    }

    public class DefaultListBoxTable
    extends AbstractTable {
        @Override
        protected boolean getConfiguredAutoResizeColumns() {
            return true;
        }

        @Override
        protected boolean getConfiguredHeaderVisible() {
            return false;
        }

        @Override
        protected boolean getConfiguredMultiSelect() {
            return false;
        }

        @Override
        protected boolean getConfiguredCheckable() {
            return true;
        }

        public org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox$DefaultListBoxTable.KeyColumn getKeyColumn() {
            return this.getColumnSet().getColumnByClass(KeyColumn.class);
        }

        public org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox$DefaultListBoxTable.TextColumn getTextColumn() {
            return this.getColumnSet().getColumnByClass(TextColumn.class);
        }

        public org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox$DefaultListBoxTable.ActiveColumn getActiveColumn() {
            return this.getColumnSet().getColumnByClass(ActiveColumn.class);
        }

        @Order(value=3.0)
        public class ActiveColumn
        extends AbstractBooleanColumn {
            @Override
            protected boolean getConfiguredDisplayable() {
                return false;
            }
        }

        @Order(value=1.0)
        public class KeyColumn
        extends AbstractColumn<KEY> {
            @Override
            protected boolean getConfiguredPrimaryKey() {
                return true;
            }

            @Override
            protected boolean getConfiguredDisplayable() {
                return false;
            }

            @Override
            public Class<KEY> getDataType() {
                return TypeCastUtility.getGenericsParameterClass(AbstractListBox.this.getClass(), IListBox.class);
            }
        }

        @Order(value=2.0)
        public class TextColumn
        extends AbstractStringColumn {
        }
    }

    @Order(value=1.0)
    public class ListBoxFilterBox
    extends AbstractListBoxFilterBox {
        @Override
        protected IListBox getListBox() {
            return AbstractListBox.this;
        }
    }

    protected static class LocalListBoxExtension<KEY, OWNER extends AbstractListBox<KEY>>
    extends AbstractValueField.LocalValueFieldExtension<Set<KEY>, OWNER>
    implements IListBoxExtension<KEY, OWNER> {
        public LocalListBoxExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execPopulateTable(ListBoxChains.ListBoxPopulateTableChain<KEY> chain) throws ProcessingException {
            ((AbstractListBox)this.getOwner()).execPopulateTable();
        }

        @Override
        public List<? extends ILookupRow<KEY>> execLoadTableData(ListBoxChains.ListBoxLoadTableDataChain<KEY> chain) throws ProcessingException {
            return ((AbstractListBox)this.getOwner()).execLoadTableData();
        }

        @Override
        public void execFilterLookupResult(ListBoxChains.ListBoxFilterLookupResultChain<KEY> chain, ILookupCall<KEY> call, List<ILookupRow<KEY>> result) throws ProcessingException {
            ((AbstractListBox)this.getOwner()).execFilterLookupResult(call, result);
        }

        @Override
        public void execPrepareLookup(ListBoxChains.ListBoxPrepareLookupChain<KEY> chain, ILookupCall<KEY> call) throws ProcessingException {
            ((AbstractListBox)this.getOwner()).execPrepareLookup(call);
        }
    }

    private class P_TableRowBuilder
    extends AbstractTableRowBuilder<KEY> {
        private P_TableRowBuilder() {
        }

        @Override
        protected ITableRow createEmptyTableRow() {
            return new TableRow(AbstractListBox.this.getTable().getColumnSet());
        }

        @Override
        public ITableRow createTableRow(ILookupRow<KEY> dataRow) throws ProcessingException {
            TableRow tableRow = (TableRow)super.createTableRow(dataRow);
            AbstractListBox.this.getKeyColumnInternal().setValue(tableRow, dataRow.getKey());
            AbstractListBox.this.getTextColumnInternal().setValue(tableRow, dataRow.getText());
            AbstractListBox.this.getActiveColumnInternal().setValue(tableRow, Boolean.valueOf(dataRow.isActive()));
            Cell cell = tableRow.getCellForUpdate(1);
            cell.setEnabled(dataRow.isEnabled());
            if (!dataRow.isActive()) {
                if (cell.getFont() == null) {
                    cell.setFont(FontSpec.parse((String)"italic"));
                }
                AbstractListBox.this.getTextColumnInternal().setValue(tableRow, String.valueOf(dataRow.getText()) + " (" + ScoutTexts.get((String)"InactiveState", (String[])new String[0]) + ")");
            }
            return tableRow;
        }
    }
}

