/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.scheduler;

public class TickSignal {
    private int m_second;
    private int m_minute;
    private int m_hour;
    private int m_dayOfWeek;
    private int m_day;
    private int m_dayOfMonthReverse;
    private int m_dayOfYear;
    private int m_week;
    private int m_month;
    private int m_year;
    private int m_secondOfDay;

    public TickSignal(int second, int minute, int hour, int dayOfWeek, int day, int dayOfMonthReverse, int dayOfYear, int week, int month, int year) {
        this.m_second = second;
        this.m_minute = minute;
        this.m_hour = hour;
        this.m_dayOfWeek = dayOfWeek;
        this.m_day = day;
        this.m_dayOfMonthReverse = dayOfMonthReverse;
        this.m_dayOfYear = dayOfYear;
        this.m_week = week;
        this.m_month = month;
        this.m_year = year;
        this.m_secondOfDay = this.m_hour * 3600 + this.m_minute * 60 + this.m_second;
    }

    public int getSecond() {
        return this.m_second;
    }

    public int getMinute() {
        return this.m_minute;
    }

    public int getHour() {
        return this.m_hour;
    }

    public int getDayOfWeek() {
        return this.m_dayOfWeek;
    }

    public int getDay() {
        return this.m_day;
    }

    public int getDayOfMonthReverse() {
        return this.m_dayOfMonthReverse;
    }

    public int getDayOfYear() {
        return this.m_dayOfYear;
    }

    public int getWeek() {
        return this.m_week;
    }

    public int getMonth() {
        return this.m_month;
    }

    public int getYear() {
        return this.m_year;
    }

    public int getSecondOfDay() {
        return this.m_secondOfDay;
    }

    public String getTextShort() {
        return String.valueOf(this.formatAsDoubleDigit(this.m_day)) + "." + this.formatAsDoubleDigit(this.m_month) + "." + this.m_year + " " + this.formatAsDoubleDigit(this.m_hour) + ":" + this.formatAsDoubleDigit(this.m_minute) + ":" + this.formatAsDoubleDigit(this.m_second);
    }

    public String getTextLong() {
        return String.valueOf(this.formatAsDoubleDigit(this.m_day)) + "." + this.formatAsDoubleDigit(this.m_month) + "." + this.m_year + " " + this.formatAsDoubleDigit(this.m_hour) + ":" + this.formatAsDoubleDigit(this.m_minute) + ":" + this.formatAsDoubleDigit(this.m_second) + " dayOfWeek=" + this.m_dayOfWeek + " dayOfMonthReverse=" + this.m_dayOfMonthReverse + " week=" + this.m_week + " dayOfYear=" + this.m_dayOfYear;
    }

    public String toString() {
        return "TickSignal[" + this.getTextLong() + "]";
    }

    private String formatAsDoubleDigit(int i) {
        String s = "" + (i + 100);
        return s.substring(s.length() - 2);
    }
}

